/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;

public class PropertiesHelper {
    public static Map<String, String> asMap(Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string = StringHelper.trimToNull((Object)entry.getKey());
                if (string == null) continue;
                hashMap.put(string, StringHelper.trimToNull((Object)entry.getValue()));
            }
        }
        return hashMap;
    }

    public static Properties from(InputStream inputStream) {
        return PropertiesHelper.from(inputStream == null ? null : new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public static Properties from(Reader reader) {
        Properties properties = new Properties(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Object put(Object object, Object object2) {
                if (object2 != null) {
                    object2 = object2.toString().replace('\u00a0', ' ').trim();
                }
                return super.put(object, StringHelper.trim((Object)object2));
            }
        };
        if (reader != null) {
            try {
                properties.load(reader);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            finally {
                IOHelper.close((Closeable)reader);
            }
        }
        return properties;
    }

    public static Properties from(String string) {
        return PropertiesHelper.from(string == null ? null : new StringReader(string));
    }

    public static Properties getSubProperties(Properties properties, String string) {
        Properties properties2 = new Properties();
        if (properties != null && string != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string2;
                String string3 = (String)entry.getKey();
                if (!string3.startsWith(string) || (string2 = StringHelper.trimToNull((Object)entry.getValue())) == null) continue;
                properties2.setProperty(StringHelper.removeStart((String)string3, (String)string), string2);
            }
        }
        return properties2;
    }

    public static String toString(Properties properties) {
        if (CollectionHelper.isEmpty((Map)properties)) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        try {
            properties.store(stringWriter, null);
        }
        catch (IOException iOException) {
            return "";
        }
        return stringWriter.toString();
    }
}

