/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;

public class InternetAddressHelper {
    private static final Pattern HOSTNAME_PART = Pattern.compile("[a-z|A-Z|0-9|-]{1,63}");

    public static boolean isHostname(String string) {
        if (StringUtils.isEmpty((CharSequence)string) || string.length() > 255) {
            return false;
        }
        String[] stringArray = StringUtils.split((String)string, (char)'.');
        boolean bl = true;
        for (String string2 : stringArray) {
            if (!HOSTNAME_PART.matcher(string2).matches()) {
                return false;
            }
            if (StringUtils.isNumeric((CharSequence)string2)) continue;
            bl = false;
        }
        return !bl;
    }

    public static boolean isInternetAddressList(String string) {
        String[] stringArray;
        for (String string2 : stringArray = StringUtils.split((String)string, (String)"\r\n")) {
            if ((string2 = StringUtils.trimToNull((String)string2)) == null || string2.charAt(0) == '#' || InternetAddressHelper.isHostname(string2) || InternetAddressHelper.isIpAddress(string2) || InternetAddressHelper.isIpRange(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIpAddress(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return InetAddressValidator.getInstance().isValid(string);
    }

    public static boolean isIpRange(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (StringUtils.containsOnly((CharSequence)string, (String)"0123456789.-")) {
            String[] stringArray = StringUtils.split((String)string, (char)'.');
            if (stringArray.length != 4) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (i == 3) {
                    String[] stringArray2 = StringUtils.split((String)string2, (char)'-');
                    if (stringArray2.length != 2) {
                        return false;
                    }
                    String string3 = stringArray2[0];
                    String string4 = stringArray2[1];
                    return InternetAddressHelper.isValidIpPart(string3) && InternetAddressHelper.isValidIpPart(string4);
                }
                if (InternetAddressHelper.isValidIpPart(string2)) continue;
                return false;
            }
        }
        return false;
    }

    public static String normalize(String string) {
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String padAddress(String string) {
        if (!InternetAddressHelper.isIpAddress(string)) {
            throw new IllegalArgumentException("Was expecting an IP address, but received \"" + string + "\"");
        }
        Object[] objectArray = StringUtils.split((String)string, (char)'.');
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = StringUtils.leftPad((String)objectArray[i], (int)3, (char)'0');
        }
        return StringUtils.join((Object[])objectArray, (char)'.');
    }

    public static AddressType resolveAddressType(String string) {
        if (InternetAddressHelper.isIpAddress(string)) {
            return AddressType.SIMPLE_IP;
        }
        if (InternetAddressHelper.isIpRange(string)) {
            return AddressType.IP_RANGE;
        }
        if (InternetAddressHelper.isHostname(string)) {
            return AddressType.HOSTNAME;
        }
        return null;
    }

    public static Set<String> resolveAll(String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        StringHelper.forEachLine((String)string2, (boolean)true, string -> {
            try {
                List<String> list = InternetAddressHelper.flattenRange(string);
                hashSet.addAll(list);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    for (InetAddress inetAddress : InetAddress.getAllByName(string)) {
                        hashSet.add(inetAddress.getHostAddress());
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        });
        return hashSet;
    }

    private static List<String> flattenRange(String string) {
        int n;
        if (!InternetAddressHelper.isIpRange(string)) {
            throw new IllegalArgumentException("Was expecting an IP range, but received \"" + string + "\"");
        }
        String[] stringArray = StringUtils.split((String)string, (String)".");
        String[] stringArray2 = StringUtils.split((String)stringArray[3], (String)"-");
        for (int i = 0; i < 3; ++i) {
            stringArray[i] = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)StringUtils.stripStart((String)stringArray[i], (String)"0")), (Object)"0");
        }
        ArrayList<CallSite> arrayList = null;
        int n2 = Integer.parseInt(stringArray2[0]);
        if (n2 <= (n = Integer.parseInt(stringArray2[1]))) {
            arrayList = new ArrayList<CallSite>(n - n2 + 1);
            for (int i = n2; i <= n; ++i) {
                try {
                    arrayList.add((CallSite)((Object)(stringArray[0] + "." + stringArray[1] + "." + stringArray[2] + "." + i)));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (List)ObjectHelper.defaultValue(arrayList, Collections.emptyList());
    }

    private static boolean isValidIpPart(String string) {
        try {
            int n = Integer.parseInt(string);
            return n >= 0 && n <= 255;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static enum AddressType {
        HOSTNAME,
        SIMPLE_IP,
        IP_RANGE;

    }
}

