/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cyclos.model.FrameworkException;
import org.cyclos.utils.CollectionHelper;

public class AggregatedFrameworkExceptions
extends FrameworkException {
    private static final long serialVersionUID = 1L;
    private Map<String, FrameworkException> exceptions;
    private Map<String, List<FrameworkException>> indexedExceptions;

    public void add(String string2, FrameworkException frameworkException) {
        if (this.indexedExceptions == null) {
            this.indexedExceptions = new HashMap<String, List<FrameworkException>>();
        }
        this.indexedExceptions.computeIfAbsent(string2, string -> new ArrayList()).add(frameworkException);
    }

    public Map<String, FrameworkException> getExceptions() {
        return this.exceptions;
    }

    public Map<String, List<FrameworkException>> getIndexedExceptions() {
        return this.indexedExceptions;
    }

    public String getMessage() {
        return this.toString();
    }

    public void set(String string, FrameworkException frameworkException) {
        if (this.exceptions == null) {
            this.exceptions = new HashMap<String, FrameworkException>();
        }
        this.exceptions.put(string, frameworkException);
    }

    public void setExceptions(Map<String, FrameworkException> map) {
        this.exceptions = map;
    }

    public void setIndexedExceptions(Map<String, List<FrameworkException>> map) {
        this.indexedExceptions = map;
    }

    public void throwIfHasExceptions() throws AggregatedFrameworkExceptions {
        if (CollectionHelper.isNotEmpty(this.getExceptions())) {
            throw this;
        }
        if (this.indexedExceptions != null) {
            for (List<FrameworkException> list : this.indexedExceptions.values()) {
                if (!list.stream().filter(Objects::nonNull).findAny().isPresent()) continue;
                throw this;
            }
        }
    }

    public String toString() {
        Map<String, List<FrameworkException>> map;
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, FrameworkException> map2 = this.getExceptions();
        if (CollectionHelper.isNotEmpty(map2)) {
            map2.forEach((string, frameworkException) -> {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append((String)string).append(' ').append(frameworkException);
            });
        }
        if (CollectionHelper.isNotEmpty(map = this.getIndexedExceptions())) {
            map.forEach((string, list) -> {
                if (CollectionHelper.isNotEmpty((Iterable)list) && list.stream().anyMatch(Objects::nonNull)) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append((String)string).append(' ').append(list);
                }
            });
        }
        return stringBuilder.toString();
    }
}

