/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.net;

import com.hazelcast.internal.tpcengine.util.UnsafeLocator;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class AsyncSocketMetrics {
    private static final Unsafe UNSAFE = UnsafeLocator.UNSAFE;
    private static final long OFFSET_bytesRead;
    private static final long OFFSET_bytesWritten;
    private static final long OFFSET_writeEvents;
    private static final long OFFSET_readEvents;
    private volatile long bytesRead;
    private volatile long bytesWritten;
    private volatile long writeEvents;
    private volatile long readEvents;

    private static long getOffset(String fieldName) throws NoSuchFieldException {
        Field field = AsyncSocketMetrics.class.getDeclaredField(fieldName);
        return UNSAFE.objectFieldOffset(field);
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public void incBytesRead(long delta) {
        UNSAFE.putOrderedLong(this, OFFSET_bytesRead, this.bytesRead + delta);
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public void incBytesWritten(long delta) {
        UNSAFE.putOrderedLong(this, OFFSET_bytesWritten, this.bytesWritten + delta);
    }

    public long writeEvents() {
        return this.writeEvents;
    }

    public void incWriteEvents() {
        UNSAFE.putOrderedLong(this, OFFSET_writeEvents, this.writeEvents + 1L);
    }

    public long readEvents() {
        return this.readEvents;
    }

    public void incReadEvents() {
        UNSAFE.putOrderedLong(this, OFFSET_readEvents, this.readEvents + 1L);
    }

    static {
        try {
            OFFSET_bytesRead = AsyncSocketMetrics.getOffset("bytesRead");
            OFFSET_bytesWritten = AsyncSocketMetrics.getOffset("bytesWritten");
            OFFSET_writeEvents = AsyncSocketMetrics.getOffset("writeEvents");
            OFFSET_readEvents = AsyncSocketMetrics.getOffset("readEvents");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

