/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public class PartitioningAttributeConfig
implements IdentifiedDataSerializable {
    private String attributeName;

    public PartitioningAttributeConfig() {
    }

    public PartitioningAttributeConfig(PartitioningAttributeConfig config) {
        this.attributeName = config.attributeName;
    }

    public PartitioningAttributeConfig(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = Preconditions.checkHasText(attributeName, "AttributeName must not be empty");
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.attributeName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributeName = in.readString();
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 69;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitioningAttributeConfig that = (PartitioningAttributeConfig)o;
        return Objects.equals(this.attributeName, that.attributeName);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName);
    }

    public String toString() {
        return "PartitioningAttributeConfig{attributeName='" + this.attributeName + '\'' + '}';
    }
}

