/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import java.util.ArrayList;
import java.util.List;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.nodes.Node;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.nodes.ScalarNode;
import nl.basjes.parse.useragent.yauaa.shaded.org.yaml.snakeyaml.nodes.SequenceNode;

public final class YamlUtils {
    private YamlUtils() {
    }

    public static void requireNodeInstanceOf(Class<?> clazz, Node node, String filename, String error) {
        if (!clazz.isInstance(node)) {
            throw new InvalidParserConfigurationException(YamlUtils.createErrorString(node, filename, error));
        }
    }

    public static void require(boolean condition, Node node, String filename, String error) {
        if (!condition) {
            throw new InvalidParserConfigurationException(YamlUtils.createErrorString(node, filename, error));
        }
    }

    private static String createErrorString(Node node, String filename, String error) {
        return "Yaml config problem.(" + filename + ":" + node.getStartMark().getLine() + "): " + error;
    }

    public static NodeTuple getExactlyOneNodeTuple(MappingNode mappingNode, String filename) {
        List<NodeTuple> nodeTupleList = mappingNode.getValue();
        YamlUtils.require(nodeTupleList.size() == 1, mappingNode, filename, "There must be exactly 1 value in the list");
        return nodeTupleList.get(0);
    }

    public static String getKeyAsString(NodeTuple tuple, String filename) {
        Node keyNode = tuple.getKeyNode();
        YamlUtils.requireNodeInstanceOf(ScalarNode.class, keyNode, filename, "The key should be a string but it is a " + keyNode.getNodeId().name());
        return ((ScalarNode)keyNode).getValue();
    }

    public static String getValueAsString(NodeTuple tuple, String filename) {
        Node valueNode = tuple.getValueNode();
        YamlUtils.requireNodeInstanceOf(ScalarNode.class, valueNode, filename, "The value should be a string but it is a " + valueNode.getNodeId().name());
        return ((ScalarNode)valueNode).getValue();
    }

    public static MappingNode getValueAsMappingNode(NodeTuple tuple, String filename) {
        Node valueNode = tuple.getValueNode();
        YamlUtils.requireNodeInstanceOf(MappingNode.class, valueNode, filename, "The value should be a map but it is a " + valueNode.getNodeId().name());
        return (MappingNode)valueNode;
    }

    public static SequenceNode getValueAsSequenceNode(NodeTuple tuple, String filename) {
        Node valueNode = tuple.getValueNode();
        YamlUtils.requireNodeInstanceOf(SequenceNode.class, valueNode, filename, "The value should be a sequence but it is a " + valueNode.getNodeId().name());
        return (SequenceNode)valueNode;
    }

    public static List<String> getStringValues(Node sequenceNode, String filename) {
        YamlUtils.requireNodeInstanceOf(SequenceNode.class, sequenceNode, filename, "The provided node must be a sequence but it is a " + sequenceNode.getNodeId().name());
        List<Node> valueNodes = ((SequenceNode)sequenceNode).getValue();
        ArrayList<String> values = new ArrayList<String>(valueNodes.size());
        for (Node node : valueNodes) {
            YamlUtils.requireNodeInstanceOf(ScalarNode.class, node, filename, "The value should be a string but it is a " + node.getNodeId().name());
            values.add(((ScalarNode)node).getValue());
        }
        return values;
    }
}

