/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.SystemMonitorServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.monitor.BackgroundTaskData;
import org.cyclos.model.system.monitor.BackgroundTaskQuery;
import org.cyclos.model.system.monitor.CacheQuery;
import org.cyclos.model.system.monitor.DatabaseUpgradeData;
import org.cyclos.model.system.monitor.DatabaseUpgradeQuery;
import org.cyclos.model.system.monitor.RecurringTaskData;
import org.cyclos.model.system.monitor.RecurringTaskQuery;
import org.cyclos.model.system.monitor.SystemInformationData;
import org.cyclos.model.system.monitor.SystemMonitorExportResult;
import org.cyclos.model.utils.CacheVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.SystemMonitorService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class SystemMonitorServiceSecurity
extends BaseServiceSecurity
implements SystemMonitorService {
    @Autowired
    private SystemMonitorServiceLocal systemMonitorServiceLocal;

    public void archiveData() throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        this.systemMonitorServiceLocal.archiveData();
    }

    public void clearCache(String string) throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        this.systemMonitorServiceLocal.clearCache(string);
    }

    public SystemMonitorExportResult export() throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        return this.systemMonitorServiceLocal.export();
    }

    public SystemInformationData getSystemInformation(List<String> list) throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        return this.systemMonitorServiceLocal.getSystemInformation(list);
    }

    public List<BackgroundTaskData> listBackgroundTasks(BackgroundTaskQuery backgroundTaskQuery) throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        return this.systemMonitorServiceLocal.listBackgroundTasks(backgroundTaskQuery);
    }

    public List<CacheVO> listCaches(CacheQuery cacheQuery) throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        return this.systemMonitorServiceLocal.listCaches(cacheQuery);
    }

    public List<RecurringTaskData> listRecurringTasks(RecurringTaskQuery recurringTaskQuery) throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        return this.systemMonitorServiceLocal.listRecurringTasks(recurringTaskQuery);
    }

    public void rebuildClosedAccountBalances() throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        this.systemMonitorServiceLocal.rebuildClosedAccountBalances();
    }

    public void scheduleExecution(String string) throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        this.systemMonitorServiceLocal.scheduleExecution(string);
    }

    public Page<DatabaseUpgradeData> searchDatabaseHistoryLogs(DatabaseUpgradeQuery databaseUpgradeQuery) throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        return this.systemMonitorServiceLocal.searchDatabaseHistoryLogs(databaseUpgradeQuery);
    }

    public void vacuumDatabase() throws FrameworkException {
        this.checkLoggedGlobalAdmin();
        this.systemMonitorServiceLocal.vacuumDatabase();
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void checkLoggedGlobalAdmin() {
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (basicUser == null || !basicUser.isGlobalAdmin()) {
            throw new PermissionDeniedException();
        }
    }
}

