/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.system.CustomWizardField;
import org.cyclos.entities.system.CustomWizardFieldPossibleValue;
import org.cyclos.entities.system.CustomWizardFieldPossibleValueCategory;
import org.cyclos.impl.system.CustomWizardFieldServiceLocal;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.wizardfields.CustomWizardFieldDTO;
import org.cyclos.model.system.wizardfields.CustomWizardFieldData;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseCustomFieldServiceSecurity;
import org.cyclos.security.system.CustomWizardServiceSecurity;
import org.cyclos.services.system.CustomWizardFieldService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class CustomWizardFieldServiceSecurity
extends BaseCustomFieldServiceSecurity<CustomWizardFieldDTO, CustomWizardField, CustomWizardFieldPossibleValueCategory, CustomWizardFieldPossibleValue, CustomWizardFieldData, CustomWizardVO>
implements CustomWizardFieldService {
    @Autowired
    private CustomWizardFieldServiceLocal customWizardFieldService;
    @Autowired
    private CustomWizardServiceSecurity customWizardServiceSecurity;

    public CustomWizardFieldServiceSecurity() {
        super(CustomWizardField.class);
    }

    @Override
    public boolean doHasManageAccess(CustomWizardField customWizardField) {
        return this.customWizardServiceSecurity.hasManageAccess(customWizardField.getWizard());
    }

    @Override
    public boolean doHasViewAccess(CustomWizardField customWizardField) {
        return this.customWizardServiceSecurity.hasViewAccess(customWizardField.getWizard());
    }

    public List<CustomFieldVO> list(CustomWizardVO customWizardVO) {
        CustomWizard customWizard = (CustomWizard)this.conversionHandler.convert(CustomWizard.class, (Object)customWizardVO);
        this.customWizardServiceSecurity.checkViewAccess(customWizard);
        return this.customWizardFieldService.list(customWizardVO);
    }

    @Override
    protected void checkCreateNew(CustomWizardVO customWizardVO) {
        CustomWizard customWizard = (CustomWizard)this.conversionHandler.convert(CustomWizard.class, (Object)customWizardVO);
        this.customWizardServiceSecurity.checkManageAccess(customWizard);
    }

    protected CustomWizardFieldServiceLocal getImplementation() {
        return this.customWizardFieldService;
    }
}

