/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.system.Image;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.system.BaseImageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.BaseImageService;

public abstract class BaseImageServiceSecurity<I extends Image, NP>
extends BaseServiceSecurity
implements BaseImageService<NP> {
    protected final Class<I> imageType;

    public BaseImageServiceSecurity(Class<I> clazz) {
        this.imageType = clazz;
    }

    public ImageNature getImageNature() {
        return this.getImplementation().getImageNature();
    }

    public abstract boolean hasManageAccess(I var1);

    public final void remove(@NotNull Long l) throws FrameworkException {
        I i = this.find(l);
        this.checkManageAccess(i);
        this.getImplementation().remove(l);
    }

    public void removeAll(@NotNull Collection<Long> collection) throws FrameworkException {
        for (Long l : collection) {
            I i = this.find(l);
            this.checkManageAccess(i);
        }
        this.getImplementation().removeAll(collection);
    }

    public final ImageVO save(NP NP, String string, SerializableInputStream serializableInputStream, String string2) throws FrameworkException {
        this.checkCreateNew(NP);
        return this.getImplementation().save(NP, string, serializableInputStream, string2);
    }

    public final void saveName(@NotNull Long l, String string) throws FrameworkException {
        I i = this.find(l);
        this.checkManageAccess(i);
        this.getImplementation().saveName(l, string);
    }

    protected abstract void checkCreateNew(NP var1);

    protected void checkManageAccess(I i) {
        if (!this.hasManageAccess(i)) {
            throw new PermissionDeniedException();
        }
    }

    protected I find(Long l) {
        return (I)((Image)this.find(this.imageType, l));
    }

    protected abstract BaseImageServiceLocal<I, NP> getImplementation();

    @Override
    protected final EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

