/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.system.ICategorizedImage;
import org.cyclos.entities.system.Image;
import org.cyclos.impl.system.BaseCategorizedImageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.ImagesListData;
import org.cyclos.security.system.BaseImageServiceSecurity;
import org.cyclos.services.system.BaseCategorizedImageService;

public abstract class BaseCategorizedImageServiceSecurity<I extends Image, C extends BaseEntity, NP extends IEntity>
extends BaseImageServiceSecurity<I, NP>
implements BaseCategorizedImageService<NP> {
    protected final Class<C> categoryType;

    public BaseCategorizedImageServiceSecurity(Class<I> clazz, Class<C> clazz2) {
        super(clazz);
        this.categoryType = clazz2;
    }

    public final ImagesListData getListData(@NotNull NP NP) throws FrameworkException {
        C c = this.toCategory(NP);
        this.checkListImagesOf(c);
        ImagesListData imagesListData = this.getImplementation().getListData(NP);
        imagesListData.setCanManage(imagesListData.isCanManage() && this.canManageImagesOf(c));
        imagesListData.setCanCreate(imagesListData.isCanCreate() && imagesListData.isCanManage());
        return imagesListData;
    }

    @Override
    public final boolean hasManageAccess(I i) {
        return this.canManageImagesOf(((ICategorizedImage)i).getCategory());
    }

    public final List<ImageVO> list(@NotNull NP NP) throws FrameworkException {
        C c = this.toCategory(NP);
        this.checkListImagesOf(c);
        return this.getImplementation().list(NP);
    }

    protected abstract boolean canListImagesOf(C var1);

    protected abstract boolean canManageImagesOf(C var1);

    @Override
    protected final void checkCreateNew(NP NP) {
        C c = this.toCategory(NP);
        this.checkManageImagesOf(c);
    }

    protected void checkListImagesOf(C c) {
        if (!this.canListImagesOf(c)) {
            throw new PermissionDeniedException();
        }
    }

    protected void checkManageImagesOf(C c) {
        if (!this.canManageImagesOf(c)) {
            throw new PermissionDeniedException();
        }
    }

    protected abstract BaseCategorizedImageServiceLocal<I, C, NP> getImplementation();

    protected C toCategory(NP NP) {
        return (C)((BaseEntity)this.conversionHandler.convert(this.categoryType, NP));
    }
}

