/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.marketplace;

import java.util.List;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.model.access.Permission;
import org.cyclos.model.marketplace.categories.AdCategoryDTO;
import org.cyclos.model.marketplace.categories.AdCategoryData;
import org.cyclos.model.marketplace.categories.AdCategoryDetailedVO;
import org.cyclos.model.marketplace.categories.AdCategoryQuery;
import org.cyclos.model.marketplace.categories.AdCategoryVO;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleConfigurationEntityCRUDServiceSecurity;
import org.cyclos.services.marketplace.AdCategoryService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AdCategoryServiceSecurity
extends SimpleConfigurationEntityCRUDServiceSecurity<AdCategoryDTO, AdCategory, AdCategoryData, AdCategoryVO>
implements AdCategoryService {
    @Autowired
    private AdCategoryServiceLocal adCategoryService;

    public AdCategoryServiceSecurity() {
        super(AdCategory.class, Permission.AD_CONFIGURATION_VIEW, Permission.AD_CONFIGURATION_MANAGE);
    }

    public void saveCategories(List<AdCategoryDTO> list) {
        this.checkManagePermission();
        this.adCategoryService.saveCategories(list);
    }

    public void saveOrder(List<Long> list) {
        this.checkManagePermission();
        this.adCategoryService.saveOrder(list);
    }

    public Page<AdCategoryDetailedVO> search(AdCategoryQuery adCategoryQuery) {
        this.checkViewPermission();
        return this.adCategoryService.search(adCategoryQuery);
    }

    public void sortAlphabetically(AdCategoryVO adCategoryVO) {
        this.checkManagePermission();
        this.adCategoryService.sortAlphabetically(adCategoryVO);
    }

    protected AdCategoryServiceLocal getImplementation() {
        return this.adCategoryService;
    }
}

