/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import javax.validation.constraints.NotNull;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.RecurringPaymentOccurrence;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionWithInstallments;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.banking.RecurringPaymentServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformRecurringPaymentDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentActionDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentData;
import org.cyclos.model.banking.transactions.RecurringPaymentEditData;
import org.cyclos.model.banking.transactions.RecurringPaymentPreviewVO;
import org.cyclos.model.banking.transactions.RecurringPaymentVO;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.security.banking.ScheduledPaymentServiceSecurity;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.services.banking.RecurringPaymentService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class RecurringPaymentServiceSecurity
extends BaseServiceSecurity
implements RecurringPaymentService {
    @Autowired
    private RecurringPaymentServiceLocal recurringPaymentService;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private ScheduledPaymentServiceSecurity scheduledPaymentServiceSecurity;

    public void block(RecurringPaymentActionDTO recurringPaymentActionDTO) throws FrameworkException {
        RecurringPayment recurringPayment = this.checkAccess(recurringPaymentActionDTO);
        if (!this.scheduledPaymentServiceSecurity.canBlock((TransactionWithInstallments<?>)recurringPayment)) {
            throw new PermissionDeniedException();
        }
        this.recurringPaymentService.block(recurringPaymentActionDTO);
    }

    public void cancel(RecurringPaymentActionDTO recurringPaymentActionDTO) throws FrameworkException {
        RecurringPayment recurringPayment = this.checkAccess(recurringPaymentActionDTO);
        if (!this.scheduledPaymentServiceSecurity.canCancel((TransactionWithInstallments<?>)recurringPayment)) {
            throw new PermissionDeniedException();
        }
        this.recurringPaymentService.cancel(recurringPaymentActionDTO);
    }

    public RecurringPaymentData getData(Long l) throws FrameworkException {
        RecurringPayment recurringPayment = this.find(l);
        RecurringPaymentData recurringPaymentData = this.recurringPaymentService.getData(l);
        return this.postProcess(recurringPayment, recurringPaymentData);
    }

    public RecurringPaymentEditData getEditData(@NotNull RecurringPaymentVO recurringPaymentVO) throws FrameworkException {
        RecurringPayment recurringPayment = (RecurringPayment)this.conversionHandler.convert(RecurringPayment.class, (Object)recurringPaymentVO);
        RecurringPaymentEditData recurringPaymentEditData = this.recurringPaymentService.getEditData(recurringPaymentVO);
        return this.postProcess(recurringPayment, recurringPaymentEditData);
    }

    public boolean isAccessible(RecurringPayment recurringPayment) {
        boolean bl = false;
        bl = recurringPayment.getToOwner() != null && recurringPayment.getToOwner().equals((Object)this.getLoggedUser()) ? recurringPayment.isReceived() || recurringPayment.isShowToReceiver() : this.transactionServiceSecurity.isAccessible(recurringPayment.getFromOwner(), TransactionNature.RECURRING_PAYMENT) || this.transactionServiceSecurity.isAccessible(recurringPayment.getToOwner(), TransactionNature.RECURRING_PAYMENT);
        return bl && (this.accountServiceSecurity.hasAccess(recurringPayment.getFrom()) || this.accountServiceSecurity.hasAccess(recurringPayment.getTo()));
    }

    public void modify(@NotNull RecurringPaymentDTO recurringPaymentDTO, String string) throws FrameworkException {
        RecurringPayment recurringPayment = this.find(recurringPaymentDTO.getId());
        if (!this.scheduledPaymentServiceSecurity.canModify((TransactionWithInstallments<?>)recurringPayment)) {
            throw new PermissionDeniedException();
        }
        this.recurringPaymentService.modify(recurringPaymentDTO, string);
    }

    public RecurringPaymentVO perform(PerformRecurringPaymentDTO performRecurringPaymentDTO) throws FrameworkException {
        PaymentTransferType paymentTransferType = this.transactionServiceSecurity.checkPerform((PerformInternalTransactionDTO)performRecurringPaymentDTO);
        performRecurringPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        return this.recurringPaymentService.perform(performRecurringPaymentDTO);
    }

    public <D extends RecurringPaymentData> D postProcess(RecurringPayment recurringPayment, D d) {
        this.updateCommonData(d, recurringPayment);
        return this.transactionServiceSecurity.postProcessTransactionData((Transaction)recurringPayment, d);
    }

    public RecurringPaymentPreviewVO preview(PerformRecurringPaymentDTO performRecurringPaymentDTO) throws FrameworkException {
        PaymentTransferType paymentTransferType = this.transactionServiceSecurity.checkPerform((PerformInternalTransactionDTO)performRecurringPaymentDTO);
        performRecurringPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        return this.recurringPaymentService.preview(performRecurringPaymentDTO);
    }

    public RecurringPaymentPreviewVO previewReceive(PerformRecurringPaymentDTO performRecurringPaymentDTO) throws FrameworkException, TransferException {
        this.transactionServiceSecurity.checkReceive((PerformInternalTransactionDTO)performRecurringPaymentDTO);
        return this.recurringPaymentService.previewReceive(performRecurringPaymentDTO);
    }

    public TransferVO processFailure(@NotNull InstallmentActionDTO installmentActionDTO) throws FrameworkException, TransferException {
        RecurringPaymentOccurrence recurringPaymentOccurrence = (RecurringPaymentOccurrence)this.conversionHandler.convert(RecurringPaymentOccurrence.class, (Object)installmentActionDTO.getInstallment());
        RecurringPayment recurringPayment = recurringPaymentOccurrence.getRecurringPayment();
        this.checkProcessFailure(recurringPayment);
        return this.recurringPaymentService.processFailure(installmentActionDTO);
    }

    public RecurringPaymentVO receive(PerformRecurringPaymentDTO performRecurringPaymentDTO) throws FrameworkException, TransferException {
        this.transactionServiceSecurity.checkReceive((PerformInternalTransactionDTO)performRecurringPaymentDTO);
        return this.recurringPaymentService.receive(performRecurringPaymentDTO);
    }

    public void unblock(RecurringPaymentActionDTO recurringPaymentActionDTO) throws FrameworkException {
        RecurringPayment recurringPayment = this.checkAccess(recurringPaymentActionDTO);
        if (!this.scheduledPaymentServiceSecurity.canUnblock((TransactionWithInstallments<?>)recurringPayment)) {
            throw new PermissionDeniedException();
        }
        this.recurringPaymentService.unblock(recurringPaymentActionDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private RecurringPayment checkAccess(RecurringPaymentActionDTO recurringPaymentActionDTO) {
        return (RecurringPayment)this.conversionHandler.convert(RecurringPayment.class, (Object)recurringPaymentActionDTO.getRecurringPayment());
    }

    private void checkProcessFailure(RecurringPayment recurringPayment) {
        if (!this.scheduledPaymentServiceSecurity.canProcessInstallments((TransactionWithInstallments<?>)recurringPayment)) {
            throw new PermissionDeniedException();
        }
        this.transactionServiceSecurity.check(this.accountHandler.locate((AccountOwner)recurringPayment.getFromOwner()), this.accountHandler.locate((AccountOwner)recurringPayment.getToOwner()), recurringPayment.getType());
    }

    private RecurringPayment find(Long l) {
        return this.find(RecurringPayment.class, l);
    }

    private void updateCommonData(RecurringPaymentData recurringPaymentData, RecurringPayment recurringPayment) {
        recurringPaymentData.setCanCancel(recurringPaymentData.isCanCancel() && this.scheduledPaymentServiceSecurity.canCancel((TransactionWithInstallments<?>)recurringPayment));
        recurringPaymentData.setCanModify(recurringPaymentData.isCanModify() && this.scheduledPaymentServiceSecurity.canModify((TransactionWithInstallments<?>)recurringPayment));
        recurringPaymentData.setCanBlock(recurringPaymentData.isCanBlock() && this.scheduledPaymentServiceSecurity.canBlock((TransactionWithInstallments<?>)recurringPayment));
        recurringPaymentData.setCanUnblock(recurringPaymentData.isCanUnblock() && this.scheduledPaymentServiceSecurity.canUnblock((TransactionWithInstallments<?>)recurringPayment));
        if (recurringPaymentData.isCanProcessFailed()) {
            try {
                this.checkProcessFailure(recurringPayment);
            }
            catch (PermissionDeniedException permissionDeniedException) {
                recurringPaymentData.setCanProcessFailed(false);
            }
        }
    }
}

