/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.OidcServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.server.model.access.oidc.AuthorizeRequest;
import org.cyclos.server.model.access.oidc.AuthorizeResponse;
import org.cyclos.server.model.access.oidc.ConsentData;
import org.cyclos.server.model.access.oidc.ConsentParams;
import org.cyclos.server.model.access.oidc.OpenidConfiguration;
import org.cyclos.server.model.access.oidc.RegisterRequest;
import org.cyclos.server.model.access.oidc.RegisterResponse;
import org.cyclos.server.model.access.oidc.RevokeRequest;
import org.cyclos.server.model.access.oidc.TokenRequest;
import org.cyclos.server.model.access.oidc.TokenResponse;
import org.cyclos.services.access.OidcException;
import org.cyclos.services.access.OidcRegisterException;
import org.cyclos.services.access.OidcService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class OidcServiceSecurity
extends BaseServiceSecurity
implements OidcService {
    @Autowired
    private OidcServiceLocal oidcService;

    public AuthorizeResponse approve(ConsentParams consentParams) throws FrameworkException {
        this.checkGuest();
        return this.oidcService.approve(consentParams);
    }

    public AuthorizeResponse authorize(AuthorizeRequest authorizeRequest) throws FrameworkException, OidcException {
        this.checkGuest();
        return this.oidcService.authorize(authorizeRequest);
    }

    public AuthorizeResponse deny(String string) throws FrameworkException {
        this.checkGuest();
        return this.oidcService.deny(string);
    }

    public ConsentData getConsentData(String string) throws FrameworkException {
        this.checkGuest();
        return this.oidcService.getConsentData(string);
    }

    public OpenidConfiguration getOpenidConfiguration() throws FrameworkException {
        this.checkGuest();
        return this.oidcService.getOpenidConfiguration();
    }

    public Object getPublicKeys() throws FrameworkException {
        this.checkGuest();
        return this.oidcService.getPublicKeys();
    }

    public RegisterResponse register(@NotNull RegisterRequest registerRequest) throws FrameworkException, OidcRegisterException {
        this.checkGuest();
        return this.oidcService.register(registerRequest);
    }

    public void revoke(RevokeRequest revokeRequest) {
        this.checkGuest();
        this.oidcService.revoke(revokeRequest);
    }

    public TokenResponse token(@NotNull TokenRequest tokenRequest) throws FrameworkException {
        this.checkGuest();
        return this.oidcService.token(tokenRequest);
    }

    public Map<String, Object> userInfo() throws FrameworkException, OidcException {
        SessionData sessionData = this.getSessionData();
        OidcAccessToken oidcAccessToken = sessionData.getAccessToken();
        if (oidcAccessToken == null) {
            throw new PermissionDeniedException("For accessing the userinfo, the authentication must be with an access token");
        }
        Set set = oidcAccessToken.getAuthorization().getScopes();
        if (!set.contains(Scope.OPENID)) {
            throw new PermissionDeniedException("For accessing the userinfo, the openid scope is required");
        }
        return this.oidcService.userInfo();
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

