/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cyclos.model.ValidationException;
import org.cyclos.utils.CollectionHelper;

public class ValidationResult
implements Serializable {
    public static final String GENERAL_ERRORS = "generalErrors";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTY_ERRORS = "propertyErrors";
    public static final String CUSTOM_FIELDS = "customFields";
    public static final String CUSTOM_FIELD_ERRORS = "customFieldErrors";
    private static final long serialVersionUID = 1L;
    private List<String> generalErrors;
    private List<String> properties;
    private Map<String, List<String>> propertyErrors;
    private List<String> customFields;
    private Map<String, List<String>> customFieldErrors;

    public ValidationResult() {
    }

    public ValidationResult(String string) {
        this.addGeneralError(string);
    }

    public ValidationResult(String string, String string2) {
        this.addPropertyError(string, string2);
    }

    public void addCustomFieldError(String string, String string2) {
        List<String> list;
        if (this.customFields == null) {
            this.customFields = new ArrayList<String>();
        }
        if (!this.customFields.contains(string)) {
            this.customFields.add(string);
        }
        if (this.customFieldErrors == null) {
            this.customFieldErrors = new HashMap<String, List<String>>();
        }
        if ((list = this.customFieldErrors.get(string)) == null) {
            list = new ArrayList<String>();
            this.customFieldErrors.put(string, list);
        }
        if (!list.contains(string2)) {
            list.add(string2);
        }
    }

    public void addGeneralError(String string) {
        if (this.generalErrors == null) {
            this.generalErrors = new ArrayList<String>();
        }
        if (!this.generalErrors.contains(string)) {
            this.generalErrors.add(string);
        }
    }

    public void addPropertyError(String string, String string2) {
        List<String> list;
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        if (!this.properties.contains(string)) {
            this.properties.add(string);
        }
        if (this.propertyErrors == null) {
            this.propertyErrors = new HashMap<String, List<String>>();
        }
        if ((list = this.propertyErrors.get(string)) == null) {
            list = new ArrayList<String>();
            this.propertyErrors.put(string, list);
        }
        if (!list.contains(string2)) {
            list.add(string2);
        }
    }

    @JsonIgnore
    public List<String> getAllErrors() {
        List<String> list;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.generalErrors != null) {
            arrayList.addAll(this.generalErrors);
        }
        if (this.properties != null) {
            for (String string : this.properties) {
                list = this.propertyErrors == null ? null : this.propertyErrors.get(string);
                if (!CollectionHelper.isNotEmpty(list)) continue;
                arrayList.addAll(list);
            }
        }
        if (this.customFields != null) {
            for (String string : this.customFields) {
                list = this.customFieldErrors == null ? null : this.customFieldErrors.get(string);
                if (!CollectionHelper.isNotEmpty(list)) continue;
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public Map<String, List<String>> getCustomFieldErrors() {
        return this.customFieldErrors;
    }

    public List<String> getCustomFieldErrors(String string) {
        return CollectionHelper.orEmpty(this.customFieldErrors == null ? null : this.customFieldErrors.get(string));
    }

    public List<String> getCustomFields() {
        return this.customFields;
    }

    @JsonIgnore
    public String getFirstError() {
        String string;
        block3: {
            List<String> list;
            Iterator<List<String>> iterator;
            string = (String)CollectionHelper.first(this.generalErrors);
            if (string == null && CollectionHelper.isNotEmpty(this.propertyErrors)) {
                iterator = this.propertyErrors.values().iterator();
                while (iterator.hasNext() && (string = (String)CollectionHelper.first(list = iterator.next())) == null) {
                }
            }
            if (string != null || !CollectionHelper.isNotEmpty(this.customFieldErrors)) break block3;
            iterator = this.customFieldErrors.values().iterator();
            while (iterator.hasNext() && (string = (String)CollectionHelper.first(list = iterator.next())) == null) {
            }
        }
        return string;
    }

    public List<String> getGeneralErrors() {
        return this.generalErrors;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public Map<String, List<String>> getPropertyErrors() {
        return this.propertyErrors;
    }

    public List<String> getPropertyErrors(String string) {
        return CollectionHelper.orEmpty(this.propertyErrors == null ? null : this.propertyErrors.get(string));
    }

    public boolean hasCustomFieldErrors() {
        return CollectionHelper.isNotEmpty(this.customFieldErrors);
    }

    public boolean hasErrors() {
        return this.hasGeneralErrors() || this.hasPropertyErrors() || this.hasCustomFieldErrors();
    }

    public boolean hasGeneralErrors() {
        return CollectionHelper.isNotEmpty(this.generalErrors);
    }

    public boolean hasPropertyErrors() {
        return CollectionHelper.isNotEmpty(this.propertyErrors);
    }

    public void merge(ValidationResult validationResult, String string) {
        if (validationResult == null) {
            return;
        }
        if (CollectionHelper.isNotEmpty(validationResult.generalErrors)) {
            if (this.generalErrors == null) {
                this.generalErrors = new ArrayList<String>();
            }
            this.generalErrors.addAll(validationResult.generalErrors);
        }
        if (CollectionHelper.isNotEmpty(validationResult.propertyErrors)) {
            if (this.propertyErrors == null) {
                this.propertyErrors = new HashMap<String, List<String>>();
            }
            for (Map.Entry<String, List<String>> entry : validationResult.propertyErrors.entrySet()) {
                Object object = entry.getKey();
                if (string != null) {
                    object = string + "." + (String)object;
                }
                this.propertyErrors.put((String)object, entry.getValue());
            }
        }
        if (CollectionHelper.isNotEmpty(validationResult.customFieldErrors)) {
            if (this.customFieldErrors == null) {
                this.customFieldErrors = new HashMap<String, List<String>>();
            }
            this.customFieldErrors.putAll(validationResult.customFieldErrors);
        }
    }

    public void setCustomFieldErrors(Map<String, List<String>> map) {
        this.customFieldErrors = map;
    }

    public void setCustomFields(List<String> list) {
        this.customFields = list;
    }

    public void setGeneralErrors(List<String> list) {
        this.generalErrors = list;
    }

    public void setProperties(List<String> list) {
        this.properties = list;
    }

    public void setPropertyErrors(Map<String, List<String>> map) {
        this.propertyErrors = map;
    }

    public void throwIfHasErrors() throws ValidationException {
        if (this.hasErrors()) {
            throw new ValidationException(this);
        }
    }

    public String toHtmlString(String string) {
        if (!this.hasErrors()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<b>").append(string).append(":</b><ul>");
        this.append(stringBuilder, this.getGeneralErrors());
        if (CollectionHelper.isNotEmpty(this.propertyErrors)) {
            CollectionHelper.orEmpty(this.properties).stream().map(this.propertyErrors::get).forEach(list -> this.append(stringBuilder, (List<String>)list));
        }
        if (CollectionHelper.isNotEmpty(this.customFieldErrors)) {
            CollectionHelper.orEmpty(this.customFields).stream().map(this.customFieldErrors::get).forEach(list -> this.append(stringBuilder, (List<String>)list));
        }
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionHelper.isNotEmpty(this.generalErrors)) {
            stringBuilder.append("General errors:\n");
            for (String string : this.generalErrors) {
                stringBuilder.append(" * ").append(string).append('\n');
            }
        }
        if (CollectionHelper.isNotEmpty(this.properties)) {
            stringBuilder.append("Property errors:\n");
            for (String string : this.properties) {
                stringBuilder.append(" * ").append(string).append('\n');
                for (String string2 : this.propertyErrors.get(string)) {
                    stringBuilder.append(" * # ").append(string2).append('\n');
                }
            }
        }
        if (CollectionHelper.isNotEmpty(this.customFields)) {
            stringBuilder.append("Custom field errors:\n");
            for (String string : this.customFields) {
                stringBuilder.append(" * ").append(string).append('\n');
                for (String string2 : this.customFieldErrors.get(string)) {
                    stringBuilder.append(" * # ").append(string2).append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    private void append(StringBuilder stringBuilder, List<String> list) {
        if (CollectionHelper.isNotEmpty(list)) {
            stringBuilder.append(list.stream().collect(Collectors.joining("</li><li>", "<li>", "</li>")));
        }
    }
}

