/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.services.access;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.InvalidSecurityAnswerException;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.passwords.ChangeForgottenPasswordDTO;
import org.cyclos.model.access.passwords.ChangeForgottenPasswordData;
import org.cyclos.model.access.passwords.ChangeGeneratedPasswordDTO;
import org.cyclos.model.access.passwords.ChangePasswordDTO;
import org.cyclos.model.access.passwords.ChangePasswordData;
import org.cyclos.model.access.passwords.ForgotPasswordRequestDTO;
import org.cyclos.model.access.passwords.GetChangeForgottenPasswordDataParams;
import org.cyclos.model.access.passwords.OtpResult;
import org.cyclos.model.access.passwords.PasswordActionDTO;
import org.cyclos.model.access.passwords.PasswordData;
import org.cyclos.model.access.passwords.ResetAndSendPasswordDTO;
import org.cyclos.model.access.passwords.SetSecurityQuestionDTO;
import org.cyclos.model.access.passwords.SetSecurityQuestionData;
import org.cyclos.model.access.passwords.UserPasswordsData;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.services.MaskValueInLog;
import org.cyclos.services.Service;

public interface PasswordService
extends Service {
    public static final int MIN_PASSWORD_LENGTH = 3;
    public static final int MAX_PASSWORD_LENGTH = 50;

    @Transaction(value=TransactionLevel.READ_WRITE)
    @MaskValueInLog
    public String activate(@NotNull PasswordTypeVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void allowActivation(@NotNull PasswordActionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void change(@NotNull ChangePasswordDTO var1) throws FrameworkException, PasswordException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void changeForgottenPassword(@NotNull ChangeForgottenPasswordDTO var1) throws FrameworkException, InvalidSecurityAnswerException, PasswordException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void disable(@NotNull PasswordActionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void enable(@NotNull PasswordActionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public OtpResult forgotPasswordRequest(@NotNull ForgotPasswordRequestDTO var1) throws FrameworkException, RemoteAddressBlockedException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    @MaskValueInLog
    public String generateNew(@NotNull ChangeGeneratedPasswordDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ChangeForgottenPasswordData getChangeForgottenPasswordData(@NotNull GetChangeForgottenPasswordDataParams var1) throws FrameworkException, PasswordException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public ChangePasswordData getChangePasswordData(boolean var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public UserPasswordsData getData(@NotNull UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public PasswordData getPasswordData(@NotNull UserLocatorVO var1, @NotNull PasswordTypeVO var2) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_ONLY)
    public SetSecurityQuestionData getSetSecurityQuestionData() throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public List<String> requestNewOTP(@NotNull SendMedium var1, String var2, List<Long> var3) throws FrameworkException, SmsSendingException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public List<String> requestNewOTPForLoginConfirmation(SendMedium var1, List<Long> var2) throws FrameworkException, SmsSendingException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void reset(@NotNull PasswordActionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void resetAndSend(@NotNull ResetAndSendPasswordDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void resetSecurityQuestion(@NotNull UserLocatorVO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void setSecurityQuestion(@NotNull SetSecurityQuestionDTO var1) throws FrameworkException;

    @Transaction(value=TransactionLevel.READ_WRITE)
    public void unblock(@NotNull PasswordActionDTO var1) throws FrameworkException;
}

