/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.server.utils;

import java.util.HashMap;
import java.util.Map;
import org.cyclos.server.utils.HttpServiceInvocationData;
import org.cyclos.server.utils.HttpServiceProxyProvider;
import org.cyclos.server.utils.WebRpcServiceProxyProvider;
import org.cyclos.services.Service;

public class HttpServiceFactory {
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_READ_TIMEOUT = 0;
    private String rootUrl;
    private HttpServiceInvocationData invocationData;
    private int connectTimeout = 15000;
    private int readTimeout = 0;
    private HttpServiceProxyProvider provider;
    private Map<Class<? extends Service>, Service> cachedProxies;

    public HttpServiceFactory() {
    }

    public HttpServiceFactory(String string, HttpServiceInvocationData httpServiceInvocationData) {
        this.rootUrl = string;
        this.invocationData = httpServiceInvocationData;
    }

    public synchronized void clear() {
        try {
            this.provider.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.provider = null;
        this.cachedProxies = null;
    }

    public void destroy() {
        this.clear();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HttpServiceInvocationData getInvocationData() {
        return this.invocationData;
    }

    public synchronized <T extends Service> T getProxy(Class<T> clazz) {
        Service service;
        if (this.cachedProxies == null) {
            this.cachedProxies = new HashMap<Class<? extends Service>, Service>();
        }
        if ((service = this.cachedProxies.get(clazz)) == null) {
            service = (Service)this.getProvider().createProxy(clazz);
            this.cachedProxies.put(clazz, service);
        }
        return (T)service;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public synchronized void setConnectTimeout(int n) {
        this.clear();
        this.connectTimeout = n;
    }

    public synchronized void setInvocationData(HttpServiceInvocationData httpServiceInvocationData) {
        this.clear();
        this.invocationData = httpServiceInvocationData;
    }

    public synchronized void setReadTimeout(int n) {
        this.clear();
        this.readTimeout = n;
    }

    public synchronized void setRootUrl(String string) {
        this.clear();
        this.rootUrl = string;
    }

    private synchronized HttpServiceProxyProvider getProvider() {
        if (this.provider == null) {
            try {
                this.provider = new WebRpcServiceProxyProvider();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Couldn't instantiate the HttpServiceProxyProvider");
            }
            this.provider.initialize(this);
        }
        return this.provider;
    }
}

