/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.users.addresses;

import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.addresses.AddressQueryField;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;

public enum AddressFields implements HasMessageKey
{
    ADDRESS_LINE_1(AddressQueryField.ADDRESS),
    ADDRESS_LINE_2(AddressQueryField.ADDRESS),
    STREET(AddressQueryField.ADDRESS),
    BUILDING_NUMBER(AddressQueryField.ADDRESS),
    COMPLEMENT(AddressQueryField.ADDRESS),
    NEIGHBORHOOD(AddressQueryField.NEIGHBORHOOD),
    PO_BOX(AddressQueryField.PO_BOX),
    ZIP(AddressQueryField.ZIP),
    CITY(AddressQueryField.CITY),
    REGION(AddressQueryField.REGION),
    COUNTRY(AddressQueryField.COUNTRY);

    private final AddressQueryField queryField;
    private final String internalName;

    public static AddressFields findByInternalName(String string) {
        for (AddressFields addressFields : AddressFields.values()) {
            if (!addressFields.internalName.equals(string)) continue;
            return addressFields;
        }
        return null;
    }

    private AddressFields(AddressQueryField addressQueryField) {
        this.queryField = addressQueryField;
        this.internalName = StringHelper.camelize((String)this.name());
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_ADDRESS_LINE_1;
            }
            case 1: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_ADDRESS_LINE_2;
            }
            case 2: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_STREET;
            }
            case 3: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_BUILDING_NUMBER;
            }
            case 4: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_COMPLEMENT;
            }
            case 5: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_NEIGHBORHOOD;
            }
            case 6: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_PO_BOX;
            }
            case 7: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_ZIP;
            }
            case 8: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_CITY;
            }
            case 9: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_REGION;
            }
            case 10: {
                return UsersKeys.Addresses.ADDRESS_FIELDS_COUNTRY;
            }
        }
        return null;
    }

    public String internalName() {
        return this.internalName;
    }

    public AddressQueryField queryField() {
        return this.queryField;
    }
}

