/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.imports;

import org.cyclos.model.access.Permission;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum ImportType implements HasMessageKey
{
    USERS_IMPORT(Permission.IMPORT_USERS),
    ADS_IMPORT(Permission.IMPORT_ADS),
    RECORDS_IMPORT(Permission.IMPORT_RECORDS),
    GENERAL_REFERENCES_IMPORT(Permission.IMPORT_GENERAL_REFERENCES),
    PAYMENTS_IMPORT(Permission.IMPORT_PAYMENTS),
    TRANSFERS_IMPORT(Permission.IMPORT_TRANSFERS),
    TOKENS_IMPORT(Permission.IMPORT_TOKENS),
    USER_PAYMENTS_IMPORT(Permission.MY_IMPORTED_PAYMENTS_ENABLE, Permission.USER_IMPORTED_PAYMENTS_VIEW, Permission.USER_IMPORTED_PAYMENTS_MANAGE),
    USER_SEND_VOUCHERS_IMPORT(Permission.MY_VOUCHERS_BATCH_SEND, Permission.USER_VOUCHERS_BATCH_SEND_VIEW, Permission.USER_VOUCHERS_BATCH_SEND_MANAGE);

    private final Permission generalPermission;
    private final Permission myPermission;
    private final Permission userViewPermission;
    private final Permission userManagePermission;

    private ImportType(Permission permission) {
        this.generalPermission = permission;
        this.myPermission = null;
        this.userViewPermission = null;
        this.userManagePermission = null;
    }

    private ImportType(Permission permission, Permission permission2, Permission permission3) {
        this.myPermission = permission;
        this.userViewPermission = permission2;
        this.userManagePermission = permission3;
        this.generalPermission = null;
    }

    public Permission getGeneralPermission() {
        return this.generalPermission;
    }

    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return SystemKeys.Imports.IMPORT_TYPE_USERS_IMPORT;
            }
            case 1: {
                return SystemKeys.Imports.IMPORT_TYPE_ADS_IMPORT;
            }
            case 2: {
                return SystemKeys.Imports.IMPORT_TYPE_RECORDS_IMPORT;
            }
            case 3: {
                return SystemKeys.Imports.IMPORT_TYPE_GENERAL_REFERENCES_IMPORT;
            }
            case 4: {
                return SystemKeys.Imports.IMPORT_TYPE_PAYMENTS_IMPORT;
            }
            case 5: {
                return SystemKeys.Imports.IMPORT_TYPE_TRANSFERS_IMPORT;
            }
            case 6: {
                return SystemKeys.Imports.IMPORT_TYPE_TOKENS_IMPORT;
            }
            case 7: {
                return SystemKeys.Imports.IMPORT_TYPE_USER_PAYMENTS_IMPORT;
            }
            case 8: {
                return SystemKeys.Imports.IMPORT_TYPE_USER_SEND_VOUCHERS_IMPORT;
            }
        }
        return null;
    }

    public Permission getMyPermission() {
        return this.myPermission;
    }

    public Permission getUserManagePermission() {
        return this.userManagePermission;
    }

    public Permission getUserViewPermission() {
        return this.userViewPermission;
    }

    public boolean isUserSpecific() {
        return this.myPermission != null;
    }

    public boolean requiresConfirmationPassword() {
        return this == PAYMENTS_IMPORT || this.isUserSpecific();
    }
}

