/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.system.imports;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.utils.MessageKey;

public enum ImportSearchContext {
    SYSTEM(ImportType.USERS_IMPORT, ImportType.ADS_IMPORT, ImportType.RECORDS_IMPORT, ImportType.GENERAL_REFERENCES_IMPORT, ImportType.TRANSFERS_IMPORT, ImportType.TOKENS_IMPORT),
    BANKING(ImportType.PAYMENTS_IMPORT),
    USER_PAYMENTS(ImportType.USER_PAYMENTS_IMPORT),
    USER_SEND_VOUCHERS(ImportType.USER_SEND_VOUCHERS_IMPORT);

    private final List<ImportType> importTypes;

    private ImportSearchContext(ImportType ... importTypeArray) {
        this.importTypes = Collections.unmodifiableList(Arrays.asList(importTypeArray));
    }

    public MessageKey getHeadingKey() {
        switch (this.ordinal()) {
            case 0: {
                return SystemKeys.Imports.HEADING_SEARCH;
            }
            case 1: {
                return SystemKeys.Imports.HEADING_BANKING_SEARCH;
            }
            case 2: {
                return SystemKeys.Imports.HEADING_USER_PAYMENTS_SEARCH;
            }
            case 3: {
                return SystemKeys.Imports.HEADING_USER_SEND_VOUCHERS_SEARCH;
            }
        }
        return null;
    }

    public List<ImportType> getImportTypes() {
        return this.importTypes;
    }

    public boolean isUserSpecific() {
        return this.importTypes.stream().allMatch(ImportType::isUserSpecific);
    }
}

