/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.model.banking.accountfees;

import org.cyclos.model.banking.BankingKeys;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;

public enum AccountFeeChargeMode implements HasMessageKey
{
    FIXED,
    VOLUME_PERCENTAGE,
    NEGATIVE_VOLUME_PERCENTAGE,
    BALANCE_PERCENTAGE,
    NEGATIVE_BALANCE_PERCENTAGE,
    CUSTOM;


    @Override
    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return BankingKeys.AccountFees.CHARGE_MODE_FIXED;
            }
            case 1: {
                return BankingKeys.AccountFees.CHARGE_MODE_VOLUME_PERCENTAGE;
            }
            case 2: {
                return BankingKeys.AccountFees.CHARGE_MODE_NEGATIVE_VOLUME_PERCENTAGE;
            }
            case 3: {
                return BankingKeys.AccountFees.CHARGE_MODE_BALANCE_PERCENTAGE;
            }
            case 4: {
                return BankingKeys.AccountFees.CHARGE_MODE_NEGATIVE_BALANCE_PERCENTAGE;
            }
            case 5: {
                return BankingKeys.AccountFees.CHARGE_MODE_CUSTOM;
            }
        }
        return null;
    }

    public boolean isBalance() {
        return this == BALANCE_PERCENTAGE || this == NEGATIVE_BALANCE_PERCENTAGE;
    }

    public boolean isCustom() {
        return this == CUSTOM;
    }

    public boolean isFixed() {
        return this == FIXED;
    }

    public boolean isNegative() {
        return this == NEGATIVE_BALANCE_PERCENTAGE || this == NEGATIVE_VOLUME_PERCENTAGE;
    }

    public boolean isPositive() {
        return this == BALANCE_PERCENTAGE || this == VOLUME_PERCENTAGE;
    }

    public boolean isVolume() {
        return this == VOLUME_PERCENTAGE || this == NEGATIVE_VOLUME_PERCENTAGE;
    }
}

