/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.Pair;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

@Embeddable
public class DatePeriod
implements Cloneable,
PersistenceWeaved,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    @Basic
    @Column(name="period_begin")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date begin;
    @Basic
    @Column(name="period_end")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date end;
    static final long serialVersionUID = 1752240436554755567L;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public static DatePeriod begginingAt(Date date) {
        return new DatePeriod(date, null);
    }

    public static DatePeriod between(Date date, Date date2) {
        return new DatePeriod(date, date2);
    }

    public static DatePeriod endingAt(Date date) {
        return new DatePeriod(null, date);
    }

    public static DatePeriod periodIncluding(ITimeInterval iTimeInterval, TimeZone timeZone, Date date) {
        return new DatePeriod((Pair<Date, Date>)DateHelper.periodIncluding((ITimeInterval)iTimeInterval, (TimeZone)timeZone, (Date)date));
    }

    public static DatePeriod previousPeriod(ITimeInterval iTimeInterval, TimeZone timeZone, Date date) {
        return new DatePeriod((Pair<Date, Date>)DateHelper.previousPeriod((ITimeInterval)iTimeInterval, (TimeZone)timeZone, (Date)date));
    }

    public DatePeriod() {
    }

    public DatePeriod(Date date, Date date2) {
        this.begin = date;
        this.end = date2;
    }

    public DatePeriod(Pair<Date, Date> pair) {
        this.begin = pair == null ? null : (Date)pair.getFirst();
        this.end = pair == null ? null : (Date)pair.getSecond();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DatePeriod datePeriod = (DatePeriod)object;
        if (this._persistence_get_begin() == null ? datePeriod._persistence_get_begin() != null : !this._persistence_get_begin().equals(datePeriod._persistence_get_begin())) {
            return false;
        }
        return !(this._persistence_get_end() == null ? datePeriod._persistence_get_end() != null : !this._persistence_get_end().equals(datePeriod._persistence_get_end()));
    }

    public Date getBegin() {
        return this._persistence_get_begin();
    }

    public Date getEnd() {
        return this._persistence_get_end();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._persistence_get_begin() == null ? 0 : this._persistence_get_begin().hashCode());
        n = 31 * n + (this._persistence_get_end() == null ? 0 : this._persistence_get_end().hashCode());
        return n;
    }

    public boolean includes(Date date) {
        if (this._persistence_get_begin() == null && this._persistence_get_end() == null) {
            return true;
        }
        if (this._persistence_get_begin() == null) {
            return !date.after(this._persistence_get_end());
        }
        if (this._persistence_get_end() == null) {
            return !date.before(this._persistence_get_begin());
        }
        return !date.before(this._persistence_get_begin()) && !date.after(this._persistence_get_end());
    }

    public boolean isEmpty() {
        return this._persistence_get_begin() == null && this._persistence_get_end() == null;
    }

    public void setBegin(Date date) {
        this._persistence_set_begin(date);
    }

    public void setEnd(Date date) {
        this._persistence_set_end(date);
    }

    public String toString() {
        return this.format(this._persistence_get_begin()) + " to " + this.format(this._persistence_get_end());
    }

    private String format(Date date) {
        if (date == null) {
            return "unbound";
        }
        ZonedDateTime zonedDateTime = date.toInstant().atZone(ZoneId.systemDefault());
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DatePeriod(persistenceObject);
    }

    public DatePeriod(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "end") {
            return this.end;
        }
        if (string == "begin") {
            return this.begin;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "end") {
            this.end = (Date)object;
            return;
        }
        if (string == "begin") {
            this.begin = (Date)object;
            return;
        }
    }

    public Date _persistence_get_end() {
        this._persistence_checkFetched("end");
        return this.end;
    }

    public void _persistence_set_end(Date date) {
        this._persistence_checkFetchedForSet("end");
        this._persistence_propertyChange("end", this.end, date);
        this.end = date;
    }

    public Date _persistence_get_begin() {
        this._persistence_checkFetched("begin");
        return this.begin;
    }

    public void _persistence_set_begin(Date date) {
        this._persistence_checkFetchedForSet("begin");
        this._persistence_propertyChange("begin", this.begin, date);
        this.begin = date;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

