/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.Product;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="products_vouchers", uniqueConstraints={@UniqueConstraint(name="uk_products_vouchers", columnNames={"subclass", "product_id", "configuration_id"})})
@DiscriminatorColumn(name="subclass")
public abstract class ProductVoucher
extends BaseEntity
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="product_id", nullable=false)
    private Product product;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="configuration_id", nullable=false)
    private VoucherConfiguration configuration;
    @Basic
    @Column(name="buy")
    private Boolean buy;
    @Basic
    @Column(name="send")
    private Boolean send;
    @Basic
    @Column(name="notification_settings")
    private Boolean notificationSettings;
    @Basic
    @Column(name="change_pin")
    private Boolean changePin;
    @Basic
    @Column(name="refund")
    private Boolean refund;
    @Basic
    @Column(name="redeem")
    private Boolean redeem;
    @Basic
    @Column(name="topup")
    private Boolean topUp;
    static final long serialVersionUID = -7204663331342575455L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_product_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_configuration_vh;

    public VoucherConfiguration getConfiguration() {
        return this._persistence_get_configuration();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_product().getNetwork();
    }

    public Product getProduct() {
        return this._persistence_get_product();
    }

    public boolean isBuy() {
        return Boolean.TRUE.equals(this._persistence_get_buy());
    }

    public boolean isChangePin() {
        return Boolean.TRUE.equals(this._persistence_get_changePin());
    }

    public boolean isNotificationSettings() {
        return Boolean.TRUE.equals(this._persistence_get_notificationSettings());
    }

    public boolean isRedeem() {
        return Boolean.TRUE.equals(this._persistence_get_redeem());
    }

    public boolean isRefund() {
        return Boolean.TRUE.equals(this._persistence_get_refund());
    }

    public boolean isSend() {
        return Boolean.TRUE.equals(this._persistence_get_send());
    }

    public boolean isTopUp() {
        return Boolean.TRUE.equals(this._persistence_get_topUp());
    }

    public void setBuy(boolean bl) {
        this._persistence_set_buy(bl);
    }

    public void setChangePin(boolean bl) {
        this._persistence_set_changePin(bl);
    }

    public void setConfiguration(VoucherConfiguration voucherConfiguration) {
        this._persistence_set_configuration(voucherConfiguration);
    }

    public void setNotificationSettings(boolean bl) {
        this._persistence_set_notificationSettings(bl);
    }

    public void setProduct(Product product) {
        this._persistence_set_product(product);
    }

    public void setRedeem(boolean bl) {
        this._persistence_set_redeem(bl);
    }

    public void setRefund(boolean bl) {
        this._persistence_set_refund(bl);
    }

    public void setSend(boolean bl) {
        this._persistence_set_send(bl);
    }

    public void setTopUp(boolean bl) {
        this._persistence_set_topUp(bl);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_product_vh != null) {
            this._persistence_product_vh = (WeavedAttributeValueHolderInterface)this._persistence_product_vh.clone();
        }
        if (this._persistence_configuration_vh != null) {
            this._persistence_configuration_vh = (WeavedAttributeValueHolderInterface)this._persistence_configuration_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ProductVoucher();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "product") {
            return this.product;
        }
        if (string == "configuration") {
            return this.configuration;
        }
        if (string == "topUp") {
            return this.topUp;
        }
        if (string == "buy") {
            return this.buy;
        }
        if (string == "changePin") {
            return this.changePin;
        }
        if (string == "redeem") {
            return this.redeem;
        }
        if (string == "send") {
            return this.send;
        }
        if (string == "notificationSettings") {
            return this.notificationSettings;
        }
        if (string == "refund") {
            return this.refund;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "product") {
            this.product = (Product)object;
            return;
        }
        if (string == "configuration") {
            this.configuration = (VoucherConfiguration)object;
            return;
        }
        if (string == "topUp") {
            this.topUp = (Boolean)object;
            return;
        }
        if (string == "buy") {
            this.buy = (Boolean)object;
            return;
        }
        if (string == "changePin") {
            this.changePin = (Boolean)object;
            return;
        }
        if (string == "redeem") {
            this.redeem = (Boolean)object;
            return;
        }
        if (string == "send") {
            this.send = (Boolean)object;
            return;
        }
        if (string == "notificationSettings") {
            this.notificationSettings = (Boolean)object;
            return;
        }
        if (string == "refund") {
            this.refund = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_product_vh() {
        if (this._persistence_product_vh == null) {
            this._persistence_product_vh = new ValueHolder((Object)this.product);
            this._persistence_product_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_product_vh() {
        Product product;
        this._persistence_initialize_product_vh();
        if ((this._persistence_product_vh.isCoordinatedWithProperty() || this._persistence_product_vh.isNewlyWeavedValueHolder()) && (product = this._persistence_get_product()) != this._persistence_product_vh.getValue()) {
            this._persistence_set_product(product);
        }
        return this._persistence_product_vh;
    }

    public void _persistence_set_product_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_product_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Product product = this._persistence_get_product();
            if (product != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_product((Product)object);
            }
        } else {
            this.product = null;
        }
    }

    public Product _persistence_get_product() {
        this._persistence_checkFetched("product");
        this._persistence_initialize_product_vh();
        this.product = (Product)this._persistence_product_vh.getValue();
        return this.product;
    }

    public void _persistence_set_product(Product product) {
        this._persistence_checkFetchedForSet("product");
        this._persistence_initialize_product_vh();
        this.product = (Product)this._persistence_product_vh.getValue();
        this._persistence_propertyChange("product", this.product, product);
        this.product = product;
        this._persistence_product_vh.setValue((Object)product);
    }

    protected void _persistence_initialize_configuration_vh() {
        if (this._persistence_configuration_vh == null) {
            this._persistence_configuration_vh = new ValueHolder((Object)this.configuration);
            this._persistence_configuration_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_configuration_vh() {
        VoucherConfiguration voucherConfiguration;
        this._persistence_initialize_configuration_vh();
        if ((this._persistence_configuration_vh.isCoordinatedWithProperty() || this._persistence_configuration_vh.isNewlyWeavedValueHolder()) && (voucherConfiguration = this._persistence_get_configuration()) != this._persistence_configuration_vh.getValue()) {
            this._persistence_set_configuration(voucherConfiguration);
        }
        return this._persistence_configuration_vh;
    }

    public void _persistence_set_configuration_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_configuration_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            VoucherConfiguration voucherConfiguration = this._persistence_get_configuration();
            if (voucherConfiguration != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_configuration((VoucherConfiguration)object);
            }
        } else {
            this.configuration = null;
        }
    }

    public VoucherConfiguration _persistence_get_configuration() {
        this._persistence_checkFetched("configuration");
        this._persistence_initialize_configuration_vh();
        this.configuration = (VoucherConfiguration)this._persistence_configuration_vh.getValue();
        return this.configuration;
    }

    public void _persistence_set_configuration(VoucherConfiguration voucherConfiguration) {
        this._persistence_checkFetchedForSet("configuration");
        this._persistence_initialize_configuration_vh();
        this.configuration = (VoucherConfiguration)this._persistence_configuration_vh.getValue();
        this._persistence_propertyChange("configuration", this.configuration, voucherConfiguration);
        this.configuration = voucherConfiguration;
        this._persistence_configuration_vh.setValue((Object)voucherConfiguration);
    }

    public Boolean _persistence_get_topUp() {
        this._persistence_checkFetched("topUp");
        return this.topUp;
    }

    public void _persistence_set_topUp(Boolean bl) {
        this._persistence_checkFetchedForSet("topUp");
        this._persistence_propertyChange("topUp", this.topUp, bl);
        this.topUp = bl;
    }

    public Boolean _persistence_get_buy() {
        this._persistence_checkFetched("buy");
        return this.buy;
    }

    public void _persistence_set_buy(Boolean bl) {
        this._persistence_checkFetchedForSet("buy");
        this._persistence_propertyChange("buy", this.buy, bl);
        this.buy = bl;
    }

    public Boolean _persistence_get_changePin() {
        this._persistence_checkFetched("changePin");
        return this.changePin;
    }

    public void _persistence_set_changePin(Boolean bl) {
        this._persistence_checkFetchedForSet("changePin");
        this._persistence_propertyChange("changePin", this.changePin, bl);
        this.changePin = bl;
    }

    public Boolean _persistence_get_redeem() {
        this._persistence_checkFetched("redeem");
        return this.redeem;
    }

    public void _persistence_set_redeem(Boolean bl) {
        this._persistence_checkFetchedForSet("redeem");
        this._persistence_propertyChange("redeem", this.redeem, bl);
        this.redeem = bl;
    }

    public Boolean _persistence_get_send() {
        this._persistence_checkFetched("send");
        return this.send;
    }

    public void _persistence_set_send(Boolean bl) {
        this._persistence_checkFetchedForSet("send");
        this._persistence_propertyChange("send", this.send, bl);
        this.send = bl;
    }

    public Boolean _persistence_get_notificationSettings() {
        this._persistence_checkFetched("notificationSettings");
        return this.notificationSettings;
    }

    public void _persistence_set_notificationSettings(Boolean bl) {
        this._persistence_checkFetchedForSet("notificationSettings");
        this._persistence_propertyChange("notificationSettings", this.notificationSettings, bl);
        this.notificationSettings = bl;
    }

    public Boolean _persistence_get_refund() {
        this._persistence_checkFetched("refund");
        return this.refund;
    }

    public void _persistence_set_refund(Boolean bl) {
        this._persistence_checkFetchedForSet("refund");
        this._persistence_propertyChange("refund", this.refund, bl);
        this.refund = bl;
    }
}

