/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.users;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.contentmanagement.SystemImageCategory;
import org.cyclos.entities.messaging.MessageCategory;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.SystemWizard;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProductAuthorizationRole;
import org.cyclos.entities.users.AdminProductNotification;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductAdminVoucher;
import org.cyclos.entities.users.ProductManagement;
import org.cyclos.entities.users.ProductSystemRecordType;
import org.cyclos.entities.users.UserManagementProduct;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.users.products.AdminGroupAccessibility;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="ADMIN")
public class AdminProduct
extends UserManagementProduct
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @OneToMany(mappedBy="adminProduct")
    private Set<AdminGroup> adminGroups;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="admin_group_accessibility")
    private AdminGroupAccessibility adminGroupAccessibility = AdminGroupAccessibility.NONE;
    @ManyToMany
    @JoinTable(name="products_accessible_admin_groups", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<AdminGroup> accessibleAdminGroups = new HashSet<AdminGroup>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductSystemRecordType> systemRecordTypes = new HashSet<ProductSystemRecordType>();
    @ManyToMany
    @JoinTable(name="products_system_accounts", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="account_type_id")})
    private Set<SystemAccountType> systemAccounts = new HashSet<SystemAccountType>();
    @ManyToMany
    @JoinTable(name="products_system_transfer_filters", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="transfer_filter_id")})
    private Set<TransferFilter> systemTransferFilters = new HashSet<TransferFilter>();
    @ManyToMany
    @JoinTable(name="products_system_payments", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> systemPayments = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_system_external_payment_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> systemToUserExternalPayments = new HashSet<PaymentTransferType>();
    @ManyToMany
    @JoinTable(name="products_system_request_payment_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="payment_type_id")})
    private Set<PaymentTransferType> systemPaymentRequestsSendToUser = new HashSet<PaymentTransferType>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<AdminProductAuthorizationRole> authorizationRoles = new HashSet<AdminProductAuthorizationRole>();
    @ManyToMany
    @JoinTable(name="products_voucher_configurations", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="configuration_id")})
    private Set<VoucherConfiguration> accessibleVoucherConfigurations = new HashSet<VoucherConfiguration>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<ProductManagement> managedProducts = new HashSet<ProductManagement>();
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL})
    private Set<ProductAdminVoucher> vouchers = new HashSet<ProductAdminVoucher>();
    @ManyToMany
    @JoinTable(name="products_system_image_categories_view", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="system_image_category_id")})
    private Set<SystemImageCategory> systemImageCategoriesView = new HashSet<SystemImageCategory>();
    @ManyToMany
    @JoinTable(name="products_system_image_categories_manage", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="system_image_category_id")})
    private Set<SystemImageCategory> systemImageCategoriesManage = new HashSet<SystemImageCategory>();
    @ManyToMany
    @JoinTable(name="products_manage_specific_configurations", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="configuration_id")})
    private Set<Configuration> manageSpecificConfigurations = new HashSet<Configuration>();
    @ManyToMany
    @JoinTable(name="products_manage_content_specific_configurations", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="configuration_id")})
    private Set<Configuration> manageContentSpecificConfigurations = new HashSet<Configuration>();
    @ManyToMany
    @JoinTable(name="products_view_msg_to_sys_cat", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="message_category_id")})
    private Set<MessageCategory> viewMessagesSentToSysWithCat = new HashSet<MessageCategory>();
    @ManyToMany
    @JoinTable(name="products_manage_msg_to_sys_cat", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="message_category_id")})
    private Set<MessageCategory> manageMessagesSentToSysWithCat = new HashSet<MessageCategory>();
    @ManyToMany
    @JoinTable(name="products_send_msg_from_sys_cat", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="message_category_id")})
    private Set<MessageCategory> sendMessagesFromSysWithCat = new HashSet<MessageCategory>();
    @ManyToMany
    @JoinTable(name="products_managed_individual_products", joinColumns={@JoinColumn(name="owner_product_id")}, inverseJoinColumns={@JoinColumn(name="managed_product_id")})
    private Set<Product> manageIndividualProducts = new HashSet<Product>();
    @ManyToMany
    @JoinTable(name="products_system_custom_operations", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="custom_operation_id")})
    private Set<CustomOperation> systemCustomOperationsRun = new HashSet<CustomOperation>();
    @ManyToMany
    @JoinTable(name="products_system_custom_wizards", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="wizard_id")})
    private Set<SystemWizard> systemWizardsRun = new HashSet<SystemWizard>();
    @ManyToMany
    @JoinTable(name="products_languages", joinColumns={@JoinColumn(name="owner_product_id")}, inverseJoinColumns={@JoinColumn(name="language_id")})
    private Set<Language> applicationTranslation = new HashSet<Language>();
    @ManyToMany
    @JoinTable(name="products_system_chargebacks", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="transfer_type_id")})
    private Set<TransferType> chargebackPaymentsToSystem = new HashSet<TransferType>();
    @Basic
    @Column(name="sys_msg_sendto_groups_enabled")
    private boolean sysMsgSendToGroupsEnabled = true;
    @OneToMany(mappedBy="product", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<AdminProductNotification> defaultNotifications = new HashSet<AdminProductNotification>();
    @ManyToMany
    @JoinTable(name="products_authorizable_payments_to_notify", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="transfer_type_id")})
    private Set<TransferType> authorizablePaymentsToNotify = new HashSet<TransferType>();
    @ManyToMany
    @JoinTable(name="products_payments_to_notify", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="transfer_type_id")})
    private Set<TransferType> paymentsToNotify = new HashSet<TransferType>();
    @ManyToMany
    @JoinTable(name="products_external_payments_expired_to_notify", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="transfer_type_id")})
    private Set<TransferType> externalPaymentsExpiredToNotify = new HashSet<TransferType>();
    @ManyToMany
    @JoinTable(name="products_external_payments_failed_to_notify", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="transfer_type_id")})
    private Set<TransferType> externalPaymentsFailedToNotify = new HashSet<TransferType>();
    @ManyToMany
    @JoinTable(name="products_fwd_message_categories_to_notify", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="message_category_id")})
    private Set<MessageCategory> fwdMessageCategoriesToEmailToNotify = new HashSet<MessageCategory>();
    @ElementCollection
    @CollectionTable(name="products_user_alerts_to_notify", joinColumns={@JoinColumn(name="product_id")})
    @Column(name="user_alert_type")
    @Enumerated(value=EnumType.STRING)
    private Set<UserAlertType> userAlertsToNotify = new HashSet<UserAlertType>();
    @ElementCollection
    @CollectionTable(name="products_system_alerts_to_notify", joinColumns={@JoinColumn(name="product_id")})
    @Column(name="system_alert_type")
    @Enumerated(value=EnumType.STRING)
    private Set<SystemAlertType> systemAlertsToNotify = new HashSet<SystemAlertType>();
    @ManyToMany
    @JoinTable(name="products_voucher_configurations_to_notify", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="voucher_configuration_id")})
    private Set<VoucherConfiguration> voucherConfigurationsToNotify = new HashSet<VoucherConfiguration>();
    @ManyToMany
    @JoinTable(name="products_voucher_configurations_buying_to_notify", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="voucher_configuration_id")})
    private Set<VoucherConfiguration> voucherConfigurationsBuyingToNotify = new HashSet<VoucherConfiguration>();
    @ManyToMany
    @JoinTable(name="products_user_groups_to_notify", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private Set<Group> userGroupsToNotify;
    @ManyToMany
    @JoinTable(name="products_login_user_principal_types", joinColumns={@JoinColumn(name="product_id")}, inverseJoinColumns={@JoinColumn(name="principal_type_id")})
    private Set<PrincipalType> loginUserPrincipalTypes = new HashSet<PrincipalType>();
    static final long serialVersionUID = -8695009113691384305L;

    public Set<AdminGroup> getAccessibleAdminGroups() {
        return this._persistence_get_accessibleAdminGroups();
    }

    public Set<VoucherConfiguration> getAccessibleVoucherConfigurations() {
        return this._persistence_get_accessibleVoucherConfigurations();
    }

    public AdminGroup getAdminGroup() {
        return (AdminGroup)CollectionHelper.first((Iterable)this._persistence_get_adminGroups());
    }

    public AdminGroupAccessibility getAdminGroupAccessibility() {
        return this._persistence_get_adminGroupAccessibility();
    }

    public Set<Language> getApplicationTranslation() {
        return this._persistence_get_applicationTranslation();
    }

    public Set<TransferType> getAuthorizablePaymentsToNotify() {
        return this._persistence_get_authorizablePaymentsToNotify();
    }

    public Set<AdminProductAuthorizationRole> getAuthorizationRoles() {
        return this._persistence_get_authorizationRoles();
    }

    public Set<TransferType> getChargebackPaymentsToSystem() {
        return this._persistence_get_chargebackPaymentsToSystem();
    }

    public Set<AdminProductNotification> getDefaultNotifications() {
        return this._persistence_get_defaultNotifications();
    }

    public Set<TransferType> getExternalPaymentsExpiredToNotify() {
        return this._persistence_get_externalPaymentsExpiredToNotify();
    }

    public Set<TransferType> getExternalPaymentsFailedToNotify() {
        return this._persistence_get_externalPaymentsFailedToNotify();
    }

    public Set<MessageCategory> getFwdMessageCategoriesToEmailToNotify() {
        return this._persistence_get_fwdMessageCategoriesToEmailToNotify();
    }

    @Override
    public Set<? extends BasicGroup> getGroups() {
        return this._persistence_get_adminGroups();
    }

    public Set<PrincipalType> getLoginUserPrincipalTypes() {
        return this._persistence_get_loginUserPrincipalTypes();
    }

    public Set<Configuration> getManageContentSpecificConfigurations() {
        return this._persistence_get_manageContentSpecificConfigurations();
    }

    public Set<ProductManagement> getManagedProducts() {
        return this._persistence_get_managedProducts();
    }

    public Set<Product> getManageIndividualProducts() {
        return this._persistence_get_manageIndividualProducts();
    }

    public Set<MessageCategory> getManageMessagesSentToSysWithCat() {
        return this._persistence_get_manageMessagesSentToSysWithCat();
    }

    public Set<Configuration> getManageSpecificConfigurations() {
        return this._persistence_get_manageSpecificConfigurations();
    }

    @Override
    public ProductNature getNature() {
        return ProductNature.ADMIN;
    }

    public Set<TransferType> getPaymentsToNotify() {
        return this._persistence_get_paymentsToNotify();
    }

    public Set<MessageCategory> getSendMessagesFromSysWithCat() {
        return this._persistence_get_sendMessagesFromSysWithCat();
    }

    public Set<SystemAccountType> getSystemAccounts() {
        return this._persistence_get_systemAccounts();
    }

    public Set<SystemAlertType> getSystemAlertsToNotify() {
        return this._persistence_get_systemAlertsToNotify();
    }

    public Set<CustomOperation> getSystemCustomOperationsRun() {
        return this._persistence_get_systemCustomOperationsRun();
    }

    public Set<SystemImageCategory> getSystemImageCategoriesManage() {
        return this._persistence_get_systemImageCategoriesManage();
    }

    public Set<SystemImageCategory> getSystemImageCategoriesView() {
        return this._persistence_get_systemImageCategoriesView();
    }

    public Set<PaymentTransferType> getSystemPaymentRequestsSendToUser() {
        return this._persistence_get_systemPaymentRequestsSendToUser();
    }

    public Set<PaymentTransferType> getSystemPayments() {
        return this._persistence_get_systemPayments();
    }

    public Set<ProductSystemRecordType> getSystemRecordTypes() {
        return this._persistence_get_systemRecordTypes();
    }

    public Set<PaymentTransferType> getSystemToSystemPayments() {
        return this.filterPaymentTypes(this._persistence_get_systemPayments(), TransferTypeDirection.SYSTEM_TO_SYSTEM);
    }

    public Set<PaymentTransferType> getSystemToUserExternalPayments() {
        return this._persistence_get_systemToUserExternalPayments();
    }

    public Set<PaymentTransferType> getSystemToUserPayments() {
        return this.filterPaymentTypes(this._persistence_get_systemPayments(), TransferTypeDirection.SYSTEM_TO_USER);
    }

    public Set<TransferFilter> getSystemTransferFilters() {
        return this._persistence_get_systemTransferFilters();
    }

    public Set<SystemWizard> getSystemWizardsRun() {
        return this._persistence_get_systemWizardsRun();
    }

    public Set<UserAlertType> getUserAlertsToNotify() {
        return this._persistence_get_userAlertsToNotify();
    }

    public Set<Group> getUserGroupsToNotify() {
        return this._persistence_get_userGroupsToNotify();
    }

    public Set<MessageCategory> getViewMessagesSentToSysWithCat() {
        return this._persistence_get_viewMessagesSentToSysWithCat();
    }

    public Set<VoucherConfiguration> getVoucherConfigurationsBuyingToNotify() {
        return this._persistence_get_voucherConfigurationsBuyingToNotify();
    }

    public Set<VoucherConfiguration> getVoucherConfigurationsToNotify() {
        return this._persistence_get_voucherConfigurationsToNotify();
    }

    public Set<ProductAdminVoucher> getVouchers() {
        return this._persistence_get_vouchers();
    }

    public boolean isSysMsgSendToGroupsEnabled() {
        return this._persistence_get_sysMsgSendToGroupsEnabled();
    }

    public void setAccessibleAdminGroups(Set<AdminGroup> set) {
        this._persistence_set_accessibleAdminGroups(set);
    }

    public void setAccessibleVoucherConfigurations(Set<VoucherConfiguration> set) {
        this._persistence_set_accessibleVoucherConfigurations(set);
    }

    public void setAdminGroupAccessibility(AdminGroupAccessibility adminGroupAccessibility) {
        this._persistence_set_adminGroupAccessibility(adminGroupAccessibility);
    }

    public void setApplicationTranslation(Set<Language> set) {
        this._persistence_set_applicationTranslation(set);
    }

    public void setAuthorizablePaymentsToNotify(Set<TransferType> set) {
        this._persistence_set_authorizablePaymentsToNotify(set);
    }

    public void setAuthorizationRoles(Set<AdminProductAuthorizationRole> set) {
        this._persistence_set_authorizationRoles(set);
    }

    public void setChargebackPaymentsToSystem(Set<TransferType> set) {
        this._persistence_set_chargebackPaymentsToSystem(set);
    }

    public void setDefaultNotifications(Set<AdminProductNotification> set) {
        this._persistence_set_defaultNotifications(set);
    }

    public void setExternalPaymentsExpiredToNotify(Set<TransferType> set) {
        this._persistence_set_externalPaymentsExpiredToNotify(set);
    }

    public void setExternalPaymentsFailedToNotify(Set<TransferType> set) {
        this._persistence_set_externalPaymentsFailedToNotify(set);
    }

    public void setFwdMessageCategoriesToEmailToNotify(Set<MessageCategory> set) {
        this._persistence_set_fwdMessageCategoriesToEmailToNotify(set);
    }

    public void setLoginUserPrincipalTypes(Set<PrincipalType> set) {
        this._persistence_set_loginUserPrincipalTypes(set);
    }

    public void setManageContentSpecificConfigurations(Set<Configuration> set) {
        this._persistence_set_manageContentSpecificConfigurations(set);
    }

    public void setManagedProducts(Set<ProductManagement> set) {
        this._persistence_set_managedProducts(set);
    }

    public void setManageIndividualProducts(Set<Product> set) {
        this._persistence_set_manageIndividualProducts(set);
    }

    public void setManageMessagesSentToSysWithCat(Set<MessageCategory> set) {
        this._persistence_set_manageMessagesSentToSysWithCat(set);
    }

    public void setManageSpecificConfigurations(Set<Configuration> set) {
        this._persistence_set_manageSpecificConfigurations(set);
    }

    public void setPaymentsToNotify(Set<TransferType> set) {
        this._persistence_set_paymentsToNotify(set);
    }

    public void setSendMessagesFromSysWithCat(Set<MessageCategory> set) {
        this._persistence_set_sendMessagesFromSysWithCat(set);
    }

    public void setSysMsgSendToGroupsEnabled(boolean bl) {
        this._persistence_set_sysMsgSendToGroupsEnabled(bl);
    }

    public void setSystemAccounts(Set<SystemAccountType> set) {
        this._persistence_set_systemAccounts(set);
    }

    public void setSystemAlertsToNotify(Set<SystemAlertType> set) {
        this._persistence_set_systemAlertsToNotify(set);
    }

    public void setSystemCustomOperationsRun(Set<CustomOperation> set) {
        this._persistence_set_systemCustomOperationsRun(set);
    }

    public void setSystemImageCategoriesManage(Set<SystemImageCategory> set) {
        this._persistence_set_systemImageCategoriesManage(set);
    }

    public void setSystemImageCategoriesView(Set<SystemImageCategory> set) {
        this._persistence_set_systemImageCategoriesView(set);
    }

    public void setSystemPaymentRequestsSendToUser(Set<PaymentTransferType> set) {
        this._persistence_set_systemPaymentRequestsSendToUser(set);
    }

    public void setSystemPayments(Set<PaymentTransferType> set) {
        this._persistence_set_systemPayments(set);
    }

    public void setSystemRecordTypes(Set<ProductSystemRecordType> set) {
        this._persistence_set_systemRecordTypes(set);
    }

    public void setSystemToUserExternalPayments(Set<PaymentTransferType> set) {
        this._persistence_set_systemToUserExternalPayments(set);
    }

    public void setSystemTransferFilters(Set<TransferFilter> set) {
        this._persistence_set_systemTransferFilters(set);
    }

    public void setSystemWizardsRun(Set<SystemWizard> set) {
        this._persistence_set_systemWizardsRun(set);
    }

    public void setUserAlertsToNotify(Set<UserAlertType> set) {
        this._persistence_set_userAlertsToNotify(set);
    }

    public void setUserGroupsToNotify(Set<Group> set) {
        this._persistence_set_userGroupsToNotify(set);
    }

    public void setViewMessagesSentToSysWithCat(Set<MessageCategory> set) {
        this._persistence_set_viewMessagesSentToSysWithCat(set);
    }

    public void setVoucherConfigurationsBuyingToNotify(Set<VoucherConfiguration> set) {
        this._persistence_set_voucherConfigurationsBuyingToNotify(set);
    }

    public void setVoucherConfigurationsToNotify(Set<VoucherConfiguration> set) {
        this._persistence_set_voucherConfigurationsToNotify(set);
    }

    public void setVouchers(Set<ProductAdminVoucher> set) {
        this._persistence_set_vouchers(set);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AdminProduct();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "manageIndividualProducts") {
            return this.manageIndividualProducts;
        }
        if (string == "manageSpecificConfigurations") {
            return this.manageSpecificConfigurations;
        }
        if (string == "voucherConfigurationsToNotify") {
            return this.voucherConfigurationsToNotify;
        }
        if (string == "systemRecordTypes") {
            return this.systemRecordTypes;
        }
        if (string == "viewMessagesSentToSysWithCat") {
            return this.viewMessagesSentToSysWithCat;
        }
        if (string == "systemAlertsToNotify") {
            return this.systemAlertsToNotify;
        }
        if (string == "accessibleAdminGroups") {
            return this.accessibleAdminGroups;
        }
        if (string == "chargebackPaymentsToSystem") {
            return this.chargebackPaymentsToSystem;
        }
        if (string == "manageMessagesSentToSysWithCat") {
            return this.manageMessagesSentToSysWithCat;
        }
        if (string == "applicationTranslation") {
            return this.applicationTranslation;
        }
        if (string == "externalPaymentsExpiredToNotify") {
            return this.externalPaymentsExpiredToNotify;
        }
        if (string == "systemWizardsRun") {
            return this.systemWizardsRun;
        }
        if (string == "systemImageCategoriesManage") {
            return this.systemImageCategoriesManage;
        }
        if (string == "manageContentSpecificConfigurations") {
            return this.manageContentSpecificConfigurations;
        }
        if (string == "voucherConfigurationsBuyingToNotify") {
            return this.voucherConfigurationsBuyingToNotify;
        }
        if (string == "accessibleVoucherConfigurations") {
            return this.accessibleVoucherConfigurations;
        }
        if (string == "systemPayments") {
            return this.systemPayments;
        }
        if (string == "paymentsToNotify") {
            return this.paymentsToNotify;
        }
        if (string == "userGroupsToNotify") {
            return this.userGroupsToNotify;
        }
        if (string == "systemTransferFilters") {
            return this.systemTransferFilters;
        }
        if (string == "adminGroups") {
            return this.adminGroups;
        }
        if (string == "systemAccounts") {
            return this.systemAccounts;
        }
        if (string == "systemCustomOperationsRun") {
            return this.systemCustomOperationsRun;
        }
        if (string == "sysMsgSendToGroupsEnabled") {
            return this.sysMsgSendToGroupsEnabled;
        }
        if (string == "fwdMessageCategoriesToEmailToNotify") {
            return this.fwdMessageCategoriesToEmailToNotify;
        }
        if (string == "vouchers") {
            return this.vouchers;
        }
        if (string == "adminGroupAccessibility") {
            return this.adminGroupAccessibility;
        }
        if (string == "userAlertsToNotify") {
            return this.userAlertsToNotify;
        }
        if (string == "loginUserPrincipalTypes") {
            return this.loginUserPrincipalTypes;
        }
        if (string == "authorizationRoles") {
            return this.authorizationRoles;
        }
        if (string == "managedProducts") {
            return this.managedProducts;
        }
        if (string == "externalPaymentsFailedToNotify") {
            return this.externalPaymentsFailedToNotify;
        }
        if (string == "sendMessagesFromSysWithCat") {
            return this.sendMessagesFromSysWithCat;
        }
        if (string == "authorizablePaymentsToNotify") {
            return this.authorizablePaymentsToNotify;
        }
        if (string == "systemPaymentRequestsSendToUser") {
            return this.systemPaymentRequestsSendToUser;
        }
        if (string == "defaultNotifications") {
            return this.defaultNotifications;
        }
        if (string == "systemToUserExternalPayments") {
            return this.systemToUserExternalPayments;
        }
        if (string == "systemImageCategoriesView") {
            return this.systemImageCategoriesView;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "manageIndividualProducts") {
            this.manageIndividualProducts = (Set)object;
            return;
        }
        if (string == "manageSpecificConfigurations") {
            this.manageSpecificConfigurations = (Set)object;
            return;
        }
        if (string == "voucherConfigurationsToNotify") {
            this.voucherConfigurationsToNotify = (Set)object;
            return;
        }
        if (string == "systemRecordTypes") {
            this.systemRecordTypes = (Set)object;
            return;
        }
        if (string == "viewMessagesSentToSysWithCat") {
            this.viewMessagesSentToSysWithCat = (Set)object;
            return;
        }
        if (string == "systemAlertsToNotify") {
            this.systemAlertsToNotify = (Set)object;
            return;
        }
        if (string == "accessibleAdminGroups") {
            this.accessibleAdminGroups = (Set)object;
            return;
        }
        if (string == "chargebackPaymentsToSystem") {
            this.chargebackPaymentsToSystem = (Set)object;
            return;
        }
        if (string == "manageMessagesSentToSysWithCat") {
            this.manageMessagesSentToSysWithCat = (Set)object;
            return;
        }
        if (string == "applicationTranslation") {
            this.applicationTranslation = (Set)object;
            return;
        }
        if (string == "externalPaymentsExpiredToNotify") {
            this.externalPaymentsExpiredToNotify = (Set)object;
            return;
        }
        if (string == "systemWizardsRun") {
            this.systemWizardsRun = (Set)object;
            return;
        }
        if (string == "systemImageCategoriesManage") {
            this.systemImageCategoriesManage = (Set)object;
            return;
        }
        if (string == "manageContentSpecificConfigurations") {
            this.manageContentSpecificConfigurations = (Set)object;
            return;
        }
        if (string == "voucherConfigurationsBuyingToNotify") {
            this.voucherConfigurationsBuyingToNotify = (Set)object;
            return;
        }
        if (string == "accessibleVoucherConfigurations") {
            this.accessibleVoucherConfigurations = (Set)object;
            return;
        }
        if (string == "systemPayments") {
            this.systemPayments = (Set)object;
            return;
        }
        if (string == "paymentsToNotify") {
            this.paymentsToNotify = (Set)object;
            return;
        }
        if (string == "userGroupsToNotify") {
            this.userGroupsToNotify = (Set)object;
            return;
        }
        if (string == "systemTransferFilters") {
            this.systemTransferFilters = (Set)object;
            return;
        }
        if (string == "adminGroups") {
            this.adminGroups = (Set)object;
            return;
        }
        if (string == "systemAccounts") {
            this.systemAccounts = (Set)object;
            return;
        }
        if (string == "systemCustomOperationsRun") {
            this.systemCustomOperationsRun = (Set)object;
            return;
        }
        if (string == "sysMsgSendToGroupsEnabled") {
            this.sysMsgSendToGroupsEnabled = (Boolean)object;
            return;
        }
        if (string == "fwdMessageCategoriesToEmailToNotify") {
            this.fwdMessageCategoriesToEmailToNotify = (Set)object;
            return;
        }
        if (string == "vouchers") {
            this.vouchers = (Set)object;
            return;
        }
        if (string == "adminGroupAccessibility") {
            this.adminGroupAccessibility = (AdminGroupAccessibility)object;
            return;
        }
        if (string == "userAlertsToNotify") {
            this.userAlertsToNotify = (Set)object;
            return;
        }
        if (string == "loginUserPrincipalTypes") {
            this.loginUserPrincipalTypes = (Set)object;
            return;
        }
        if (string == "authorizationRoles") {
            this.authorizationRoles = (Set)object;
            return;
        }
        if (string == "managedProducts") {
            this.managedProducts = (Set)object;
            return;
        }
        if (string == "externalPaymentsFailedToNotify") {
            this.externalPaymentsFailedToNotify = (Set)object;
            return;
        }
        if (string == "sendMessagesFromSysWithCat") {
            this.sendMessagesFromSysWithCat = (Set)object;
            return;
        }
        if (string == "authorizablePaymentsToNotify") {
            this.authorizablePaymentsToNotify = (Set)object;
            return;
        }
        if (string == "systemPaymentRequestsSendToUser") {
            this.systemPaymentRequestsSendToUser = (Set)object;
            return;
        }
        if (string == "defaultNotifications") {
            this.defaultNotifications = (Set)object;
            return;
        }
        if (string == "systemToUserExternalPayments") {
            this.systemToUserExternalPayments = (Set)object;
            return;
        }
        if (string == "systemImageCategoriesView") {
            this.systemImageCategoriesView = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_manageIndividualProducts() {
        this._persistence_checkFetched("manageIndividualProducts");
        return this.manageIndividualProducts;
    }

    public void _persistence_set_manageIndividualProducts(Set set) {
        this._persistence_checkFetchedForSet("manageIndividualProducts");
        this._persistence_propertyChange("manageIndividualProducts", this.manageIndividualProducts, set);
        this.manageIndividualProducts = set;
    }

    public Set _persistence_get_manageSpecificConfigurations() {
        this._persistence_checkFetched("manageSpecificConfigurations");
        return this.manageSpecificConfigurations;
    }

    public void _persistence_set_manageSpecificConfigurations(Set set) {
        this._persistence_checkFetchedForSet("manageSpecificConfigurations");
        this._persistence_propertyChange("manageSpecificConfigurations", this.manageSpecificConfigurations, set);
        this.manageSpecificConfigurations = set;
    }

    public Set _persistence_get_voucherConfigurationsToNotify() {
        this._persistence_checkFetched("voucherConfigurationsToNotify");
        return this.voucherConfigurationsToNotify;
    }

    public void _persistence_set_voucherConfigurationsToNotify(Set set) {
        this._persistence_checkFetchedForSet("voucherConfigurationsToNotify");
        this._persistence_propertyChange("voucherConfigurationsToNotify", this.voucherConfigurationsToNotify, set);
        this.voucherConfigurationsToNotify = set;
    }

    public Set _persistence_get_systemRecordTypes() {
        this._persistence_checkFetched("systemRecordTypes");
        return this.systemRecordTypes;
    }

    public void _persistence_set_systemRecordTypes(Set set) {
        this._persistence_checkFetchedForSet("systemRecordTypes");
        this._persistence_propertyChange("systemRecordTypes", this.systemRecordTypes, set);
        this.systemRecordTypes = set;
    }

    public Set _persistence_get_viewMessagesSentToSysWithCat() {
        this._persistence_checkFetched("viewMessagesSentToSysWithCat");
        return this.viewMessagesSentToSysWithCat;
    }

    public void _persistence_set_viewMessagesSentToSysWithCat(Set set) {
        this._persistence_checkFetchedForSet("viewMessagesSentToSysWithCat");
        this._persistence_propertyChange("viewMessagesSentToSysWithCat", this.viewMessagesSentToSysWithCat, set);
        this.viewMessagesSentToSysWithCat = set;
    }

    public Set _persistence_get_systemAlertsToNotify() {
        this._persistence_checkFetched("systemAlertsToNotify");
        return this.systemAlertsToNotify;
    }

    public void _persistence_set_systemAlertsToNotify(Set set) {
        this._persistence_checkFetchedForSet("systemAlertsToNotify");
        this._persistence_propertyChange("systemAlertsToNotify", this.systemAlertsToNotify, set);
        this.systemAlertsToNotify = set;
    }

    public Set _persistence_get_accessibleAdminGroups() {
        this._persistence_checkFetched("accessibleAdminGroups");
        return this.accessibleAdminGroups;
    }

    public void _persistence_set_accessibleAdminGroups(Set set) {
        this._persistence_checkFetchedForSet("accessibleAdminGroups");
        this._persistence_propertyChange("accessibleAdminGroups", this.accessibleAdminGroups, set);
        this.accessibleAdminGroups = set;
    }

    public Set _persistence_get_chargebackPaymentsToSystem() {
        this._persistence_checkFetched("chargebackPaymentsToSystem");
        return this.chargebackPaymentsToSystem;
    }

    public void _persistence_set_chargebackPaymentsToSystem(Set set) {
        this._persistence_checkFetchedForSet("chargebackPaymentsToSystem");
        this._persistence_propertyChange("chargebackPaymentsToSystem", this.chargebackPaymentsToSystem, set);
        this.chargebackPaymentsToSystem = set;
    }

    public Set _persistence_get_manageMessagesSentToSysWithCat() {
        this._persistence_checkFetched("manageMessagesSentToSysWithCat");
        return this.manageMessagesSentToSysWithCat;
    }

    public void _persistence_set_manageMessagesSentToSysWithCat(Set set) {
        this._persistence_checkFetchedForSet("manageMessagesSentToSysWithCat");
        this._persistence_propertyChange("manageMessagesSentToSysWithCat", this.manageMessagesSentToSysWithCat, set);
        this.manageMessagesSentToSysWithCat = set;
    }

    public Set _persistence_get_applicationTranslation() {
        this._persistence_checkFetched("applicationTranslation");
        return this.applicationTranslation;
    }

    public void _persistence_set_applicationTranslation(Set set) {
        this._persistence_checkFetchedForSet("applicationTranslation");
        this._persistence_propertyChange("applicationTranslation", this.applicationTranslation, set);
        this.applicationTranslation = set;
    }

    public Set _persistence_get_externalPaymentsExpiredToNotify() {
        this._persistence_checkFetched("externalPaymentsExpiredToNotify");
        return this.externalPaymentsExpiredToNotify;
    }

    public void _persistence_set_externalPaymentsExpiredToNotify(Set set) {
        this._persistence_checkFetchedForSet("externalPaymentsExpiredToNotify");
        this._persistence_propertyChange("externalPaymentsExpiredToNotify", this.externalPaymentsExpiredToNotify, set);
        this.externalPaymentsExpiredToNotify = set;
    }

    public Set _persistence_get_systemWizardsRun() {
        this._persistence_checkFetched("systemWizardsRun");
        return this.systemWizardsRun;
    }

    public void _persistence_set_systemWizardsRun(Set set) {
        this._persistence_checkFetchedForSet("systemWizardsRun");
        this._persistence_propertyChange("systemWizardsRun", this.systemWizardsRun, set);
        this.systemWizardsRun = set;
    }

    public Set _persistence_get_systemImageCategoriesManage() {
        this._persistence_checkFetched("systemImageCategoriesManage");
        return this.systemImageCategoriesManage;
    }

    public void _persistence_set_systemImageCategoriesManage(Set set) {
        this._persistence_checkFetchedForSet("systemImageCategoriesManage");
        this._persistence_propertyChange("systemImageCategoriesManage", this.systemImageCategoriesManage, set);
        this.systemImageCategoriesManage = set;
    }

    public Set _persistence_get_manageContentSpecificConfigurations() {
        this._persistence_checkFetched("manageContentSpecificConfigurations");
        return this.manageContentSpecificConfigurations;
    }

    public void _persistence_set_manageContentSpecificConfigurations(Set set) {
        this._persistence_checkFetchedForSet("manageContentSpecificConfigurations");
        this._persistence_propertyChange("manageContentSpecificConfigurations", this.manageContentSpecificConfigurations, set);
        this.manageContentSpecificConfigurations = set;
    }

    public Set _persistence_get_voucherConfigurationsBuyingToNotify() {
        this._persistence_checkFetched("voucherConfigurationsBuyingToNotify");
        return this.voucherConfigurationsBuyingToNotify;
    }

    public void _persistence_set_voucherConfigurationsBuyingToNotify(Set set) {
        this._persistence_checkFetchedForSet("voucherConfigurationsBuyingToNotify");
        this._persistence_propertyChange("voucherConfigurationsBuyingToNotify", this.voucherConfigurationsBuyingToNotify, set);
        this.voucherConfigurationsBuyingToNotify = set;
    }

    public Set _persistence_get_accessibleVoucherConfigurations() {
        this._persistence_checkFetched("accessibleVoucherConfigurations");
        return this.accessibleVoucherConfigurations;
    }

    public void _persistence_set_accessibleVoucherConfigurations(Set set) {
        this._persistence_checkFetchedForSet("accessibleVoucherConfigurations");
        this._persistence_propertyChange("accessibleVoucherConfigurations", this.accessibleVoucherConfigurations, set);
        this.accessibleVoucherConfigurations = set;
    }

    public Set _persistence_get_systemPayments() {
        this._persistence_checkFetched("systemPayments");
        return this.systemPayments;
    }

    public void _persistence_set_systemPayments(Set set) {
        this._persistence_checkFetchedForSet("systemPayments");
        this._persistence_propertyChange("systemPayments", this.systemPayments, set);
        this.systemPayments = set;
    }

    public Set _persistence_get_paymentsToNotify() {
        this._persistence_checkFetched("paymentsToNotify");
        return this.paymentsToNotify;
    }

    public void _persistence_set_paymentsToNotify(Set set) {
        this._persistence_checkFetchedForSet("paymentsToNotify");
        this._persistence_propertyChange("paymentsToNotify", this.paymentsToNotify, set);
        this.paymentsToNotify = set;
    }

    public Set _persistence_get_userGroupsToNotify() {
        this._persistence_checkFetched("userGroupsToNotify");
        return this.userGroupsToNotify;
    }

    public void _persistence_set_userGroupsToNotify(Set set) {
        this._persistence_checkFetchedForSet("userGroupsToNotify");
        this._persistence_propertyChange("userGroupsToNotify", this.userGroupsToNotify, set);
        this.userGroupsToNotify = set;
    }

    public Set _persistence_get_systemTransferFilters() {
        this._persistence_checkFetched("systemTransferFilters");
        return this.systemTransferFilters;
    }

    public void _persistence_set_systemTransferFilters(Set set) {
        this._persistence_checkFetchedForSet("systemTransferFilters");
        this._persistence_propertyChange("systemTransferFilters", this.systemTransferFilters, set);
        this.systemTransferFilters = set;
    }

    public Set _persistence_get_adminGroups() {
        this._persistence_checkFetched("adminGroups");
        return this.adminGroups;
    }

    public void _persistence_set_adminGroups(Set set) {
        this._persistence_checkFetchedForSet("adminGroups");
        this._persistence_propertyChange("adminGroups", this.adminGroups, set);
        this.adminGroups = set;
    }

    public Set _persistence_get_systemAccounts() {
        this._persistence_checkFetched("systemAccounts");
        return this.systemAccounts;
    }

    public void _persistence_set_systemAccounts(Set set) {
        this._persistence_checkFetchedForSet("systemAccounts");
        this._persistence_propertyChange("systemAccounts", this.systemAccounts, set);
        this.systemAccounts = set;
    }

    public Set _persistence_get_systemCustomOperationsRun() {
        this._persistence_checkFetched("systemCustomOperationsRun");
        return this.systemCustomOperationsRun;
    }

    public void _persistence_set_systemCustomOperationsRun(Set set) {
        this._persistence_checkFetchedForSet("systemCustomOperationsRun");
        this._persistence_propertyChange("systemCustomOperationsRun", this.systemCustomOperationsRun, set);
        this.systemCustomOperationsRun = set;
    }

    public boolean _persistence_get_sysMsgSendToGroupsEnabled() {
        this._persistence_checkFetched("sysMsgSendToGroupsEnabled");
        return this.sysMsgSendToGroupsEnabled;
    }

    public void _persistence_set_sysMsgSendToGroupsEnabled(boolean bl) {
        this._persistence_checkFetchedForSet("sysMsgSendToGroupsEnabled");
        this._persistence_propertyChange("sysMsgSendToGroupsEnabled", new Boolean(this.sysMsgSendToGroupsEnabled), new Boolean(bl));
        this.sysMsgSendToGroupsEnabled = bl;
    }

    public Set _persistence_get_fwdMessageCategoriesToEmailToNotify() {
        this._persistence_checkFetched("fwdMessageCategoriesToEmailToNotify");
        return this.fwdMessageCategoriesToEmailToNotify;
    }

    public void _persistence_set_fwdMessageCategoriesToEmailToNotify(Set set) {
        this._persistence_checkFetchedForSet("fwdMessageCategoriesToEmailToNotify");
        this._persistence_propertyChange("fwdMessageCategoriesToEmailToNotify", this.fwdMessageCategoriesToEmailToNotify, set);
        this.fwdMessageCategoriesToEmailToNotify = set;
    }

    public Set _persistence_get_vouchers() {
        this._persistence_checkFetched("vouchers");
        return this.vouchers;
    }

    public void _persistence_set_vouchers(Set set) {
        this._persistence_checkFetchedForSet("vouchers");
        this._persistence_propertyChange("vouchers", this.vouchers, set);
        this.vouchers = set;
    }

    public AdminGroupAccessibility _persistence_get_adminGroupAccessibility() {
        this._persistence_checkFetched("adminGroupAccessibility");
        return this.adminGroupAccessibility;
    }

    public void _persistence_set_adminGroupAccessibility(AdminGroupAccessibility adminGroupAccessibility) {
        this._persistence_checkFetchedForSet("adminGroupAccessibility");
        this._persistence_propertyChange("adminGroupAccessibility", this.adminGroupAccessibility, adminGroupAccessibility);
        this.adminGroupAccessibility = adminGroupAccessibility;
    }

    public Set _persistence_get_userAlertsToNotify() {
        this._persistence_checkFetched("userAlertsToNotify");
        return this.userAlertsToNotify;
    }

    public void _persistence_set_userAlertsToNotify(Set set) {
        this._persistence_checkFetchedForSet("userAlertsToNotify");
        this._persistence_propertyChange("userAlertsToNotify", this.userAlertsToNotify, set);
        this.userAlertsToNotify = set;
    }

    public Set _persistence_get_loginUserPrincipalTypes() {
        this._persistence_checkFetched("loginUserPrincipalTypes");
        return this.loginUserPrincipalTypes;
    }

    public void _persistence_set_loginUserPrincipalTypes(Set set) {
        this._persistence_checkFetchedForSet("loginUserPrincipalTypes");
        this._persistence_propertyChange("loginUserPrincipalTypes", this.loginUserPrincipalTypes, set);
        this.loginUserPrincipalTypes = set;
    }

    public Set _persistence_get_authorizationRoles() {
        this._persistence_checkFetched("authorizationRoles");
        return this.authorizationRoles;
    }

    public void _persistence_set_authorizationRoles(Set set) {
        this._persistence_checkFetchedForSet("authorizationRoles");
        this._persistence_propertyChange("authorizationRoles", this.authorizationRoles, set);
        this.authorizationRoles = set;
    }

    public Set _persistence_get_managedProducts() {
        this._persistence_checkFetched("managedProducts");
        return this.managedProducts;
    }

    public void _persistence_set_managedProducts(Set set) {
        this._persistence_checkFetchedForSet("managedProducts");
        this._persistence_propertyChange("managedProducts", this.managedProducts, set);
        this.managedProducts = set;
    }

    public Set _persistence_get_externalPaymentsFailedToNotify() {
        this._persistence_checkFetched("externalPaymentsFailedToNotify");
        return this.externalPaymentsFailedToNotify;
    }

    public void _persistence_set_externalPaymentsFailedToNotify(Set set) {
        this._persistence_checkFetchedForSet("externalPaymentsFailedToNotify");
        this._persistence_propertyChange("externalPaymentsFailedToNotify", this.externalPaymentsFailedToNotify, set);
        this.externalPaymentsFailedToNotify = set;
    }

    public Set _persistence_get_sendMessagesFromSysWithCat() {
        this._persistence_checkFetched("sendMessagesFromSysWithCat");
        return this.sendMessagesFromSysWithCat;
    }

    public void _persistence_set_sendMessagesFromSysWithCat(Set set) {
        this._persistence_checkFetchedForSet("sendMessagesFromSysWithCat");
        this._persistence_propertyChange("sendMessagesFromSysWithCat", this.sendMessagesFromSysWithCat, set);
        this.sendMessagesFromSysWithCat = set;
    }

    public Set _persistence_get_authorizablePaymentsToNotify() {
        this._persistence_checkFetched("authorizablePaymentsToNotify");
        return this.authorizablePaymentsToNotify;
    }

    public void _persistence_set_authorizablePaymentsToNotify(Set set) {
        this._persistence_checkFetchedForSet("authorizablePaymentsToNotify");
        this._persistence_propertyChange("authorizablePaymentsToNotify", this.authorizablePaymentsToNotify, set);
        this.authorizablePaymentsToNotify = set;
    }

    public Set _persistence_get_systemPaymentRequestsSendToUser() {
        this._persistence_checkFetched("systemPaymentRequestsSendToUser");
        return this.systemPaymentRequestsSendToUser;
    }

    public void _persistence_set_systemPaymentRequestsSendToUser(Set set) {
        this._persistence_checkFetchedForSet("systemPaymentRequestsSendToUser");
        this._persistence_propertyChange("systemPaymentRequestsSendToUser", this.systemPaymentRequestsSendToUser, set);
        this.systemPaymentRequestsSendToUser = set;
    }

    public Set _persistence_get_defaultNotifications() {
        this._persistence_checkFetched("defaultNotifications");
        return this.defaultNotifications;
    }

    public void _persistence_set_defaultNotifications(Set set) {
        this._persistence_checkFetchedForSet("defaultNotifications");
        this._persistence_propertyChange("defaultNotifications", this.defaultNotifications, set);
        this.defaultNotifications = set;
    }

    public Set _persistence_get_systemToUserExternalPayments() {
        this._persistence_checkFetched("systemToUserExternalPayments");
        return this.systemToUserExternalPayments;
    }

    public void _persistence_set_systemToUserExternalPayments(Set set) {
        this._persistence_checkFetchedForSet("systemToUserExternalPayments");
        this._persistence_propertyChange("systemToUserExternalPayments", this.systemToUserExternalPayments, set);
        this.systemToUserExternalPayments = set;
    }

    public Set _persistence_get_systemImageCategoriesView() {
        this._persistence_checkFetched("systemImageCategoriesView");
        return this.systemImageCategoriesView;
    }

    public void _persistence_set_systemImageCategoriesView(Set set) {
        this._persistence_checkFetchedForSet("systemImageCategoriesView");
        this._persistence_propertyChange("systemImageCategoriesView", this.systemImageCategoriesView, set);
        this.systemImageCategoriesView = set;
    }
}

