/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.Network;
import org.cyclos.model.system.scripts.CustomScriptUsedInType;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.model.system.scripts.UsesScript;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="custom_scripts")
@Cacheable(value=true)
public class CustomScript
extends ConfigurationEntity
implements DefinesNetwork,
UsesScript,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id")
    private Network network;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    private ScriptType type;
    @ElementCollection
    @CollectionTable(name="custom_script_functions", joinColumns={@JoinColumn(name="script_id")})
    @MapKeyColumn(name="function", nullable=false)
    @Lob
    @Column(name="code")
    private Map<String, String> functions = new HashMap<String, String>();
    @ManyToMany
    @JoinTable(name="custom_script_dependencies", joinColumns={@JoinColumn(name="script_id")}, inverseJoinColumns={@JoinColumn(name="library_id")})
    private Set<CustomScript> dependencies = new HashSet<CustomScript>();
    @Basic
    @Lob
    @Column(name="parameters")
    private String parameters;
    @Basic
    @Column(name="run_as_system")
    private boolean isRunAsSystem;
    static final long serialVersionUID = -6479513841817303931L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    public Set<CustomScript> getDependencies() {
        return this._persistence_get_dependencies();
    }

    public Map<String, String> getFunctions() {
        return this._persistence_get_functions();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public String getParameters() {
        return this._persistence_get_parameters();
    }

    public CustomScriptUsedInType getScriptUsedInType() {
        return CustomScriptUsedInType.SCRIPT;
    }

    public ScriptType getType() {
        return this._persistence_get_type();
    }

    public boolean isRunAsSystem() {
        return this._persistence_get_isRunAsSystem();
    }

    public void setDependencies(Set<CustomScript> set) {
        this._persistence_set_dependencies(set);
    }

    public void setFunctions(Map<String, String> map) {
        this._persistence_set_functions(map);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue("");
            }
        }
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setParameters(String string) {
        this._persistence_set_parameters(string);
    }

    public void setRunAsSystem(boolean bl) {
        this._persistence_set_isRunAsSystem(bl);
    }

    public void setType(ScriptType scriptType) {
        this._persistence_set_type(scriptType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CustomScript();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "functions") {
            return this.functions;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "isRunAsSystem") {
            return this.isRunAsSystem;
        }
        if (string == "parameters") {
            return this.parameters;
        }
        if (string == "network") {
            return this.network;
        }
        if (string == "dependencies") {
            return this.dependencies;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "functions") {
            this.functions = (Map)object;
            return;
        }
        if (string == "type") {
            this.type = (ScriptType)object;
            return;
        }
        if (string == "isRunAsSystem") {
            this.isRunAsSystem = (Boolean)object;
            return;
        }
        if (string == "parameters") {
            this.parameters = (String)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        if (string == "dependencies") {
            this.dependencies = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Map _persistence_get_functions() {
        this._persistence_checkFetched("functions");
        return this.functions;
    }

    public void _persistence_set_functions(Map map) {
        this._persistence_checkFetchedForSet("functions");
        this._persistence_propertyChange("functions", this.functions, map);
        this.functions = map;
    }

    public ScriptType _persistence_get_type() {
        this._persistence_checkFetched("type");
        return this.type;
    }

    public void _persistence_set_type(ScriptType scriptType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_propertyChange("type", this.type, scriptType);
        this.type = scriptType;
    }

    public boolean _persistence_get_isRunAsSystem() {
        this._persistence_checkFetched("isRunAsSystem");
        return this.isRunAsSystem;
    }

    public void _persistence_set_isRunAsSystem(boolean bl) {
        this._persistence_checkFetchedForSet("isRunAsSystem");
        this._persistence_propertyChange("isRunAsSystem", new Boolean(this.isRunAsSystem), new Boolean(bl));
        this.isRunAsSystem = bl;
    }

    public String _persistence_get_parameters() {
        this._persistence_checkFetched("parameters");
        return this.parameters;
    }

    public void _persistence_set_parameters(String string) {
        this._persistence_checkFetchedForSet("parameters");
        this._persistence_propertyChange("parameters", this.parameters, string);
        this.parameters = string;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }

    public Set _persistence_get_dependencies() {
        this._persistence_checkFetched("dependencies");
        return this.dependencies;
    }

    public void _persistence_set_dependencies(Set set) {
        this._persistence_checkFetchedForSet("dependencies");
        this._persistence_propertyChange("dependencies", this.dependencies, set);
        this.dependencies = set;
    }
}

