/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.system;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.system.CustomRecurringTask;
import org.cyclos.entities.system.Network;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskLogStatus;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="custom_recurring_task_logs", indexes={@Index(name="ix_custom_recurring_task_logs_status", columnList="status"), @Index(name="ix_custom_recurring_task_logs_task_date", unique=true, columnList="task_id, date")})
public class CustomRecurringTaskLog
extends NetworkedEntity
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="task_id", nullable=false)
    private CustomRecurringTask task;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="date", nullable=false)
    private Date date;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    private CustomRecurringTaskLogStatus status;
    @Basic
    @Lob
    @Column(name="message")
    private String message;
    @Basic
    @Column(name="time_taken")
    private Integer timeTaken;
    @Basic
    @Lob
    @Column(name="error_stack_trace")
    private String errorStackTrace;
    static final long serialVersionUID = -468604379715514754L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_task_vh;

    public Date getDate() {
        return this._persistence_get_date();
    }

    public String getErrorStackTrace() {
        return this._persistence_get_errorStackTrace();
    }

    public String getMessage() {
        return this._persistence_get_message();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_task().getNetwork();
    }

    public CustomRecurringTaskLogStatus getStatus() {
        return this._persistence_get_status();
    }

    public CustomRecurringTask getTask() {
        return this._persistence_get_task();
    }

    public Integer getTimeTaken() {
        return this._persistence_get_timeTaken();
    }

    public boolean isSuccess() {
        return StringHelper.isBlank((Object)this._persistence_get_errorStackTrace());
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    public void setErrorStackTrace(String string) {
        this._persistence_set_errorStackTrace(string);
    }

    public void setMessage(String string) {
        this._persistence_set_message(string);
    }

    public void setStatus(CustomRecurringTaskLogStatus customRecurringTaskLogStatus) {
        this._persistence_set_status(customRecurringTaskLogStatus);
    }

    public void setTask(CustomRecurringTask customRecurringTask) {
        this._persistence_set_task(customRecurringTask);
    }

    public void setTimeTaken(Integer n) {
        this._persistence_set_timeTaken(n);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_task_vh != null) {
            this._persistence_task_vh = (WeavedAttributeValueHolderInterface)this._persistence_task_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CustomRecurringTaskLog();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "timeTaken") {
            return this.timeTaken;
        }
        if (string == "errorStackTrace") {
            return this.errorStackTrace;
        }
        if (string == "task") {
            return this.task;
        }
        if (string == "message") {
            return this.message;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "timeTaken") {
            this.timeTaken = (Integer)object;
            return;
        }
        if (string == "errorStackTrace") {
            this.errorStackTrace = (String)object;
            return;
        }
        if (string == "task") {
            this.task = (CustomRecurringTask)object;
            return;
        }
        if (string == "message") {
            this.message = (String)object;
            return;
        }
        if (string == "status") {
            this.status = (CustomRecurringTaskLogStatus)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    public Integer _persistence_get_timeTaken() {
        this._persistence_checkFetched("timeTaken");
        return this.timeTaken;
    }

    public void _persistence_set_timeTaken(Integer n) {
        this._persistence_checkFetchedForSet("timeTaken");
        this._persistence_propertyChange("timeTaken", this.timeTaken, n);
        this.timeTaken = n;
    }

    public String _persistence_get_errorStackTrace() {
        this._persistence_checkFetched("errorStackTrace");
        return this.errorStackTrace;
    }

    public void _persistence_set_errorStackTrace(String string) {
        this._persistence_checkFetchedForSet("errorStackTrace");
        this._persistence_propertyChange("errorStackTrace", this.errorStackTrace, string);
        this.errorStackTrace = string;
    }

    protected void _persistence_initialize_task_vh() {
        if (this._persistence_task_vh == null) {
            this._persistence_task_vh = new ValueHolder((Object)this.task);
            this._persistence_task_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_task_vh() {
        CustomRecurringTask customRecurringTask;
        this._persistence_initialize_task_vh();
        if ((this._persistence_task_vh.isCoordinatedWithProperty() || this._persistence_task_vh.isNewlyWeavedValueHolder()) && (customRecurringTask = this._persistence_get_task()) != this._persistence_task_vh.getValue()) {
            this._persistence_set_task(customRecurringTask);
        }
        return this._persistence_task_vh;
    }

    public void _persistence_set_task_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_task_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CustomRecurringTask customRecurringTask = this._persistence_get_task();
            if (customRecurringTask != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_task((CustomRecurringTask)object);
            }
        } else {
            this.task = null;
        }
    }

    public CustomRecurringTask _persistence_get_task() {
        this._persistence_checkFetched("task");
        this._persistence_initialize_task_vh();
        this.task = (CustomRecurringTask)this._persistence_task_vh.getValue();
        return this.task;
    }

    public void _persistence_set_task(CustomRecurringTask customRecurringTask) {
        this._persistence_checkFetchedForSet("task");
        this._persistence_initialize_task_vh();
        this.task = (CustomRecurringTask)this._persistence_task_vh.getValue();
        this._persistence_propertyChange("task", this.task, customRecurringTask);
        this.task = customRecurringTask;
        this._persistence_task_vh.setValue((Object)customRecurringTask);
    }

    public String _persistence_get_message() {
        this._persistence_checkFetched("message");
        return this.message;
    }

    public void _persistence_set_message(String string) {
        this._persistence_checkFetchedForSet("message");
        this._persistence_propertyChange("message", this.message, string);
        this.message = string;
    }

    public CustomRecurringTaskLogStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(CustomRecurringTaskLogStatus customRecurringTaskLogStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, customRecurringTaskLogStatus);
        this.status = customRecurringTaskLogStatus;
    }
}

