/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.Date;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.RecurringPaymentOccurrence;
import org.cyclos.entities.banking.TransactionWithInstallments;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.model.banking.transactions.HasShowToReceiver;
import org.cyclos.model.banking.transactions.HasTransactionStatus;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.model.banking.transactions.RecurringPaymentStatus;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.utils.Location;
import org.cyclos.utils.ObjectHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="RECURRING_PAYMENT")
public class RecurringPayment
extends BasePayment
implements HasTransactionStatus<RecurringPaymentStatus>,
HasShowToReceiver,
TransactionWithInstallments<RecurringPaymentOccurrence>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="occurrence_interval_amount")), @AttributeOverride(name="field", column=@Column(name="occurrence_interval_field"))})
    private TimeInterval occurrenceInterval;
    @Basic
    @Column(name="occurrences_count")
    private Integer occurrencesCount;
    static final long serialVersionUID = 5771644106723855334L;

    @Override
    public List<RecurringPaymentOccurrence> getInstallments() {
        return this.getOccurrences();
    }

    @Override
    public Integer getInstallmentsCount() {
        return this._persistence_get_occurrencesCount();
    }

    public int getLastOccurrenceNumber() {
        RecurringPaymentOccurrence recurringPaymentOccurrence = (RecurringPaymentOccurrence)this.getLastProcessedInstallment();
        Integer n = recurringPaymentOccurrence == null ? null : Integer.valueOf(recurringPaymentOccurrence.getNumber());
        return (Integer)ObjectHelper.defaultValue((Object)n, (Object)0);
    }

    @Override
    public Location getLocation() {
        return Location.RECURRING_PAYMENT;
    }

    @Override
    public TransactionNature getNature() {
        return TransactionNature.RECURRING_PAYMENT;
    }

    public RecurringPaymentOccurrence getNextOccurrence() {
        return this.getOccurrences().stream().filter(recurringPaymentOccurrence -> recurringPaymentOccurrence.getStatus() == InstallmentStatus.SCHEDULED).findFirst().orElse(null);
    }

    public Date getNextOccurrenceDate() {
        RecurringPaymentOccurrence recurringPaymentOccurrence = this.getNextOccurrence();
        return recurringPaymentOccurrence == null ? null : recurringPaymentOccurrence.getDueDate();
    }

    public TimeInterval getOccurrenceInterval() {
        return this._persistence_get_occurrenceInterval();
    }

    public List<RecurringPaymentOccurrence> getOccurrences() {
        return this._persistence_get_installments();
    }

    public Integer getOccurrencesCount() {
        return this._persistence_get_occurrencesCount();
    }

    public RecurringPaymentStatus getStatus() {
        return this._persistence_get_status() == null ? null : RecurringPaymentStatus.valueOf((String)this._persistence_get_status());
    }

    public boolean isShowToReceiver() {
        return Boolean.TRUE.equals(this._persistence_get_showToReceiver());
    }

    public void setOccurrenceInterval(TimeInterval timeInterval) {
        this._persistence_set_occurrenceInterval(timeInterval);
    }

    public void setOccurrences(List<RecurringPaymentOccurrence> list) {
        this._persistence_set_installments(list);
    }

    public void setOccurrencesCount(Integer n) {
        this._persistence_set_occurrencesCount(n);
    }

    public void setShowToReceiver(boolean bl) {
        this._persistence_set_showToReceiver(bl);
    }

    public void setStatus(RecurringPaymentStatus recurringPaymentStatus) {
        this._persistence_set_status(recurringPaymentStatus.name());
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RecurringPayment();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "occurrenceInterval") {
            return this.occurrenceInterval;
        }
        if (string == "occurrencesCount") {
            return this.occurrencesCount;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "occurrenceInterval") {
            this.occurrenceInterval = (TimeInterval)object;
            return;
        }
        if (string == "occurrencesCount") {
            this.occurrencesCount = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public TimeInterval _persistence_get_occurrenceInterval() {
        this._persistence_checkFetched("occurrenceInterval");
        return this.occurrenceInterval;
    }

    public void _persistence_set_occurrenceInterval(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("occurrenceInterval");
        this._persistence_propertyChange("occurrenceInterval", this.occurrenceInterval, timeInterval);
        this.occurrenceInterval = timeInterval;
    }

    public Integer _persistence_get_occurrencesCount() {
        this._persistence_checkFetched("occurrencesCount");
        return this.occurrencesCount;
    }

    public void _persistence_set_occurrencesCount(Integer n) {
        this._persistence_checkFetchedForSet("occurrencesCount");
        this._persistence_propertyChange("occurrencesCount", this.occurrencesCount, n);
        this.occurrencesCount = n;
    }
}

