/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.MaxScale;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.system.Network;
import org.cyclos.model.banking.rates.RateType;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="rate_parameters")
@DiscriminatorColumn(name="subclass")
public abstract class RateParameters
extends BaseEntity
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="currency_id")
    private Currency currency;
    @Basic
    @Column(name="creation_value", nullable=false, updatable=false)
    @MaxScale
    protected BigDecimal creationValue = BigDecimal.ZERO;
    @Basic
    @Column(name="start_date", updatable=false, nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startDate;
    @Basic
    @Column(name="end_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date endDate;
    @Basic
    @Column(name="show_to_user", updatable=false)
    private boolean showToUser;
    @Basic
    @Column(name="marked_for_resetting", nullable=false)
    private boolean markedForResetting = false;
    static final long serialVersionUID = -3173575954746012235L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_currency_vh;

    public BigDecimal getCreationValue() {
        return BigDecimal.ZERO;
    }

    public Currency getCurrency() {
        return this._persistence_get_currency();
    }

    public Date getEndDate() {
        return this._persistence_get_endDate();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_currency().getNetwork();
    }

    public abstract RateType getRateType();

    public Date getStartDate() {
        return this._persistence_get_startDate();
    }

    public boolean isActual() {
        return this._persistence_get_endDate() == null;
    }

    public boolean isMarkedForResetting() {
        return this._persistence_get_markedForResetting();
    }

    public boolean isShowToUser() {
        return this._persistence_get_showToUser();
    }

    public void setCurrency(Currency currency) {
        this._persistence_set_currency(currency);
    }

    public void setEndDate(Date date) {
        this._persistence_set_endDate(date);
    }

    public void setMarkedForResetting(boolean bl) {
        this._persistence_set_markedForResetting(bl);
    }

    public void setShowToUser(boolean bl) {
        this._persistence_set_showToUser(bl);
    }

    public void setStartDate(Date date) {
        this._persistence_set_startDate(date);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_currency_vh != null) {
            this._persistence_currency_vh = (WeavedAttributeValueHolderInterface)this._persistence_currency_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RateParameters();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "endDate") {
            return this.endDate;
        }
        if (string == "markedForResetting") {
            return this.markedForResetting;
        }
        if (string == "creationValue") {
            return this.creationValue;
        }
        if (string == "currency") {
            return this.currency;
        }
        if (string == "showToUser") {
            return this.showToUser;
        }
        if (string == "startDate") {
            return this.startDate;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "endDate") {
            this.endDate = (Date)object;
            return;
        }
        if (string == "markedForResetting") {
            this.markedForResetting = (Boolean)object;
            return;
        }
        if (string == "creationValue") {
            this.creationValue = (BigDecimal)object;
            return;
        }
        if (string == "currency") {
            this.currency = (Currency)object;
            return;
        }
        if (string == "showToUser") {
            this.showToUser = (Boolean)object;
            return;
        }
        if (string == "startDate") {
            this.startDate = (Date)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_endDate() {
        this._persistence_checkFetched("endDate");
        return this.endDate;
    }

    public void _persistence_set_endDate(Date date) {
        this._persistence_checkFetchedForSet("endDate");
        this._persistence_propertyChange("endDate", this.endDate, date);
        this.endDate = date;
    }

    public boolean _persistence_get_markedForResetting() {
        this._persistence_checkFetched("markedForResetting");
        return this.markedForResetting;
    }

    public void _persistence_set_markedForResetting(boolean bl) {
        this._persistence_checkFetchedForSet("markedForResetting");
        this._persistence_propertyChange("markedForResetting", new Boolean(this.markedForResetting), new Boolean(bl));
        this.markedForResetting = bl;
    }

    public BigDecimal _persistence_get_creationValue() {
        this._persistence_checkFetched("creationValue");
        return this.creationValue;
    }

    public void _persistence_set_creationValue(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("creationValue");
        this._persistence_propertyChange("creationValue", this.creationValue, bigDecimal);
        this.creationValue = bigDecimal;
    }

    protected void _persistence_initialize_currency_vh() {
        if (this._persistence_currency_vh == null) {
            this._persistence_currency_vh = new ValueHolder((Object)this.currency);
            this._persistence_currency_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_currency_vh() {
        Currency currency;
        this._persistence_initialize_currency_vh();
        if ((this._persistence_currency_vh.isCoordinatedWithProperty() || this._persistence_currency_vh.isNewlyWeavedValueHolder()) && (currency = this._persistence_get_currency()) != this._persistence_currency_vh.getValue()) {
            this._persistence_set_currency(currency);
        }
        return this._persistence_currency_vh;
    }

    public void _persistence_set_currency_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_currency_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Currency currency = this._persistence_get_currency();
            if (currency != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_currency((Currency)object);
            }
        } else {
            this.currency = null;
        }
    }

    public Currency _persistence_get_currency() {
        this._persistence_checkFetched("currency");
        this._persistence_initialize_currency_vh();
        this.currency = (Currency)this._persistence_currency_vh.getValue();
        return this.currency;
    }

    public void _persistence_set_currency(Currency currency) {
        this._persistence_checkFetchedForSet("currency");
        this._persistence_initialize_currency_vh();
        this.currency = (Currency)this._persistence_currency_vh.getValue();
        this._persistence_propertyChange("currency", this.currency, currency);
        this.currency = currency;
        this._persistence_currency_vh.setValue((Object)currency);
    }

    public boolean _persistence_get_showToUser() {
        this._persistence_checkFetched("showToUser");
        return this.showToUser;
    }

    public void _persistence_set_showToUser(boolean bl) {
        this._persistence_checkFetchedForSet("showToUser");
        this._persistence_propertyChange("showToUser", new Boolean(this.showToUser), new Boolean(bl));
        this.showToUser = bl;
    }

    public Date _persistence_get_startDate() {
        this._persistence_checkFetched("startDate");
        return this.startDate;
    }

    public void _persistence_set_startDate(Date date) {
        this._persistence_checkFetchedForSet("startDate");
        this._persistence_propertyChange("startDate", this.startDate, date);
        this.startDate = date;
    }
}

