/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.AuthorizationRole;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="authorization_levels")
public class AuthorizationLevel
extends BaseEntity
implements Comparable<AuthorizationLevel>,
IInternalNamedEntity,
HasCurrency,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="transfer_type_id", nullable=false, updatable=false)
    private PaymentTransferType transferType;
    @Basic
    @Column(name="level", nullable=false)
    private Integer level;
    @Basic
    @Column(name="receiver", nullable=false)
    private boolean receiver;
    @Basic
    @Column(name="payer", nullable=false)
    private boolean payer;
    @Basic
    @Column(name="broker", nullable=false)
    private boolean broker;
    @Basic
    @Column(name="internal_name", length=50)
    private String internalName;
    @Basic
    @Column(name="show_comments_to_users", nullable=false)
    private boolean showCommentsToUsers;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="min", column=@Column(name="min_amount")), @AttributeOverride(name="max", column=@Column(name="max_amount"))})
    @CurrencyScale
    private DecimalRange amountRange;
    @ManyToMany
    @JoinTable(name="authorization_levels_roles", joinColumns={@JoinColumn(name="authorization_level_id")}, inverseJoinColumns={@JoinColumn(name="authorization_role_id")})
    private Set<AuthorizationRole> roles = new HashSet<AuthorizationRole>();
    static final long serialVersionUID = -5118629025762091710L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_transferType_vh;

    @Override
    public int compareTo(AuthorizationLevel authorizationLevel) {
        if (!this.getTransferType().equals(authorizationLevel.getTransferType())) {
            return 0;
        }
        if (this.getLevel() == null) {
            return 1;
        }
        if (authorizationLevel.getLevel() == null) {
            return -1;
        }
        return this.getLevel().compareTo(authorizationLevel.getLevel());
    }

    public DecimalRange getAmountRange() {
        return this._persistence_get_amountRange();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_transferType().getCurrency();
    }

    public String getInternalName() {
        return this._persistence_get_internalName();
    }

    public Integer getLevel() {
        return this._persistence_get_level();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_transferType().getNetwork();
    }

    public Set<AuthorizationRole> getRoles() {
        return this._persistence_get_roles();
    }

    public PaymentTransferType getTransferType() {
        return this._persistence_get_transferType();
    }

    public boolean isAdmin() {
        return CollectionHelper.isNotEmpty(this.getRoles());
    }

    public boolean isBroker() {
        return this._persistence_get_broker();
    }

    public boolean isPayer() {
        return this._persistence_get_payer();
    }

    public boolean isReceiver() {
        return this._persistence_get_receiver();
    }

    public boolean isShowCommentsToUsers() {
        return this._persistence_get_showCommentsToUsers();
    }

    public void setAmountRange(DecimalRange decimalRange) {
        this._persistence_set_amountRange(decimalRange);
    }

    public void setBroker(boolean bl) {
        this._persistence_set_broker(bl);
    }

    public void setInternalName(String string) {
        this._persistence_set_internalName(string);
    }

    public void setLevel(Integer n) {
        this._persistence_set_level(n);
    }

    public void setPayer(boolean bl) {
        this._persistence_set_payer(bl);
    }

    public void setReceiver(boolean bl) {
        this._persistence_set_receiver(bl);
    }

    public void setRoles(Set<AuthorizationRole> set) {
        this._persistence_set_roles(set);
    }

    public void setShowCommentsToUsers(boolean bl) {
        this._persistence_set_showCommentsToUsers(bl);
    }

    public void setTransferType(PaymentTransferType paymentTransferType) {
        this._persistence_set_transferType(paymentTransferType);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_transferType_vh != null) {
            this._persistence_transferType_vh = (WeavedAttributeValueHolderInterface)this._persistence_transferType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AuthorizationLevel();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "internalName") {
            return this.internalName;
        }
        if (string == "receiver") {
            return this.receiver;
        }
        if (string == "level") {
            return this.level;
        }
        if (string == "amountRange") {
            return this.amountRange;
        }
        if (string == "roles") {
            return this.roles;
        }
        if (string == "transferType") {
            return this.transferType;
        }
        if (string == "broker") {
            return this.broker;
        }
        if (string == "payer") {
            return this.payer;
        }
        if (string == "showCommentsToUsers") {
            return this.showCommentsToUsers;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "internalName") {
            this.internalName = (String)object;
            return;
        }
        if (string == "receiver") {
            this.receiver = (Boolean)object;
            return;
        }
        if (string == "level") {
            this.level = (Integer)object;
            return;
        }
        if (string == "amountRange") {
            this.amountRange = (DecimalRange)object;
            return;
        }
        if (string == "roles") {
            this.roles = (Set)object;
            return;
        }
        if (string == "transferType") {
            this.transferType = (PaymentTransferType)object;
            return;
        }
        if (string == "broker") {
            this.broker = (Boolean)object;
            return;
        }
        if (string == "payer") {
            this.payer = (Boolean)object;
            return;
        }
        if (string == "showCommentsToUsers") {
            this.showCommentsToUsers = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_internalName() {
        this._persistence_checkFetched("internalName");
        return this.internalName;
    }

    public void _persistence_set_internalName(String string) {
        this._persistence_checkFetchedForSet("internalName");
        this._persistence_propertyChange("internalName", this.internalName, string);
        this.internalName = string;
    }

    public boolean _persistence_get_receiver() {
        this._persistence_checkFetched("receiver");
        return this.receiver;
    }

    public void _persistence_set_receiver(boolean bl) {
        this._persistence_checkFetchedForSet("receiver");
        this._persistence_propertyChange("receiver", new Boolean(this.receiver), new Boolean(bl));
        this.receiver = bl;
    }

    public Integer _persistence_get_level() {
        this._persistence_checkFetched("level");
        return this.level;
    }

    public void _persistence_set_level(Integer n) {
        this._persistence_checkFetchedForSet("level");
        this._persistence_propertyChange("level", this.level, n);
        this.level = n;
    }

    public DecimalRange _persistence_get_amountRange() {
        this._persistence_checkFetched("amountRange");
        return this.amountRange;
    }

    public void _persistence_set_amountRange(DecimalRange decimalRange) {
        this._persistence_checkFetchedForSet("amountRange");
        this._persistence_propertyChange("amountRange", this.amountRange, decimalRange);
        this.amountRange = decimalRange;
    }

    public Set _persistence_get_roles() {
        this._persistence_checkFetched("roles");
        return this.roles;
    }

    public void _persistence_set_roles(Set set) {
        this._persistence_checkFetchedForSet("roles");
        this._persistence_propertyChange("roles", this.roles, set);
        this.roles = set;
    }

    protected void _persistence_initialize_transferType_vh() {
        if (this._persistence_transferType_vh == null) {
            this._persistence_transferType_vh = new ValueHolder((Object)this.transferType);
            this._persistence_transferType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_transferType_vh() {
        PaymentTransferType paymentTransferType;
        this._persistence_initialize_transferType_vh();
        if ((this._persistence_transferType_vh.isCoordinatedWithProperty() || this._persistence_transferType_vh.isNewlyWeavedValueHolder()) && (paymentTransferType = this._persistence_get_transferType()) != this._persistence_transferType_vh.getValue()) {
            this._persistence_set_transferType(paymentTransferType);
        }
        return this._persistence_transferType_vh;
    }

    public void _persistence_set_transferType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_transferType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PaymentTransferType paymentTransferType = this._persistence_get_transferType();
            if (paymentTransferType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_transferType((PaymentTransferType)object);
            }
        } else {
            this.transferType = null;
        }
    }

    public PaymentTransferType _persistence_get_transferType() {
        this._persistence_checkFetched("transferType");
        this._persistence_initialize_transferType_vh();
        this.transferType = (PaymentTransferType)this._persistence_transferType_vh.getValue();
        return this.transferType;
    }

    public void _persistence_set_transferType(PaymentTransferType paymentTransferType) {
        this._persistence_checkFetchedForSet("transferType");
        this._persistence_initialize_transferType_vh();
        this.transferType = (PaymentTransferType)this._persistence_transferType_vh.getValue();
        this._persistence_propertyChange("transferType", this.transferType, paymentTransferType);
        this.transferType = paymentTransferType;
        this._persistence_transferType_vh.setValue((Object)paymentTransferType);
    }

    public boolean _persistence_get_broker() {
        this._persistence_checkFetched("broker");
        return this.broker;
    }

    public void _persistence_set_broker(boolean bl) {
        this._persistence_checkFetchedForSet("broker");
        this._persistence_propertyChange("broker", new Boolean(this.broker), new Boolean(bl));
        this.broker = bl;
    }

    public boolean _persistence_get_payer() {
        this._persistence_checkFetched("payer");
        return this.payer;
    }

    public void _persistence_set_payer(boolean bl) {
        this._persistence_checkFetchedForSet("payer");
        this._persistence_propertyChange("payer", new Boolean(this.payer), new Boolean(bl));
        this.payer = bl;
    }

    public boolean _persistence_get_showCommentsToUsers() {
        this._persistence_checkFetched("showCommentsToUsers");
        return this.showCommentsToUsers;
    }

    public void _persistence_set_showCommentsToUsers(boolean bl) {
        this._persistence_checkFetchedForSet("showCommentsToUsers");
        this._persistence_propertyChange("showCommentsToUsers", new Boolean(this.showCommentsToUsers), new Boolean(bl));
        this.showCommentsToUsers = bl;
    }
}

