/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.Network;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="account_types")
@DiscriminatorColumn(name="subclass")
public abstract class AccountType
extends ConfigurationEntity
implements HasCurrency,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="subclass", insertable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private AccountTypeNature nature;
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="currency_id", updatable=false, nullable=false)
    private Currency currency;
    @Basic
    @Column(name="currency_id", updatable=false, insertable=false, nullable=false)
    private Long currencyId;
    @ReadOnlyFromDTO(onInsert=false)
    @Basic
    @Column(name="maturity_freez", updatable=false)
    private Boolean maturityFreeze = false;
    @Basic
    @Column(name="show_desription_in_history_filters")
    private Boolean showDescriptionInHistoryFilters = true;
    @Basic
    @Column(name="show_desription_in_history_list")
    private Boolean showDescriptionInHistoryList = true;
    @Basic
    @Column(name="print_history_landscape")
    private Boolean printHistoryLandscape;
    @ManyToMany
    @JoinTable(name="account_types_fields_search", joinColumns={@JoinColumn(name="account_type_id")}, inverseJoinColumns={@JoinColumn(name="custom_field_id")})
    private Set<TransactionCustomField> customFieldsForSearch = new HashSet<TransactionCustomField>();
    @ManyToMany
    @JoinTable(name="account_types_fields_list", joinColumns={@JoinColumn(name="account_type_id")}, inverseJoinColumns={@JoinColumn(name="custom_field_id")})
    private Set<TransactionCustomField> customFieldsForList = new HashSet<TransactionCustomField>();
    @OneToMany(mappedBy="from", cascade={CascadeType.REMOVE})
    private Set<TransferType> fromTransferTypes = new HashSet<TransferType>();
    @OneToMany(mappedBy="to", cascade={CascadeType.REMOVE})
    private Set<TransferType> toTransferTypes = new HashSet<TransferType>();
    @OneToMany(mappedBy="accountType", cascade={CascadeType.REMOVE})
    private Set<TransferFilter> transferFilters = new HashSet<TransferFilter>();
    static final long serialVersionUID = -2764544019483619142L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_currency_vh;

    @Override
    public Currency getCurrency() {
        return this._persistence_get_currency();
    }

    public Set<TransactionCustomField> getCustomFieldsForList() {
        return this._persistence_get_customFieldsForList();
    }

    public Set<TransactionCustomField> getCustomFieldsForSearch() {
        return this._persistence_get_customFieldsForSearch();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.ACCOUNT_TYPES;
    }

    public Set<TransferType> getFromTransferTypes() {
        return this._persistence_get_fromTransferTypes();
    }

    public abstract AccountTypeLimitType getLimitType();

    public abstract AccountTypeNature getNature();

    @Override
    public Network getNetwork() {
        return this._persistence_get_currency().getNetwork();
    }

    public Set<TransferType> getToTransferTypes() {
        return this._persistence_get_toTransferTypes();
    }

    public Set<TransferFilter> getTransferFilters() {
        return this._persistence_get_transferFilters();
    }

    public boolean isMaturityFreeze() {
        return Boolean.TRUE.equals(this._persistence_get_maturityFreeze());
    }

    public boolean isPrintHistoryLandscape() {
        return Boolean.TRUE.equals(this._persistence_get_printHistoryLandscape());
    }

    public boolean isShowDescriptionInHistoryFilters() {
        return Boolean.TRUE.equals(this._persistence_get_showDescriptionInHistoryFilters());
    }

    public boolean isShowDescriptionInHistoryList() {
        return Boolean.TRUE.equals(this._persistence_get_showDescriptionInHistoryList());
    }

    public void setCurrency(Currency currency) {
        this._persistence_set_currency(currency);
    }

    public void setCustomFieldsForList(Set<TransactionCustomField> set) {
        this._persistence_set_customFieldsForList(set);
    }

    public void setCustomFieldsForSearch(Set<TransactionCustomField> set) {
        this._persistence_set_customFieldsForSearch(set);
    }

    public void setFromTransferTypes(Set<TransferType> set) {
        this._persistence_set_fromTransferTypes(set);
    }

    public void setMaturityFreeze(boolean bl) {
        this._persistence_set_maturityFreeze(bl);
    }

    public void setPrintHistoryLandscape(boolean bl) {
        this._persistence_set_printHistoryLandscape(bl);
    }

    public void setShowDescriptionInHistoryFilters(boolean bl) {
        this._persistence_set_showDescriptionInHistoryFilters(bl);
    }

    public void setShowDescriptionInHistoryList(boolean bl) {
        this._persistence_set_showDescriptionInHistoryList(bl);
    }

    public void setToTransferTypes(Set<TransferType> set) {
        this._persistence_set_toTransferTypes(set);
    }

    public void setTransferFilters(Set<TransferFilter> set) {
        this._persistence_set_transferFilters(set);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_currency_vh != null) {
            this._persistence_currency_vh = (WeavedAttributeValueHolderInterface)this._persistence_currency_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AccountType();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "showDescriptionInHistoryList") {
            return this.showDescriptionInHistoryList;
        }
        if (string == "toTransferTypes") {
            return this.toTransferTypes;
        }
        if (string == "nature") {
            return this.nature;
        }
        if (string == "customFieldsForList") {
            return this.customFieldsForList;
        }
        if (string == "transferFilters") {
            return this.transferFilters;
        }
        if (string == "maturityFreeze") {
            return this.maturityFreeze;
        }
        if (string == "printHistoryLandscape") {
            return this.printHistoryLandscape;
        }
        if (string == "showDescriptionInHistoryFilters") {
            return this.showDescriptionInHistoryFilters;
        }
        if (string == "fromTransferTypes") {
            return this.fromTransferTypes;
        }
        if (string == "customFieldsForSearch") {
            return this.customFieldsForSearch;
        }
        if (string == "currency") {
            return this.currency;
        }
        if (string == "currencyId") {
            return this.currencyId;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "showDescriptionInHistoryList") {
            this.showDescriptionInHistoryList = (Boolean)object;
            return;
        }
        if (string == "toTransferTypes") {
            this.toTransferTypes = (Set)object;
            return;
        }
        if (string == "nature") {
            this.nature = (AccountTypeNature)object;
            return;
        }
        if (string == "customFieldsForList") {
            this.customFieldsForList = (Set)object;
            return;
        }
        if (string == "transferFilters") {
            this.transferFilters = (Set)object;
            return;
        }
        if (string == "maturityFreeze") {
            this.maturityFreeze = (Boolean)object;
            return;
        }
        if (string == "printHistoryLandscape") {
            this.printHistoryLandscape = (Boolean)object;
            return;
        }
        if (string == "showDescriptionInHistoryFilters") {
            this.showDescriptionInHistoryFilters = (Boolean)object;
            return;
        }
        if (string == "fromTransferTypes") {
            this.fromTransferTypes = (Set)object;
            return;
        }
        if (string == "customFieldsForSearch") {
            this.customFieldsForSearch = (Set)object;
            return;
        }
        if (string == "currency") {
            this.currency = (Currency)object;
            return;
        }
        if (string == "currencyId") {
            this.currencyId = (Long)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Boolean _persistence_get_showDescriptionInHistoryList() {
        this._persistence_checkFetched("showDescriptionInHistoryList");
        return this.showDescriptionInHistoryList;
    }

    public void _persistence_set_showDescriptionInHistoryList(Boolean bl) {
        this._persistence_checkFetchedForSet("showDescriptionInHistoryList");
        this._persistence_propertyChange("showDescriptionInHistoryList", this.showDescriptionInHistoryList, bl);
        this.showDescriptionInHistoryList = bl;
    }

    public Set _persistence_get_toTransferTypes() {
        this._persistence_checkFetched("toTransferTypes");
        return this.toTransferTypes;
    }

    public void _persistence_set_toTransferTypes(Set set) {
        this._persistence_checkFetchedForSet("toTransferTypes");
        this._persistence_propertyChange("toTransferTypes", this.toTransferTypes, set);
        this.toTransferTypes = set;
    }

    public AccountTypeNature _persistence_get_nature() {
        this._persistence_checkFetched("nature");
        return this.nature;
    }

    public void _persistence_set_nature(AccountTypeNature accountTypeNature) {
        this._persistence_checkFetchedForSet("nature");
        this._persistence_propertyChange("nature", this.nature, accountTypeNature);
        this.nature = accountTypeNature;
    }

    public Set _persistence_get_customFieldsForList() {
        this._persistence_checkFetched("customFieldsForList");
        return this.customFieldsForList;
    }

    public void _persistence_set_customFieldsForList(Set set) {
        this._persistence_checkFetchedForSet("customFieldsForList");
        this._persistence_propertyChange("customFieldsForList", this.customFieldsForList, set);
        this.customFieldsForList = set;
    }

    public Set _persistence_get_transferFilters() {
        this._persistence_checkFetched("transferFilters");
        return this.transferFilters;
    }

    public void _persistence_set_transferFilters(Set set) {
        this._persistence_checkFetchedForSet("transferFilters");
        this._persistence_propertyChange("transferFilters", this.transferFilters, set);
        this.transferFilters = set;
    }

    public Boolean _persistence_get_maturityFreeze() {
        this._persistence_checkFetched("maturityFreeze");
        return this.maturityFreeze;
    }

    public void _persistence_set_maturityFreeze(Boolean bl) {
        this._persistence_checkFetchedForSet("maturityFreeze");
        this._persistence_propertyChange("maturityFreeze", this.maturityFreeze, bl);
        this.maturityFreeze = bl;
    }

    public Boolean _persistence_get_printHistoryLandscape() {
        this._persistence_checkFetched("printHistoryLandscape");
        return this.printHistoryLandscape;
    }

    public void _persistence_set_printHistoryLandscape(Boolean bl) {
        this._persistence_checkFetchedForSet("printHistoryLandscape");
        this._persistence_propertyChange("printHistoryLandscape", this.printHistoryLandscape, bl);
        this.printHistoryLandscape = bl;
    }

    public Boolean _persistence_get_showDescriptionInHistoryFilters() {
        this._persistence_checkFetched("showDescriptionInHistoryFilters");
        return this.showDescriptionInHistoryFilters;
    }

    public void _persistence_set_showDescriptionInHistoryFilters(Boolean bl) {
        this._persistence_checkFetchedForSet("showDescriptionInHistoryFilters");
        this._persistence_propertyChange("showDescriptionInHistoryFilters", this.showDescriptionInHistoryFilters, bl);
        this.showDescriptionInHistoryFilters = bl;
    }

    public Set _persistence_get_fromTransferTypes() {
        this._persistence_checkFetched("fromTransferTypes");
        return this.fromTransferTypes;
    }

    public void _persistence_set_fromTransferTypes(Set set) {
        this._persistence_checkFetchedForSet("fromTransferTypes");
        this._persistence_propertyChange("fromTransferTypes", this.fromTransferTypes, set);
        this.fromTransferTypes = set;
    }

    public Set _persistence_get_customFieldsForSearch() {
        this._persistence_checkFetched("customFieldsForSearch");
        return this.customFieldsForSearch;
    }

    public void _persistence_set_customFieldsForSearch(Set set) {
        this._persistence_checkFetchedForSet("customFieldsForSearch");
        this._persistence_propertyChange("customFieldsForSearch", this.customFieldsForSearch, set);
        this.customFieldsForSearch = set;
    }

    protected void _persistence_initialize_currency_vh() {
        if (this._persistence_currency_vh == null) {
            this._persistence_currency_vh = new ValueHolder((Object)this.currency);
            this._persistence_currency_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_currency_vh() {
        Currency currency;
        this._persistence_initialize_currency_vh();
        if ((this._persistence_currency_vh.isCoordinatedWithProperty() || this._persistence_currency_vh.isNewlyWeavedValueHolder()) && (currency = this._persistence_get_currency()) != this._persistence_currency_vh.getValue()) {
            this._persistence_set_currency(currency);
        }
        return this._persistence_currency_vh;
    }

    public void _persistence_set_currency_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_currency_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Currency currency = this._persistence_get_currency();
            if (currency != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_currency((Currency)object);
            }
        } else {
            this.currency = null;
        }
    }

    public Currency _persistence_get_currency() {
        this._persistence_checkFetched("currency");
        this._persistence_initialize_currency_vh();
        this.currency = (Currency)this._persistence_currency_vh.getValue();
        return this.currency;
    }

    public void _persistence_set_currency(Currency currency) {
        this._persistence_checkFetchedForSet("currency");
        this._persistence_initialize_currency_vh();
        this.currency = (Currency)this._persistence_currency_vh.getValue();
        this._persistence_propertyChange("currency", this.currency, currency);
        this.currency = currency;
        this._persistence_currency_vh.setValue((Object)currency);
    }

    public Long _persistence_get_currencyId() {
        this._persistence_checkFetched("currencyId");
        return this.currencyId;
    }

    public void _persistence_set_currencyId(Long l) {
        this._persistence_checkFetchedForSet("currencyId");
        this._persistence_propertyChange("currencyId", this.currencyId, l);
        this.currencyId = l;
    }
}

