/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.BaseOidcClient;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrencyAmount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.DelegatingMutableUserPrincipal;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.model.access.oidcclients.AuthorizationStatus;
import org.cyclos.model.access.oidcclients.ResponseMode;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="oidc_authorizations", indexes={@Index(name="ix_oidc_authorizations_code", unique=true, columnList="authorization_code"), @Index(name="ix_oidc_authorizations_locator", unique=true, columnList="locator"), @Index(name="ix_oidc_authorizations_refresh_token", unique=true, columnList="refresh_token")})
public class OidcAuthorization
extends NetworkedEntity
implements DelegatingMutableUserPrincipal,
HasCurrencyAmount,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="client_id", nullable=false)
    private BaseOidcClient client;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_date", nullable=false)
    private Date creationDate;
    @Basic
    @Column(name="locator", nullable=false, length=36)
    private String locator;
    @Basic
    @Column(name="response_type", nullable=false)
    private String responseType;
    private transient Collection<String> responseTypes;
    @Basic
    @Column(name="scope", nullable=false, length=1000)
    private String scope;
    private transient Map<Scope, Map<String, String>> scopes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_type_id")
    private UserAccountType accountType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="granted_account_type_id")
    private UserAccountType grantedAccountType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="payment_to_id")
    private User paymentTo;
    @Basic
    @CurrencyScale
    @Column(name="payment_amount")
    private BigDecimal paymentAmount;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="payment_currency_id")
    private Currency paymentCurrency;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="payment_id")
    private BasePayment payment;
    @Basic
    @Column(name="redirect_url", nullable=false, length=1000)
    private String redirectUrl;
    @Basic
    @Column(name="response_mode", length=50)
    private String responseMode;
    @Basic
    @Column(name="state", length=1000)
    private String state;
    @Basic
    @Column(name="display", length=50)
    private String display;
    @Basic
    @Column(name="nonce", length=1000)
    private String nonce;
    @Basic
    @Column(name="loginHint")
    private String loginHint;
    @Basic
    @Column(name="authorization_code", length=36)
    private String authorizationCode;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="authorization_code_expiration")
    private Date authorizationCodeExpiration;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="consent_date")
    private Date consentDate;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration_date")
    private Date expirationDate;
    @Basic
    @Column(name="consent_remote_address")
    private String consentRemoteAddress;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="token_request_date")
    private Date tokenRequestDate;
    @Basic
    @Column(name="refresh_token", length=36)
    private String refreshToken;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="basic_user_id")
    private BasicUser basicUser;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="principal_type_id")
    private PrincipalType principalType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="token_id")
    private Token token;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="phone_id")
    private MobilePhone mobilePhone;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="custom_field_value_id", nullable=true)
    private UserCustomFieldValue customFieldValue;
    @Basic
    @Column(name="oidc_only")
    private Boolean oidcOnly;
    @OneToMany(mappedBy="authorization", cascade={CascadeType.REMOVE})
    private Set<OidcAccessToken> accessTokens;
    static final long serialVersionUID = 7025487162513104665L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_grantedAccountType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_client_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_payment_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_basicUser_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_accountType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_customFieldValue_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_token_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_mobilePhone_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_paymentTo_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_paymentCurrency_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_principalType_vh;

    @Override
    public AccessClient getAccessClient() {
        return null;
    }

    @Override
    public UserAccountType getAccountType() {
        return this._persistence_get_accountType();
    }

    public BigDecimal getAmount() {
        return this.getPaymentAmount();
    }

    public String getAuthorizationCode() {
        return this._persistence_get_authorizationCode();
    }

    public Date getAuthorizationCodeExpiration() {
        return this._persistence_get_authorizationCodeExpiration();
    }

    @Override
    public BasicUser getBasicUser() {
        return this._persistence_get_basicUser();
    }

    public BaseOidcClient getClient() {
        return this._persistence_get_client();
    }

    public Date getConsentDate() {
        return this._persistence_get_consentDate();
    }

    public String getConsentRemoteAddress() {
        return this._persistence_get_consentRemoteAddress();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    @Override
    public Currency getCurrency() {
        return this.getPaymentCurrency();
    }

    @Override
    public UserCustomFieldValue getCustomFieldValue() {
        return this._persistence_get_customFieldValue();
    }

    public String getDisplay() {
        return this._persistence_get_display();
    }

    public Date getExpirationDate() {
        return this._persistence_get_expirationDate();
    }

    public UserAccountType getGrantedAccountType() {
        return this._persistence_get_grantedAccountType();
    }

    public String getLocator() {
        return this._persistence_get_locator();
    }

    public String getLoginHint() {
        return this._persistence_get_loginHint();
    }

    @Override
    public MobilePhone getMobilePhone() {
        return this._persistence_get_mobilePhone();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_client().getNetwork();
    }

    public String getNonce() {
        return this._persistence_get_nonce();
    }

    public BasePayment getPayment() {
        return this._persistence_get_payment();
    }

    public BigDecimal getPaymentAmount() {
        return this._persistence_get_paymentAmount();
    }

    public Currency getPaymentCurrency() {
        return this._persistence_get_paymentCurrency();
    }

    public User getPaymentTo() {
        return this._persistence_get_paymentTo();
    }

    @Override
    public PrincipalType getPrincipalType() {
        return this._persistence_get_principalType();
    }

    public String getRedirectUrl() {
        return this._persistence_get_redirectUrl();
    }

    public String getRefreshToken() {
        return this._persistence_get_refreshToken();
    }

    public ResponseMode getResponseMode() {
        return this._persistence_get_responseMode() == null ? null : ResponseMode.of((String)this._persistence_get_responseMode());
    }

    public String getResponseType() {
        return this._persistence_get_responseType();
    }

    public Collection<String> getResponseTypes() {
        if (this.responseTypes == null) {
            this.responseTypes = StringHelper.splitTrimming((String)this._persistence_get_responseType(), (String)" ");
        }
        return this.responseTypes;
    }

    public String getScope() {
        return this._persistence_get_scope();
    }

    public Map<String, String> getScopeParameters(Scope scope) {
        return this.getScopeMap().get(scope);
    }

    public Set<Scope> getScopes() {
        return this.getScopeMap().keySet();
    }

    public String getState() {
        return this._persistence_get_state();
    }

    public AuthorizationStatus getStatus() {
        if (this._persistence_get_consentDate() == null) {
            return AuthorizationStatus.CONSENT;
        }
        if (this._persistence_get_tokenRequestDate() == null) {
            return AuthorizationStatus.CODE;
        }
        return AuthorizationStatus.TOKEN;
    }

    @Override
    public Token getToken() {
        return this._persistence_get_token();
    }

    public Date getTokenRequestDate() {
        return this._persistence_get_tokenRequestDate();
    }

    @Override
    public TrustedDevice getTrustedDevice() {
        return null;
    }

    public boolean isAuthorizationCodeExpired() {
        return this._persistence_get_authorizationCodeExpiration() == null && this._persistence_get_authorizationCodeExpiration().after(new Date(System.currentTimeMillis() + 180000L));
    }

    public boolean isCode() {
        return this.getResponseTypes().contains("code");
    }

    public boolean isIdToken() {
        return this.getResponseTypes().contains("id_token");
    }

    public boolean isOfflineAccess() {
        return this.getScopes().contains(Scope.OFFLINE_ACCESS);
    }

    public boolean isOidcOnly() {
        return Boolean.TRUE.equals(this._persistence_get_oidcOnly());
    }

    public boolean isOpenid() {
        return this.getScopes().contains(Scope.OPENID);
    }

    public boolean isToken() {
        return this.getResponseTypes().contains("token");
    }

    @Override
    public void setAccessClient(AccessClient accessClient) {
    }

    @Override
    public void setAccountType(UserAccountType userAccountType) {
        this._persistence_set_accountType(userAccountType);
    }

    public void setAuthorizationCode(String string) {
        this._persistence_set_authorizationCode(string);
    }

    public void setAuthorizationCodeExpiration(Date date) {
        this._persistence_set_authorizationCodeExpiration(date);
    }

    @Override
    public void setBasicUser(BasicUser basicUser) {
        this._persistence_set_basicUser(basicUser);
        this._persistence_set_user(basicUser == null ? null : basicUser.getUser());
    }

    public void setClient(BaseOidcClient baseOidcClient) {
        this._persistence_set_client(baseOidcClient);
    }

    public void setConsentDate(Date date) {
        this._persistence_set_consentDate(date);
    }

    public void setConsentRemoteAddress(String string) {
        this._persistence_set_consentRemoteAddress(string);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    @Override
    public void setCustomFieldValue(UserCustomFieldValue userCustomFieldValue) {
        this._persistence_set_customFieldValue(userCustomFieldValue);
    }

    public void setDisplay(String string) {
        this._persistence_set_display(string);
    }

    public void setExpirationDate(Date date) {
        this._persistence_set_expirationDate(date);
    }

    public void setGrantedAccountType(UserAccountType userAccountType) {
        this._persistence_set_grantedAccountType(userAccountType);
    }

    public void setLocator(String string) {
        this._persistence_set_locator(string);
    }

    public void setLoginHint(String string) {
        this._persistence_set_loginHint(string);
    }

    @Override
    public void setMobilePhone(MobilePhone mobilePhone) {
        this._persistence_set_mobilePhone(mobilePhone);
    }

    public void setNonce(String string) {
        this._persistence_set_nonce(string);
    }

    public void setOidcOnly(boolean bl) {
        this._persistence_set_oidcOnly(bl);
    }

    public void setPayment(BasePayment basePayment) {
        this._persistence_set_payment(basePayment);
    }

    public void setPaymentAmount(BigDecimal bigDecimal) {
        this._persistence_set_paymentAmount(bigDecimal);
    }

    public void setPaymentCurrency(Currency currency) {
        this._persistence_set_paymentCurrency(currency);
    }

    public void setPaymentTo(User user) {
        this._persistence_set_paymentTo(user);
    }

    @Override
    public void setPrincipalType(PrincipalType principalType) {
        this._persistence_set_principalType(principalType);
    }

    public void setRedirectUrl(String string) {
        this._persistence_set_redirectUrl(string);
    }

    public void setRefreshToken(String string) {
        this._persistence_set_refreshToken(string);
    }

    public void setResponseMode(ResponseMode responseMode) {
        this._persistence_set_responseMode(responseMode == null ? null : responseMode.toString());
    }

    public void setResponseType(String string) {
        this._persistence_set_responseType(string);
    }

    public void setScope(String string) {
        this._persistence_set_scope(string);
        this.scopes = null;
    }

    public void setState(String string) {
        this._persistence_set_state(string);
    }

    @Override
    public void setToken(Token token) {
        this._persistence_set_token(token);
    }

    public void setTokenRequestDate(Date date) {
        this._persistence_set_tokenRequestDate(date);
    }

    @Override
    public void setTrustedDevice(TrustedDevice trustedDevice) {
    }

    private Map<Scope, Map<String, String>> getScopeMap() {
        if (this.scopes == null) {
            this.scopes = Scope.parse((String)this._persistence_get_scope());
        }
        return this.scopes;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_grantedAccountType_vh != null) {
            this._persistence_grantedAccountType_vh = (WeavedAttributeValueHolderInterface)this._persistence_grantedAccountType_vh.clone();
        }
        if (this._persistence_client_vh != null) {
            this._persistence_client_vh = (WeavedAttributeValueHolderInterface)this._persistence_client_vh.clone();
        }
        if (this._persistence_payment_vh != null) {
            this._persistence_payment_vh = (WeavedAttributeValueHolderInterface)this._persistence_payment_vh.clone();
        }
        if (this._persistence_basicUser_vh != null) {
            this._persistence_basicUser_vh = (WeavedAttributeValueHolderInterface)this._persistence_basicUser_vh.clone();
        }
        if (this._persistence_accountType_vh != null) {
            this._persistence_accountType_vh = (WeavedAttributeValueHolderInterface)this._persistence_accountType_vh.clone();
        }
        if (this._persistence_customFieldValue_vh != null) {
            this._persistence_customFieldValue_vh = (WeavedAttributeValueHolderInterface)this._persistence_customFieldValue_vh.clone();
        }
        if (this._persistence_token_vh != null) {
            this._persistence_token_vh = (WeavedAttributeValueHolderInterface)this._persistence_token_vh.clone();
        }
        if (this._persistence_mobilePhone_vh != null) {
            this._persistence_mobilePhone_vh = (WeavedAttributeValueHolderInterface)this._persistence_mobilePhone_vh.clone();
        }
        if (this._persistence_paymentTo_vh != null) {
            this._persistence_paymentTo_vh = (WeavedAttributeValueHolderInterface)this._persistence_paymentTo_vh.clone();
        }
        if (this._persistence_paymentCurrency_vh != null) {
            this._persistence_paymentCurrency_vh = (WeavedAttributeValueHolderInterface)this._persistence_paymentCurrency_vh.clone();
        }
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        if (this._persistence_principalType_vh != null) {
            this._persistence_principalType_vh = (WeavedAttributeValueHolderInterface)this._persistence_principalType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new OidcAuthorization();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "tokenRequestDate") {
            return this.tokenRequestDate;
        }
        if (string == "responseMode") {
            return this.responseMode;
        }
        if (string == "redirectUrl") {
            return this.redirectUrl;
        }
        if (string == "authorizationCode") {
            return this.authorizationCode;
        }
        if (string == "paymentAmount") {
            return this.paymentAmount;
        }
        if (string == "consentDate") {
            return this.consentDate;
        }
        if (string == "grantedAccountType") {
            return this.grantedAccountType;
        }
        if (string == "loginHint") {
            return this.loginHint;
        }
        if (string == "responseType") {
            return this.responseType;
        }
        if (string == "scope") {
            return this.scope;
        }
        if (string == "client") {
            return this.client;
        }
        if (string == "payment") {
            return this.payment;
        }
        if (string == "state") {
            return this.state;
        }
        if (string == "expirationDate") {
            return this.expirationDate;
        }
        if (string == "basicUser") {
            return this.basicUser;
        }
        if (string == "consentRemoteAddress") {
            return this.consentRemoteAddress;
        }
        if (string == "display") {
            return this.display;
        }
        if (string == "accountType") {
            return this.accountType;
        }
        if (string == "oidcOnly") {
            return this.oidcOnly;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "customFieldValue") {
            return this.customFieldValue;
        }
        if (string == "nonce") {
            return this.nonce;
        }
        if (string == "authorizationCodeExpiration") {
            return this.authorizationCodeExpiration;
        }
        if (string == "token") {
            return this.token;
        }
        if (string == "mobilePhone") {
            return this.mobilePhone;
        }
        if (string == "paymentTo") {
            return this.paymentTo;
        }
        if (string == "paymentCurrency") {
            return this.paymentCurrency;
        }
        if (string == "locator") {
            return this.locator;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "principalType") {
            return this.principalType;
        }
        if (string == "accessTokens") {
            return this.accessTokens;
        }
        if (string == "refreshToken") {
            return this.refreshToken;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "tokenRequestDate") {
            this.tokenRequestDate = (Date)object;
            return;
        }
        if (string == "responseMode") {
            this.responseMode = (String)object;
            return;
        }
        if (string == "redirectUrl") {
            this.redirectUrl = (String)object;
            return;
        }
        if (string == "authorizationCode") {
            this.authorizationCode = (String)object;
            return;
        }
        if (string == "paymentAmount") {
            this.paymentAmount = (BigDecimal)object;
            return;
        }
        if (string == "consentDate") {
            this.consentDate = (Date)object;
            return;
        }
        if (string == "grantedAccountType") {
            this.grantedAccountType = (UserAccountType)object;
            return;
        }
        if (string == "loginHint") {
            this.loginHint = (String)object;
            return;
        }
        if (string == "responseType") {
            this.responseType = (String)object;
            return;
        }
        if (string == "scope") {
            this.scope = (String)object;
            return;
        }
        if (string == "client") {
            this.client = (BaseOidcClient)object;
            return;
        }
        if (string == "payment") {
            this.payment = (BasePayment)object;
            return;
        }
        if (string == "state") {
            this.state = (String)object;
            return;
        }
        if (string == "expirationDate") {
            this.expirationDate = (Date)object;
            return;
        }
        if (string == "basicUser") {
            this.basicUser = (BasicUser)object;
            return;
        }
        if (string == "consentRemoteAddress") {
            this.consentRemoteAddress = (String)object;
            return;
        }
        if (string == "display") {
            this.display = (String)object;
            return;
        }
        if (string == "accountType") {
            this.accountType = (UserAccountType)object;
            return;
        }
        if (string == "oidcOnly") {
            this.oidcOnly = (Boolean)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "customFieldValue") {
            this.customFieldValue = (UserCustomFieldValue)object;
            return;
        }
        if (string == "nonce") {
            this.nonce = (String)object;
            return;
        }
        if (string == "authorizationCodeExpiration") {
            this.authorizationCodeExpiration = (Date)object;
            return;
        }
        if (string == "token") {
            this.token = (Token)object;
            return;
        }
        if (string == "mobilePhone") {
            this.mobilePhone = (MobilePhone)object;
            return;
        }
        if (string == "paymentTo") {
            this.paymentTo = (User)object;
            return;
        }
        if (string == "paymentCurrency") {
            this.paymentCurrency = (Currency)object;
            return;
        }
        if (string == "locator") {
            this.locator = (String)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        if (string == "principalType") {
            this.principalType = (PrincipalType)object;
            return;
        }
        if (string == "accessTokens") {
            this.accessTokens = (Set)object;
            return;
        }
        if (string == "refreshToken") {
            this.refreshToken = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_tokenRequestDate() {
        this._persistence_checkFetched("tokenRequestDate");
        return this.tokenRequestDate;
    }

    public void _persistence_set_tokenRequestDate(Date date) {
        this._persistence_checkFetchedForSet("tokenRequestDate");
        this._persistence_propertyChange("tokenRequestDate", this.tokenRequestDate, date);
        this.tokenRequestDate = date;
    }

    public String _persistence_get_responseMode() {
        this._persistence_checkFetched("responseMode");
        return this.responseMode;
    }

    public void _persistence_set_responseMode(String string) {
        this._persistence_checkFetchedForSet("responseMode");
        this._persistence_propertyChange("responseMode", this.responseMode, string);
        this.responseMode = string;
    }

    public String _persistence_get_redirectUrl() {
        this._persistence_checkFetched("redirectUrl");
        return this.redirectUrl;
    }

    public void _persistence_set_redirectUrl(String string) {
        this._persistence_checkFetchedForSet("redirectUrl");
        this._persistence_propertyChange("redirectUrl", this.redirectUrl, string);
        this.redirectUrl = string;
    }

    public String _persistence_get_authorizationCode() {
        this._persistence_checkFetched("authorizationCode");
        return this.authorizationCode;
    }

    public void _persistence_set_authorizationCode(String string) {
        this._persistence_checkFetchedForSet("authorizationCode");
        this._persistence_propertyChange("authorizationCode", this.authorizationCode, string);
        this.authorizationCode = string;
    }

    public BigDecimal _persistence_get_paymentAmount() {
        this._persistence_checkFetched("paymentAmount");
        return this.paymentAmount;
    }

    public void _persistence_set_paymentAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("paymentAmount");
        this._persistence_propertyChange("paymentAmount", this.paymentAmount, bigDecimal);
        this.paymentAmount = bigDecimal;
    }

    public Date _persistence_get_consentDate() {
        this._persistence_checkFetched("consentDate");
        return this.consentDate;
    }

    public void _persistence_set_consentDate(Date date) {
        this._persistence_checkFetchedForSet("consentDate");
        this._persistence_propertyChange("consentDate", this.consentDate, date);
        this.consentDate = date;
    }

    protected void _persistence_initialize_grantedAccountType_vh() {
        if (this._persistence_grantedAccountType_vh == null) {
            this._persistence_grantedAccountType_vh = new ValueHolder((Object)this.grantedAccountType);
            this._persistence_grantedAccountType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_grantedAccountType_vh() {
        UserAccountType userAccountType;
        this._persistence_initialize_grantedAccountType_vh();
        if ((this._persistence_grantedAccountType_vh.isCoordinatedWithProperty() || this._persistence_grantedAccountType_vh.isNewlyWeavedValueHolder()) && (userAccountType = this._persistence_get_grantedAccountType()) != this._persistence_grantedAccountType_vh.getValue()) {
            this._persistence_set_grantedAccountType(userAccountType);
        }
        return this._persistence_grantedAccountType_vh;
    }

    public void _persistence_set_grantedAccountType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_grantedAccountType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserAccountType userAccountType = this._persistence_get_grantedAccountType();
            if (userAccountType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_grantedAccountType((UserAccountType)object);
            }
        } else {
            this.grantedAccountType = null;
        }
    }

    public UserAccountType _persistence_get_grantedAccountType() {
        this._persistence_checkFetched("grantedAccountType");
        this._persistence_initialize_grantedAccountType_vh();
        this.grantedAccountType = (UserAccountType)this._persistence_grantedAccountType_vh.getValue();
        return this.grantedAccountType;
    }

    public void _persistence_set_grantedAccountType(UserAccountType userAccountType) {
        this._persistence_checkFetchedForSet("grantedAccountType");
        this._persistence_initialize_grantedAccountType_vh();
        this.grantedAccountType = (UserAccountType)this._persistence_grantedAccountType_vh.getValue();
        this._persistence_propertyChange("grantedAccountType", this.grantedAccountType, userAccountType);
        this.grantedAccountType = userAccountType;
        this._persistence_grantedAccountType_vh.setValue((Object)userAccountType);
    }

    public String _persistence_get_loginHint() {
        this._persistence_checkFetched("loginHint");
        return this.loginHint;
    }

    public void _persistence_set_loginHint(String string) {
        this._persistence_checkFetchedForSet("loginHint");
        this._persistence_propertyChange("loginHint", this.loginHint, string);
        this.loginHint = string;
    }

    public String _persistence_get_responseType() {
        this._persistence_checkFetched("responseType");
        return this.responseType;
    }

    public void _persistence_set_responseType(String string) {
        this._persistence_checkFetchedForSet("responseType");
        this._persistence_propertyChange("responseType", this.responseType, string);
        this.responseType = string;
    }

    public String _persistence_get_scope() {
        this._persistence_checkFetched("scope");
        return this.scope;
    }

    public void _persistence_set_scope(String string) {
        this._persistence_checkFetchedForSet("scope");
        this._persistence_propertyChange("scope", this.scope, string);
        this.scope = string;
    }

    protected void _persistence_initialize_client_vh() {
        if (this._persistence_client_vh == null) {
            this._persistence_client_vh = new ValueHolder((Object)this.client);
            this._persistence_client_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_client_vh() {
        BaseOidcClient baseOidcClient;
        this._persistence_initialize_client_vh();
        if ((this._persistence_client_vh.isCoordinatedWithProperty() || this._persistence_client_vh.isNewlyWeavedValueHolder()) && (baseOidcClient = this._persistence_get_client()) != this._persistence_client_vh.getValue()) {
            this._persistence_set_client(baseOidcClient);
        }
        return this._persistence_client_vh;
    }

    public void _persistence_set_client_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_client_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BaseOidcClient baseOidcClient = this._persistence_get_client();
            if (baseOidcClient != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_client((BaseOidcClient)object);
            }
        } else {
            this.client = null;
        }
    }

    public BaseOidcClient _persistence_get_client() {
        this._persistence_checkFetched("client");
        this._persistence_initialize_client_vh();
        this.client = (BaseOidcClient)this._persistence_client_vh.getValue();
        return this.client;
    }

    public void _persistence_set_client(BaseOidcClient baseOidcClient) {
        this._persistence_checkFetchedForSet("client");
        this._persistence_initialize_client_vh();
        this.client = (BaseOidcClient)this._persistence_client_vh.getValue();
        this._persistence_propertyChange("client", this.client, baseOidcClient);
        this.client = baseOidcClient;
        this._persistence_client_vh.setValue((Object)baseOidcClient);
    }

    protected void _persistence_initialize_payment_vh() {
        if (this._persistence_payment_vh == null) {
            this._persistence_payment_vh = new ValueHolder((Object)this.payment);
            this._persistence_payment_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_payment_vh() {
        BasePayment basePayment;
        this._persistence_initialize_payment_vh();
        if ((this._persistence_payment_vh.isCoordinatedWithProperty() || this._persistence_payment_vh.isNewlyWeavedValueHolder()) && (basePayment = this._persistence_get_payment()) != this._persistence_payment_vh.getValue()) {
            this._persistence_set_payment(basePayment);
        }
        return this._persistence_payment_vh;
    }

    public void _persistence_set_payment_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_payment_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasePayment basePayment = this._persistence_get_payment();
            if (basePayment != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_payment((BasePayment)object);
            }
        } else {
            this.payment = null;
        }
    }

    public BasePayment _persistence_get_payment() {
        this._persistence_checkFetched("payment");
        this._persistence_initialize_payment_vh();
        this.payment = (BasePayment)this._persistence_payment_vh.getValue();
        return this.payment;
    }

    public void _persistence_set_payment(BasePayment basePayment) {
        this._persistence_checkFetchedForSet("payment");
        this._persistence_initialize_payment_vh();
        this.payment = (BasePayment)this._persistence_payment_vh.getValue();
        this._persistence_propertyChange("payment", this.payment, basePayment);
        this.payment = basePayment;
        this._persistence_payment_vh.setValue((Object)basePayment);
    }

    public String _persistence_get_state() {
        this._persistence_checkFetched("state");
        return this.state;
    }

    public void _persistence_set_state(String string) {
        this._persistence_checkFetchedForSet("state");
        this._persistence_propertyChange("state", this.state, string);
        this.state = string;
    }

    public Date _persistence_get_expirationDate() {
        this._persistence_checkFetched("expirationDate");
        return this.expirationDate;
    }

    public void _persistence_set_expirationDate(Date date) {
        this._persistence_checkFetchedForSet("expirationDate");
        this._persistence_propertyChange("expirationDate", this.expirationDate, date);
        this.expirationDate = date;
    }

    protected void _persistence_initialize_basicUser_vh() {
        if (this._persistence_basicUser_vh == null) {
            this._persistence_basicUser_vh = new ValueHolder((Object)this.basicUser);
            this._persistence_basicUser_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_basicUser_vh() {
        BasicUser basicUser;
        this._persistence_initialize_basicUser_vh();
        if ((this._persistence_basicUser_vh.isCoordinatedWithProperty() || this._persistence_basicUser_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_basicUser()) != this._persistence_basicUser_vh.getValue()) {
            this._persistence_set_basicUser(basicUser);
        }
        return this._persistence_basicUser_vh;
    }

    public void _persistence_set_basicUser_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_basicUser_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_basicUser();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_basicUser((BasicUser)object);
            }
        } else {
            this.basicUser = null;
        }
    }

    public BasicUser _persistence_get_basicUser() {
        this._persistence_checkFetched("basicUser");
        this._persistence_initialize_basicUser_vh();
        this.basicUser = (BasicUser)this._persistence_basicUser_vh.getValue();
        return this.basicUser;
    }

    public void _persistence_set_basicUser(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("basicUser");
        this._persistence_initialize_basicUser_vh();
        this.basicUser = (BasicUser)this._persistence_basicUser_vh.getValue();
        this._persistence_propertyChange("basicUser", this.basicUser, basicUser);
        this.basicUser = basicUser;
        this._persistence_basicUser_vh.setValue((Object)basicUser);
    }

    public String _persistence_get_consentRemoteAddress() {
        this._persistence_checkFetched("consentRemoteAddress");
        return this.consentRemoteAddress;
    }

    public void _persistence_set_consentRemoteAddress(String string) {
        this._persistence_checkFetchedForSet("consentRemoteAddress");
        this._persistence_propertyChange("consentRemoteAddress", this.consentRemoteAddress, string);
        this.consentRemoteAddress = string;
    }

    public String _persistence_get_display() {
        this._persistence_checkFetched("display");
        return this.display;
    }

    public void _persistence_set_display(String string) {
        this._persistence_checkFetchedForSet("display");
        this._persistence_propertyChange("display", this.display, string);
        this.display = string;
    }

    protected void _persistence_initialize_accountType_vh() {
        if (this._persistence_accountType_vh == null) {
            this._persistence_accountType_vh = new ValueHolder((Object)this.accountType);
            this._persistence_accountType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_accountType_vh() {
        UserAccountType userAccountType;
        this._persistence_initialize_accountType_vh();
        if ((this._persistence_accountType_vh.isCoordinatedWithProperty() || this._persistence_accountType_vh.isNewlyWeavedValueHolder()) && (userAccountType = this._persistence_get_accountType()) != this._persistence_accountType_vh.getValue()) {
            this._persistence_set_accountType(userAccountType);
        }
        return this._persistence_accountType_vh;
    }

    public void _persistence_set_accountType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_accountType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserAccountType userAccountType = this._persistence_get_accountType();
            if (userAccountType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_accountType((UserAccountType)object);
            }
        } else {
            this.accountType = null;
        }
    }

    public UserAccountType _persistence_get_accountType() {
        this._persistence_checkFetched("accountType");
        this._persistence_initialize_accountType_vh();
        this.accountType = (UserAccountType)this._persistence_accountType_vh.getValue();
        return this.accountType;
    }

    public void _persistence_set_accountType(UserAccountType userAccountType) {
        this._persistence_checkFetchedForSet("accountType");
        this._persistence_initialize_accountType_vh();
        this.accountType = (UserAccountType)this._persistence_accountType_vh.getValue();
        this._persistence_propertyChange("accountType", this.accountType, userAccountType);
        this.accountType = userAccountType;
        this._persistence_accountType_vh.setValue((Object)userAccountType);
    }

    public Boolean _persistence_get_oidcOnly() {
        this._persistence_checkFetched("oidcOnly");
        return this.oidcOnly;
    }

    public void _persistence_set_oidcOnly(Boolean bl) {
        this._persistence_checkFetchedForSet("oidcOnly");
        this._persistence_propertyChange("oidcOnly", this.oidcOnly, bl);
        this.oidcOnly = bl;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    protected void _persistence_initialize_customFieldValue_vh() {
        if (this._persistence_customFieldValue_vh == null) {
            this._persistence_customFieldValue_vh = new ValueHolder((Object)this.customFieldValue);
            this._persistence_customFieldValue_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_customFieldValue_vh() {
        UserCustomFieldValue userCustomFieldValue;
        this._persistence_initialize_customFieldValue_vh();
        if ((this._persistence_customFieldValue_vh.isCoordinatedWithProperty() || this._persistence_customFieldValue_vh.isNewlyWeavedValueHolder()) && (userCustomFieldValue = this._persistence_get_customFieldValue()) != this._persistence_customFieldValue_vh.getValue()) {
            this._persistence_set_customFieldValue(userCustomFieldValue);
        }
        return this._persistence_customFieldValue_vh;
    }

    public void _persistence_set_customFieldValue_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_customFieldValue_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserCustomFieldValue userCustomFieldValue = this._persistence_get_customFieldValue();
            if (userCustomFieldValue != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_customFieldValue((UserCustomFieldValue)object);
            }
        } else {
            this.customFieldValue = null;
        }
    }

    public UserCustomFieldValue _persistence_get_customFieldValue() {
        this._persistence_checkFetched("customFieldValue");
        this._persistence_initialize_customFieldValue_vh();
        this.customFieldValue = (UserCustomFieldValue)this._persistence_customFieldValue_vh.getValue();
        return this.customFieldValue;
    }

    public void _persistence_set_customFieldValue(UserCustomFieldValue userCustomFieldValue) {
        this._persistence_checkFetchedForSet("customFieldValue");
        this._persistence_initialize_customFieldValue_vh();
        this.customFieldValue = (UserCustomFieldValue)this._persistence_customFieldValue_vh.getValue();
        this._persistence_propertyChange("customFieldValue", this.customFieldValue, userCustomFieldValue);
        this.customFieldValue = userCustomFieldValue;
        this._persistence_customFieldValue_vh.setValue((Object)userCustomFieldValue);
    }

    public String _persistence_get_nonce() {
        this._persistence_checkFetched("nonce");
        return this.nonce;
    }

    public void _persistence_set_nonce(String string) {
        this._persistence_checkFetchedForSet("nonce");
        this._persistence_propertyChange("nonce", this.nonce, string);
        this.nonce = string;
    }

    public Date _persistence_get_authorizationCodeExpiration() {
        this._persistence_checkFetched("authorizationCodeExpiration");
        return this.authorizationCodeExpiration;
    }

    public void _persistence_set_authorizationCodeExpiration(Date date) {
        this._persistence_checkFetchedForSet("authorizationCodeExpiration");
        this._persistence_propertyChange("authorizationCodeExpiration", this.authorizationCodeExpiration, date);
        this.authorizationCodeExpiration = date;
    }

    protected void _persistence_initialize_token_vh() {
        if (this._persistence_token_vh == null) {
            this._persistence_token_vh = new ValueHolder((Object)this.token);
            this._persistence_token_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_token_vh() {
        Token token;
        this._persistence_initialize_token_vh();
        if ((this._persistence_token_vh.isCoordinatedWithProperty() || this._persistence_token_vh.isNewlyWeavedValueHolder()) && (token = this._persistence_get_token()) != this._persistence_token_vh.getValue()) {
            this._persistence_set_token(token);
        }
        return this._persistence_token_vh;
    }

    public void _persistence_set_token_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_token_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Token token = this._persistence_get_token();
            if (token != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_token((Token)object);
            }
        } else {
            this.token = null;
        }
    }

    public Token _persistence_get_token() {
        this._persistence_checkFetched("token");
        this._persistence_initialize_token_vh();
        this.token = (Token)this._persistence_token_vh.getValue();
        return this.token;
    }

    public void _persistence_set_token(Token token) {
        this._persistence_checkFetchedForSet("token");
        this._persistence_initialize_token_vh();
        this.token = (Token)this._persistence_token_vh.getValue();
        this._persistence_propertyChange("token", this.token, token);
        this.token = token;
        this._persistence_token_vh.setValue((Object)token);
    }

    protected void _persistence_initialize_mobilePhone_vh() {
        if (this._persistence_mobilePhone_vh == null) {
            this._persistence_mobilePhone_vh = new ValueHolder((Object)this.mobilePhone);
            this._persistence_mobilePhone_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_mobilePhone_vh() {
        MobilePhone mobilePhone;
        this._persistence_initialize_mobilePhone_vh();
        if ((this._persistence_mobilePhone_vh.isCoordinatedWithProperty() || this._persistence_mobilePhone_vh.isNewlyWeavedValueHolder()) && (mobilePhone = this._persistence_get_mobilePhone()) != this._persistence_mobilePhone_vh.getValue()) {
            this._persistence_set_mobilePhone(mobilePhone);
        }
        return this._persistence_mobilePhone_vh;
    }

    public void _persistence_set_mobilePhone_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_mobilePhone_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            MobilePhone mobilePhone = this._persistence_get_mobilePhone();
            if (mobilePhone != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_mobilePhone((MobilePhone)object);
            }
        } else {
            this.mobilePhone = null;
        }
    }

    public MobilePhone _persistence_get_mobilePhone() {
        this._persistence_checkFetched("mobilePhone");
        this._persistence_initialize_mobilePhone_vh();
        this.mobilePhone = (MobilePhone)this._persistence_mobilePhone_vh.getValue();
        return this.mobilePhone;
    }

    public void _persistence_set_mobilePhone(MobilePhone mobilePhone) {
        this._persistence_checkFetchedForSet("mobilePhone");
        this._persistence_initialize_mobilePhone_vh();
        this.mobilePhone = (MobilePhone)this._persistence_mobilePhone_vh.getValue();
        this._persistence_propertyChange("mobilePhone", this.mobilePhone, mobilePhone);
        this.mobilePhone = mobilePhone;
        this._persistence_mobilePhone_vh.setValue((Object)mobilePhone);
    }

    protected void _persistence_initialize_paymentTo_vh() {
        if (this._persistence_paymentTo_vh == null) {
            this._persistence_paymentTo_vh = new ValueHolder((Object)this.paymentTo);
            this._persistence_paymentTo_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_paymentTo_vh() {
        User user;
        this._persistence_initialize_paymentTo_vh();
        if ((this._persistence_paymentTo_vh.isCoordinatedWithProperty() || this._persistence_paymentTo_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_paymentTo()) != this._persistence_paymentTo_vh.getValue()) {
            this._persistence_set_paymentTo(user);
        }
        return this._persistence_paymentTo_vh;
    }

    public void _persistence_set_paymentTo_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_paymentTo_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_paymentTo();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_paymentTo((User)object);
            }
        } else {
            this.paymentTo = null;
        }
    }

    public User _persistence_get_paymentTo() {
        this._persistence_checkFetched("paymentTo");
        this._persistence_initialize_paymentTo_vh();
        this.paymentTo = (User)this._persistence_paymentTo_vh.getValue();
        return this.paymentTo;
    }

    public void _persistence_set_paymentTo(User user) {
        this._persistence_checkFetchedForSet("paymentTo");
        this._persistence_initialize_paymentTo_vh();
        this.paymentTo = (User)this._persistence_paymentTo_vh.getValue();
        this._persistence_propertyChange("paymentTo", this.paymentTo, user);
        this.paymentTo = user;
        this._persistence_paymentTo_vh.setValue((Object)user);
    }

    protected void _persistence_initialize_paymentCurrency_vh() {
        if (this._persistence_paymentCurrency_vh == null) {
            this._persistence_paymentCurrency_vh = new ValueHolder((Object)this.paymentCurrency);
            this._persistence_paymentCurrency_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_paymentCurrency_vh() {
        Currency currency;
        this._persistence_initialize_paymentCurrency_vh();
        if ((this._persistence_paymentCurrency_vh.isCoordinatedWithProperty() || this._persistence_paymentCurrency_vh.isNewlyWeavedValueHolder()) && (currency = this._persistence_get_paymentCurrency()) != this._persistence_paymentCurrency_vh.getValue()) {
            this._persistence_set_paymentCurrency(currency);
        }
        return this._persistence_paymentCurrency_vh;
    }

    public void _persistence_set_paymentCurrency_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_paymentCurrency_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Currency currency = this._persistence_get_paymentCurrency();
            if (currency != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_paymentCurrency((Currency)object);
            }
        } else {
            this.paymentCurrency = null;
        }
    }

    public Currency _persistence_get_paymentCurrency() {
        this._persistence_checkFetched("paymentCurrency");
        this._persistence_initialize_paymentCurrency_vh();
        this.paymentCurrency = (Currency)this._persistence_paymentCurrency_vh.getValue();
        return this.paymentCurrency;
    }

    public void _persistence_set_paymentCurrency(Currency currency) {
        this._persistence_checkFetchedForSet("paymentCurrency");
        this._persistence_initialize_paymentCurrency_vh();
        this.paymentCurrency = (Currency)this._persistence_paymentCurrency_vh.getValue();
        this._persistence_propertyChange("paymentCurrency", this.paymentCurrency, currency);
        this.paymentCurrency = currency;
        this._persistence_paymentCurrency_vh.setValue((Object)currency);
    }

    public String _persistence_get_locator() {
        this._persistence_checkFetched("locator");
        return this.locator;
    }

    public void _persistence_set_locator(String string) {
        this._persistence_checkFetchedForSet("locator");
        this._persistence_propertyChange("locator", this.locator, string);
        this.locator = string;
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        User user;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(user);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_user();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((User)object);
            }
        } else {
            this.user = null;
        }
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
        this._persistence_user_vh.setValue((Object)user);
    }

    protected void _persistence_initialize_principalType_vh() {
        if (this._persistence_principalType_vh == null) {
            this._persistence_principalType_vh = new ValueHolder((Object)this.principalType);
            this._persistence_principalType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_principalType_vh() {
        PrincipalType principalType;
        this._persistence_initialize_principalType_vh();
        if ((this._persistence_principalType_vh.isCoordinatedWithProperty() || this._persistence_principalType_vh.isNewlyWeavedValueHolder()) && (principalType = this._persistence_get_principalType()) != this._persistence_principalType_vh.getValue()) {
            this._persistence_set_principalType(principalType);
        }
        return this._persistence_principalType_vh;
    }

    public void _persistence_set_principalType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_principalType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PrincipalType principalType = this._persistence_get_principalType();
            if (principalType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_principalType((PrincipalType)object);
            }
        } else {
            this.principalType = null;
        }
    }

    public PrincipalType _persistence_get_principalType() {
        this._persistence_checkFetched("principalType");
        this._persistence_initialize_principalType_vh();
        this.principalType = (PrincipalType)this._persistence_principalType_vh.getValue();
        return this.principalType;
    }

    public void _persistence_set_principalType(PrincipalType principalType) {
        this._persistence_checkFetchedForSet("principalType");
        this._persistence_initialize_principalType_vh();
        this.principalType = (PrincipalType)this._persistence_principalType_vh.getValue();
        this._persistence_propertyChange("principalType", this.principalType, principalType);
        this.principalType = principalType;
        this._persistence_principalType_vh.setValue((Object)principalType);
    }

    public Set _persistence_get_accessTokens() {
        this._persistence_checkFetched("accessTokens");
        return this.accessTokens;
    }

    public void _persistence_set_accessTokens(Set set) {
        this._persistence_checkFetchedForSet("accessTokens");
        this._persistence_propertyChange("accessTokens", this.accessTokens, set);
        this.accessTokens = set;
    }

    public String _persistence_get_refreshToken() {
        this._persistence_checkFetched("refreshToken");
        return this.refreshToken;
    }

    public void _persistence_set_refreshToken(String string) {
        this._persistence_checkFetchedForSet("refreshToken");
        this._persistence_propertyChange("refreshToken", this.refreshToken, string);
        this.refreshToken = string;
    }
}

