/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.ConfigurationOrderableEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.UserIdentityProvider;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.DefinesNetwork;
import org.cyclos.entities.system.ImageOwner;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.TempImage;
import org.cyclos.entities.users.IdentityProviderImage;
import org.cyclos.model.access.identityproviders.IdentityProviderProtocol;
import org.cyclos.model.access.identityproviders.IdentityProviderType;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Cacheable(value=true)
@Table(name="identity_providers", indexes={@Index(name="ix_identity_providers_internal_name", columnList="internal_name")})
@DiscriminatorColumn(name="subclass")
public abstract class IdentityProvider
extends ConfigurationOrderableEntity
implements DefinesNetwork,
ImageOwner<IdentityProvider, IdentityProviderImage>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Enumerated(value=EnumType.STRING)
    @ReadOnlyFromDTO(onInsert=false)
    @Column(name="type")
    private IdentityProviderType type;
    @Basic
    @Column(name="enabled")
    private Boolean enabled;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="network_id")
    private Network network;
    @Basic
    @Column(name="background_color")
    private String backgroundColor;
    @Basic
    @Column(name="border_color")
    private String borderColor;
    @Basic
    @Column(name="text_color")
    private String textColor;
    @Transient
    private TempImage uploadedImage;
    @OneToMany(mappedBy="identityProvider")
    private Set<IdentityProviderImage> images;
    @ManyToMany(mappedBy="identityProviders")
    private Set<ChannelConfiguration> channelConfigurations;
    @OneToMany(mappedBy="identityProvider", cascade={CascadeType.REMOVE})
    private Set<UserIdentityProvider> users;
    static final long serialVersionUID = 4373240814795569108L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_network_vh;

    public String getBackgroundColor() {
        return this._persistence_get_backgroundColor();
    }

    public String getBorderColor() {
        return this._persistence_get_borderColor();
    }

    @Override
    public DataTranslationType getDataTranslationType() {
        return DataTranslationType.IDENTITY_PROVIDER;
    }

    @Override
    public IdentityProviderImage getImage() {
        return (IdentityProviderImage)CollectionHelper.first((Iterable)this._persistence_get_images());
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_network();
    }

    public abstract IdentityProviderProtocol getProtocol();

    public String getTextColor() {
        return this._persistence_get_textColor();
    }

    public IdentityProviderType getType() {
        return this._persistence_get_type();
    }

    public TempImage getUploadedImage() {
        return this.uploadedImage;
    }

    public boolean isEnabled() {
        return Boolean.TRUE.equals(this._persistence_get_enabled());
    }

    public void setBackgroundColor(String string) {
        this._persistence_set_backgroundColor(string);
    }

    public void setBorderColor(String string) {
        this._persistence_set_borderColor(string);
    }

    public void setEnabled(boolean bl) {
        this._persistence_set_enabled(bl);
    }

    @Override
    public void setImage(IdentityProviderImage identityProviderImage) {
        this._persistence_set_images(CollectionHelper.asSet((Object[])new IdentityProviderImage[]{identityProviderImage}));
    }

    @Override
    public void setNetwork(Network network) {
        this._persistence_set_network(network);
    }

    public void setTextColor(String string) {
        this._persistence_set_textColor(string);
    }

    public void setType(IdentityProviderType identityProviderType) {
        this._persistence_set_type(identityProviderType);
    }

    public void setUploadedImage(TempImage tempImage) {
        this.uploadedImage = tempImage;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_network_vh != null) {
            this._persistence_network_vh = (WeavedAttributeValueHolderInterface)this._persistence_network_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new IdentityProvider();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "channelConfigurations") {
            return this.channelConfigurations;
        }
        if (string == "backgroundColor") {
            return this.backgroundColor;
        }
        if (string == "borderColor") {
            return this.borderColor;
        }
        if (string == "images") {
            return this.images;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "textColor") {
            return this.textColor;
        }
        if (string == "enabled") {
            return this.enabled;
        }
        if (string == "users") {
            return this.users;
        }
        if (string == "network") {
            return this.network;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "channelConfigurations") {
            this.channelConfigurations = (Set)object;
            return;
        }
        if (string == "backgroundColor") {
            this.backgroundColor = (String)object;
            return;
        }
        if (string == "borderColor") {
            this.borderColor = (String)object;
            return;
        }
        if (string == "images") {
            this.images = (Set)object;
            return;
        }
        if (string == "type") {
            this.type = (IdentityProviderType)object;
            return;
        }
        if (string == "textColor") {
            this.textColor = (String)object;
            return;
        }
        if (string == "enabled") {
            this.enabled = (Boolean)object;
            return;
        }
        if (string == "users") {
            this.users = (Set)object;
            return;
        }
        if (string == "network") {
            this.network = (Network)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_channelConfigurations() {
        this._persistence_checkFetched("channelConfigurations");
        return this.channelConfigurations;
    }

    public void _persistence_set_channelConfigurations(Set set) {
        this._persistence_checkFetchedForSet("channelConfigurations");
        this._persistence_propertyChange("channelConfigurations", this.channelConfigurations, set);
        this.channelConfigurations = set;
    }

    public String _persistence_get_backgroundColor() {
        this._persistence_checkFetched("backgroundColor");
        return this.backgroundColor;
    }

    public void _persistence_set_backgroundColor(String string) {
        this._persistence_checkFetchedForSet("backgroundColor");
        this._persistence_propertyChange("backgroundColor", this.backgroundColor, string);
        this.backgroundColor = string;
    }

    public String _persistence_get_borderColor() {
        this._persistence_checkFetched("borderColor");
        return this.borderColor;
    }

    public void _persistence_set_borderColor(String string) {
        this._persistence_checkFetchedForSet("borderColor");
        this._persistence_propertyChange("borderColor", this.borderColor, string);
        this.borderColor = string;
    }

    public Set _persistence_get_images() {
        this._persistence_checkFetched("images");
        return this.images;
    }

    public void _persistence_set_images(Set set) {
        this._persistence_checkFetchedForSet("images");
        this._persistence_propertyChange("images", this.images, set);
        this.images = set;
    }

    public IdentityProviderType _persistence_get_type() {
        this._persistence_checkFetched("type");
        return this.type;
    }

    public void _persistence_set_type(IdentityProviderType identityProviderType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_propertyChange("type", this.type, identityProviderType);
        this.type = identityProviderType;
    }

    public String _persistence_get_textColor() {
        this._persistence_checkFetched("textColor");
        return this.textColor;
    }

    public void _persistence_set_textColor(String string) {
        this._persistence_checkFetchedForSet("textColor");
        this._persistence_propertyChange("textColor", this.textColor, string);
        this.textColor = string;
    }

    public Boolean _persistence_get_enabled() {
        this._persistence_checkFetched("enabled");
        return this.enabled;
    }

    public void _persistence_set_enabled(Boolean bl) {
        this._persistence_checkFetchedForSet("enabled");
        this._persistence_propertyChange("enabled", this.enabled, bl);
        this.enabled = bl;
    }

    public Set _persistence_get_users() {
        this._persistence_checkFetched("users");
        return this.users;
    }

    public void _persistence_set_users(Set set) {
        this._persistence_checkFetchedForSet("users");
        this._persistence_propertyChange("users", this.users, set);
        this.users = set;
    }

    protected void _persistence_initialize_network_vh() {
        if (this._persistence_network_vh == null) {
            this._persistence_network_vh = new ValueHolder((Object)this.network);
            this._persistence_network_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_network_vh() {
        Network network;
        this._persistence_initialize_network_vh();
        if ((this._persistence_network_vh.isCoordinatedWithProperty() || this._persistence_network_vh.isNewlyWeavedValueHolder()) && (network = this._persistence_get_network()) != this._persistence_network_vh.getValue()) {
            this._persistence_set_network(network);
        }
        return this._persistence_network_vh;
    }

    public void _persistence_set_network_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_network_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Network network = this._persistence_get_network();
            if (network != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_network((Network)object);
            }
        } else {
            this.network = null;
        }
    }

    public Network _persistence_get_network() {
        this._persistence_checkFetched("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        return this.network;
    }

    public void _persistence_set_network(Network network) {
        this._persistence_checkFetchedForSet("network");
        this._persistence_initialize_network_vh();
        this.network = (Network)this._persistence_network_vh.getValue();
        this._persistence_propertyChange("network", this.network, network);
        this.network = network;
        this._persistence_network_vh.setValue((Object)network);
    }
}

