/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.AccessClientLog;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.ExternalRedirectExecution;
import org.cyclos.entities.system.InternetAddressList;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.model.access.clients.AccessClientStatus;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="access_clients", indexes={@Index(name="ix_access_clients_token", unique=true, columnList="token"), @Index(name="ix_access_clients_activation_code", unique=true, columnList="user_id, activation_code")})
public class AccessClient
extends NamedEntity
implements UserPrincipal,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    @OwnerEntity
    @ReadOnlyFromDTO(onInsert=false)
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="type_id", nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private AccessClientPrincipalType type;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", length=100, nullable=false)
    @ReadOnlyFromDTO
    private AccessClientStatus status;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="activation_date")
    @ReadOnlyFromDTO
    private Date activationDate;
    @Basic
    @Column(name="activation_code")
    private String activationCode;
    @Basic
    @Column(name="token")
    private String token;
    @OneToMany(mappedBy="accessClient", cascade={CascadeType.REMOVE})
    private Set<Session> sessions;
    @OneToMany(mappedBy="accessClient", cascade={CascadeType.REMOVE})
    private Set<ExternalRedirectExecution> externalRedirectExecutions;
    @OneToMany(mappedBy="accessClient", cascade={CascadeType.REMOVE})
    @OrderBy(value="date desc")
    private List<AccessClientLog> logs;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="whitelist_id")
    private InternetAddressList whitelist;
    @OneToMany(mappedBy="accessClient")
    private Set<Transaction> transactions;
    @OneToMany(mappedBy="accessClient", cascade={CascadeType.REMOVE})
    private Set<Pin> pins;
    static final long serialVersionUID = 3564975044462728984L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_whitelist_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_type_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;

    @Override
    public AccessClient getAccessClient() {
        return this;
    }

    public String getAccessClientToken() {
        return this._persistence_get_token();
    }

    @Override
    public UserAccountType getAccountType() {
        return null;
    }

    public String getActivationCode() {
        return this._persistence_get_activationCode();
    }

    public Date getActivationDate() {
        return this._persistence_get_activationDate();
    }

    @Override
    public BasicUser getBasicUser() {
        return this._persistence_get_user();
    }

    @Override
    public UserCustomFieldValue getCustomFieldValue() {
        return null;
    }

    public String getIpWhitelist() {
        return this._persistence_get_whitelist() == null ? null : this._persistence_get_whitelist().getAddresses();
    }

    public List<AccessClientLog> getLogs() {
        return this._persistence_get_logs();
    }

    @Override
    public MobilePhone getMobilePhone() {
        return null;
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_user().getNetwork();
    }

    @Override
    public String getPrincipal() {
        return null;
    }

    @Override
    public PrincipalType getPrincipalType() {
        return this._persistence_get_type();
    }

    public AccessClientStatus getStatus() {
        return this._persistence_get_status();
    }

    @Override
    public Token getToken() {
        return null;
    }

    @Override
    public TrustedDevice getTrustedDevice() {
        return null;
    }

    public AccessClientPrincipalType getType() {
        return this._persistence_get_type();
    }

    public User getUser() {
        return this._persistence_get_user();
    }

    public InternetAddressList getWhitelist() {
        return this._persistence_get_whitelist();
    }

    public boolean isUseIpWhitelist() {
        return this._persistence_get_whitelist() != null;
    }

    public void setAccessClientToken(String string) {
        this._persistence_set_token(string);
    }

    public void setActivationCode(String string) {
        this._persistence_set_activationCode(string);
    }

    public void setActivationDate(Date date) {
        this._persistence_set_activationDate(date);
    }

    public void setLogs(List<AccessClientLog> list) {
        this._persistence_set_logs(list);
    }

    public void setStatus(AccessClientStatus accessClientStatus) {
        this._persistence_set_status(accessClientStatus);
    }

    public void setType(AccessClientPrincipalType accessClientPrincipalType) {
        this._persistence_set_type(accessClientPrincipalType);
    }

    public void setUser(User user) {
        this._persistence_set_user(user);
    }

    public void setWhitelist(InternetAddressList internetAddressList) {
        this._persistence_set_whitelist(internetAddressList);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_whitelist_vh != null) {
            this._persistence_whitelist_vh = (WeavedAttributeValueHolderInterface)this._persistence_whitelist_vh.clone();
        }
        if (this._persistence_type_vh != null) {
            this._persistence_type_vh = (WeavedAttributeValueHolderInterface)this._persistence_type_vh.clone();
        }
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AccessClient();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "sessions") {
            return this.sessions;
        }
        if (string == "pins") {
            return this.pins;
        }
        if (string == "whitelist") {
            return this.whitelist;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "transactions") {
            return this.transactions;
        }
        if (string == "token") {
            return this.token;
        }
        if (string == "activationCode") {
            return this.activationCode;
        }
        if (string == "activationDate") {
            return this.activationDate;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "logs") {
            return this.logs;
        }
        if (string == "status") {
            return this.status;
        }
        if (string == "externalRedirectExecutions") {
            return this.externalRedirectExecutions;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "sessions") {
            this.sessions = (Set)object;
            return;
        }
        if (string == "pins") {
            this.pins = (Set)object;
            return;
        }
        if (string == "whitelist") {
            this.whitelist = (InternetAddressList)object;
            return;
        }
        if (string == "type") {
            this.type = (AccessClientPrincipalType)object;
            return;
        }
        if (string == "transactions") {
            this.transactions = (Set)object;
            return;
        }
        if (string == "token") {
            this.token = (String)object;
            return;
        }
        if (string == "activationCode") {
            this.activationCode = (String)object;
            return;
        }
        if (string == "activationDate") {
            this.activationDate = (Date)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        if (string == "logs") {
            this.logs = (List)object;
            return;
        }
        if (string == "status") {
            this.status = (AccessClientStatus)object;
            return;
        }
        if (string == "externalRedirectExecutions") {
            this.externalRedirectExecutions = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_sessions() {
        this._persistence_checkFetched("sessions");
        return this.sessions;
    }

    public void _persistence_set_sessions(Set set) {
        this._persistence_checkFetchedForSet("sessions");
        this._persistence_propertyChange("sessions", this.sessions, set);
        this.sessions = set;
    }

    public Set _persistence_get_pins() {
        this._persistence_checkFetched("pins");
        return this.pins;
    }

    public void _persistence_set_pins(Set set) {
        this._persistence_checkFetchedForSet("pins");
        this._persistence_propertyChange("pins", this.pins, set);
        this.pins = set;
    }

    protected void _persistence_initialize_whitelist_vh() {
        if (this._persistence_whitelist_vh == null) {
            this._persistence_whitelist_vh = new ValueHolder((Object)this.whitelist);
            this._persistence_whitelist_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_whitelist_vh() {
        InternetAddressList internetAddressList;
        this._persistence_initialize_whitelist_vh();
        if ((this._persistence_whitelist_vh.isCoordinatedWithProperty() || this._persistence_whitelist_vh.isNewlyWeavedValueHolder()) && (internetAddressList = this._persistence_get_whitelist()) != this._persistence_whitelist_vh.getValue()) {
            this._persistence_set_whitelist(internetAddressList);
        }
        return this._persistence_whitelist_vh;
    }

    public void _persistence_set_whitelist_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_whitelist_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            InternetAddressList internetAddressList = this._persistence_get_whitelist();
            if (internetAddressList != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_whitelist((InternetAddressList)object);
            }
        } else {
            this.whitelist = null;
        }
    }

    public InternetAddressList _persistence_get_whitelist() {
        this._persistence_checkFetched("whitelist");
        this._persistence_initialize_whitelist_vh();
        this.whitelist = (InternetAddressList)this._persistence_whitelist_vh.getValue();
        return this.whitelist;
    }

    public void _persistence_set_whitelist(InternetAddressList internetAddressList) {
        this._persistence_checkFetchedForSet("whitelist");
        this._persistence_initialize_whitelist_vh();
        this.whitelist = (InternetAddressList)this._persistence_whitelist_vh.getValue();
        this._persistence_propertyChange("whitelist", this.whitelist, internetAddressList);
        this.whitelist = internetAddressList;
        this._persistence_whitelist_vh.setValue((Object)internetAddressList);
    }

    protected void _persistence_initialize_type_vh() {
        if (this._persistence_type_vh == null) {
            this._persistence_type_vh = new ValueHolder((Object)this.type);
            this._persistence_type_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_type_vh() {
        AccessClientPrincipalType accessClientPrincipalType;
        this._persistence_initialize_type_vh();
        if ((this._persistence_type_vh.isCoordinatedWithProperty() || this._persistence_type_vh.isNewlyWeavedValueHolder()) && (accessClientPrincipalType = this._persistence_get_type()) != this._persistence_type_vh.getValue()) {
            this._persistence_set_type(accessClientPrincipalType);
        }
        return this._persistence_type_vh;
    }

    public void _persistence_set_type_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_type_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AccessClientPrincipalType accessClientPrincipalType = this._persistence_get_type();
            if (accessClientPrincipalType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_type((AccessClientPrincipalType)object);
            }
        } else {
            this.type = null;
        }
    }

    public AccessClientPrincipalType _persistence_get_type() {
        this._persistence_checkFetched("type");
        this._persistence_initialize_type_vh();
        this.type = (AccessClientPrincipalType)this._persistence_type_vh.getValue();
        return this.type;
    }

    public void _persistence_set_type(AccessClientPrincipalType accessClientPrincipalType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_initialize_type_vh();
        this.type = (AccessClientPrincipalType)this._persistence_type_vh.getValue();
        this._persistence_propertyChange("type", this.type, accessClientPrincipalType);
        this.type = accessClientPrincipalType;
        this._persistence_type_vh.setValue((Object)accessClientPrincipalType);
    }

    public Set _persistence_get_transactions() {
        this._persistence_checkFetched("transactions");
        return this.transactions;
    }

    public void _persistence_set_transactions(Set set) {
        this._persistence_checkFetchedForSet("transactions");
        this._persistence_propertyChange("transactions", this.transactions, set);
        this.transactions = set;
    }

    public String _persistence_get_token() {
        this._persistence_checkFetched("token");
        return this.token;
    }

    public void _persistence_set_token(String string) {
        this._persistence_checkFetchedForSet("token");
        this._persistence_propertyChange("token", this.token, string);
        this.token = string;
    }

    public String _persistence_get_activationCode() {
        this._persistence_checkFetched("activationCode");
        return this.activationCode;
    }

    public void _persistence_set_activationCode(String string) {
        this._persistence_checkFetchedForSet("activationCode");
        this._persistence_propertyChange("activationCode", this.activationCode, string);
        this.activationCode = string;
    }

    public Date _persistence_get_activationDate() {
        this._persistence_checkFetched("activationDate");
        return this.activationDate;
    }

    public void _persistence_set_activationDate(Date date) {
        this._persistence_checkFetchedForSet("activationDate");
        this._persistence_propertyChange("activationDate", this.activationDate, date);
        this.activationDate = date;
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        User user;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(user);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_user();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((User)object);
            }
        } else {
            this.user = null;
        }
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
        this._persistence_user_vh.setValue((Object)user);
    }

    public List _persistence_get_logs() {
        this._persistence_checkFetched("logs");
        return this.logs;
    }

    public void _persistence_set_logs(List list) {
        this._persistence_checkFetchedForSet("logs");
        this._persistence_propertyChange("logs", this.logs, list);
        this.logs = list;
    }

    public AccessClientStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(AccessClientStatus accessClientStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, accessClientStatus);
        this.status = accessClientStatus;
    }

    public Set _persistence_get_externalRedirectExecutions() {
        this._persistence_checkFetched("externalRedirectExecutions");
        return this.externalRedirectExecutions;
    }

    public void _persistence_set_externalRedirectExecutions(Set set) {
        this._persistence_checkFetchedForSet("externalRedirectExecutions");
        this._persistence_propertyChange("externalRedirectExecutions", this.externalRedirectExecutions, set);
        this.externalRedirectExecutions = set;
    }
}

