/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.namemapping;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.namemapping.NameMapping;
import java.util.HashMap;
import java.util.Map;

public class PreConfiguredNameMapping
implements NameMapping {
    private final Map<SchemaAndTable, SchemaAndTable> schemaTables = Maps.newHashMap();
    private final Map<String, String> tables = Maps.newHashMap();
    private final Map<SchemaAndTable, Map<String, String>> schemaTableColumns = Maps.newHashMap();
    private final Map<String, Map<String, String>> tableColumns = Maps.newHashMap();

    @Override
    public Optional<SchemaAndTable> getOverride(SchemaAndTable key) {
        if (!this.schemaTables.isEmpty() && key.getSchema() != null && this.schemaTables.containsKey(key)) {
            return Optional.of((Object)this.schemaTables.get(key));
        }
        if (this.tables.containsKey(key.getTable())) {
            String table = this.tables.get(key.getTable());
            return Optional.of((Object)new SchemaAndTable(key.getSchema(), table));
        }
        return Optional.absent();
    }

    @Override
    public Optional<String> getColumnOverride(SchemaAndTable key, String column) {
        String newColumn = null;
        Map<String, String> columnOverrides = this.schemaTableColumns.get(key);
        if (columnOverrides != null && (newColumn = columnOverrides.get(column)) != null) {
            return Optional.of((Object)newColumn);
        }
        columnOverrides = this.tableColumns.get(key.getTable());
        if (columnOverrides != null && (newColumn = columnOverrides.get(column)) != null) {
            return Optional.of((Object)newColumn);
        }
        return Optional.absent();
    }

    public String registerTableOverride(String oldTable, String newTable) {
        return this.tables.put(oldTable, newTable);
    }

    public SchemaAndTable registerTableOverride(SchemaAndTable from, SchemaAndTable to) {
        return this.schemaTables.put(from, to);
    }

    public String registerColumnOverride(String schema, String table, String oldColumn, String newColumn) {
        SchemaAndTable key = new SchemaAndTable(schema, table);
        Map<String, String> columnOverrides = this.schemaTableColumns.get(key);
        if (columnOverrides == null) {
            columnOverrides = new HashMap<String, String>();
            this.schemaTableColumns.put(key, columnOverrides);
        }
        return columnOverrides.put(oldColumn, newColumn);
    }

    public String registerColumnOverride(String table, String oldColumn, String newColumn) {
        Map<String, String> columnOverrides = this.tableColumns.get(table);
        if (columnOverrides == null) {
            columnOverrides = new HashMap<String, String>();
            this.tableColumns.put(table, columnOverrides);
        }
        return columnOverrides.put(oldColumn, newColumn);
    }
}

