/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ChannelLogger;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.rls.AdaptiveThrottler;
import io.grpc.rls.CachingRlsLbClient;
import io.grpc.rls.ChildLbResolvedAddressFactory;
import io.grpc.rls.LbPolicyConfiguration;
import javax.annotation.Nullable;

final class RlsLoadBalancer
extends LoadBalancer {
    private final ChannelLogger logger;
    private final LoadBalancer.Helper helper;
    @VisibleForTesting
    CachingRlsLbClientBuilderProvider cachingRlsLbClientBuilderProvider = new DefaultCachingRlsLbClientBuilderProvider();
    @Nullable
    private LbPolicyConfiguration lbPolicyConfiguration;
    @Nullable
    private CachingRlsLbClient routeLookupClient;

    RlsLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.logger = helper.getChannelLogger();
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Rls lb created. Authority: {0}", new Object[]{helper.getAuthority()});
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Received resolution result: {0}", new Object[]{resolvedAddresses});
        LbPolicyConfiguration lbPolicyConfiguration = (LbPolicyConfiguration)resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull((Object)lbPolicyConfiguration, (Object)"Missing rls lb config");
        if (!lbPolicyConfiguration.equals(this.lbPolicyConfiguration)) {
            boolean needToConnect;
            boolean bl = needToConnect = this.lbPolicyConfiguration == null || !this.lbPolicyConfiguration.getRouteLookupConfig().lookupService().equals(lbPolicyConfiguration.getRouteLookupConfig().lookupService());
            if (needToConnect) {
                if (this.routeLookupClient != null) {
                    this.routeLookupClient.close();
                }
                this.routeLookupClient = this.cachingRlsLbClientBuilderProvider.get().setHelper(this.helper).setLbPolicyConfig(lbPolicyConfiguration).setResolvedAddressesFactory(new ChildLbResolvedAddressFactory(resolvedAddresses.getAddresses(), resolvedAddresses.getAttributes())).build();
                this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "LbPolicyConfiguration updated to {0}", new Object[]{lbPolicyConfiguration});
            }
            this.lbPolicyConfiguration = lbPolicyConfiguration;
        }
        return Status.OK;
    }

    public void requestConnection() {
        if (this.routeLookupClient != null) {
            this.routeLookupClient.requestConnection();
        }
    }

    public void handleNameResolutionError(final Status error) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Received resolution error: {0}", new Object[]{error});
        if (this.routeLookupClient != null) {
            this.routeLookupClient.close();
            this.routeLookupClient = null;
            this.lbPolicyConfiguration = null;
        }
        class ErrorPicker
        extends LoadBalancer.SubchannelPicker {
            ErrorPicker() {
            }

            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                return LoadBalancer.PickResult.withError((Status)error);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)((Object)this)).add("error", (Object)error).toString();
            }
        }
        this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new ErrorPicker());
    }

    public void shutdown() {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Rls lb shutdown");
        if (this.routeLookupClient != null) {
            this.routeLookupClient.close();
            this.routeLookupClient = null;
        }
    }

    static final class DefaultCachingRlsLbClientBuilderProvider
    implements CachingRlsLbClientBuilderProvider {
        DefaultCachingRlsLbClientBuilderProvider() {
        }

        @Override
        public CachingRlsLbClient.Builder get() {
            return CachingRlsLbClient.newBuilder().setThrottler(AdaptiveThrottler.builder().build());
        }
    }

    static interface CachingRlsLbClientBuilderProvider {
        public CachingRlsLbClient.Builder get();
    }
}

