/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import java.util.Collection;
import java.util.Map;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.utils.validation.GeneralValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.banking.transactions.HasTransactionNumber;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.marketplace.webshoporders.IOrder;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.model.utils.DistanceDTO;
import org.cyclos.model.utils.FileSizeDTO;
import org.cyclos.model.utils.ICurrencyAmount;
import org.cyclos.model.utils.ILatLong;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.StringHelper;

public class RequiredValidation
extends BasePropertyValidation
implements GeneralValidation {
    public static boolean isValid(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof UserLocatorVO) {
            return ModelHelper.isValid((UserLocatorVO)((UserLocatorVO)object));
        }
        if (object instanceof EntityVO) {
            String string;
            Long l = ((EntityVO)object).getId();
            String string2 = object instanceof IInternalNamedEntity ? ((IInternalNamedEntity)object).getInternalName() : null;
            String string3 = object instanceof HasTransactionNumber ? ((HasTransactionNumber)object).getTransactionNumber() : null;
            String string4 = object instanceof TicketVO ? ((TicketVO)object).getTicketNumber() : null;
            String string5 = string = object instanceof IOrder ? ((IOrder)object).getNumber() : null;
            if (l == null && string2 == null && string3 == null && string4 == null && string == null) {
                if (object instanceof BasicUserVO) {
                    return RequiredValidation.isValid(((BasicUserVO)object).getLocator());
                }
                return false;
            }
        } else {
            if (object instanceof String && StringHelper.isBlank((Object)object) || object instanceof Collection && ((Collection)object).isEmpty()) {
                return false;
            }
            if (object instanceof Map && ((Map)object).isEmpty() || object instanceof Object[] && ((Object[])object).length == 0) {
                return false;
            }
            if (object instanceof ITimeInterval) {
                ITimeInterval iTimeInterval = (ITimeInterval)object;
                return iTimeInterval.getAmount() != null && iTimeInterval.getAmount() >= 0 && iTimeInterval.getField() != null;
            }
            if (object instanceof IntegerRangeDTO) {
                IntegerRangeDTO integerRangeDTO = (IntegerRangeDTO)object;
                return integerRangeDTO.getMin() != null && integerRangeDTO.getMax() != null;
            }
            if (object instanceof DecimalRangeDTO) {
                DecimalRangeDTO decimalRangeDTO = (DecimalRangeDTO)object;
                return decimalRangeDTO.getMin() != null && decimalRangeDTO.getMax() != null;
            }
            if (object instanceof ICurrencyAmount) {
                ICurrencyAmount iCurrencyAmount = (ICurrencyAmount)object;
                return iCurrencyAmount.getAmount() != null && RequiredValidation.isValid(iCurrencyAmount.getCurrency());
            }
            if (object instanceof FileSizeDTO) {
                FileSizeDTO fileSizeDTO = (FileSizeDTO)object;
                return fileSizeDTO.getSize() != null && fileSizeDTO.getSize() >= 0 && fileSizeDTO.getUnit() != null;
            }
            if (object instanceof DatePeriodDTO) {
                DatePeriodDTO datePeriodDTO = (DatePeriodDTO)object;
                return datePeriodDTO.getBegin() != null && datePeriodDTO.getEnd() != null;
            }
            if (object instanceof DistanceDTO) {
                DistanceDTO distanceDTO = (DistanceDTO)object;
                return ModelHelper.isValid((DistanceDTO)distanceDTO);
            }
            if (object instanceof ILatLong) {
                ILatLong iLatLong = (ILatLong)object;
                return iLatLong.getLatitude() != null && iLatLong.getLongitude() != null;
            }
            if (object instanceof DatePeriod) {
                DatePeriod datePeriod = (DatePeriod)object;
                return datePeriod.getBegin() != null && datePeriod.getEnd() != null;
            }
        }
        return true;
    }

    RequiredValidation() {
        super(ValidationErrors.required());
    }

    RequiredValidation(ValidationError validationError) {
        super(validationError);
    }

    @Override
    public ValidationError validate(Object object) {
        if (this.isValid(null, null, object)) {
            return null;
        }
        return this.error;
    }

    @Override
    protected boolean handleEmpty() {
        return true;
    }

    @Override
    protected boolean isValid(Object object, Object object2, Object object3) {
        return RequiredValidation.isValid(object3);
    }
}

