/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation;

import java.util.Collection;
import org.cyclos.entities.system.CustomField;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.Property;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.springframework.beans.BeanWrapperImpl;

public class CustomFieldPropertyAccess
implements PropertyAccess {
    private final Object valuesProperty;
    private final CustomField<?, ?, ?> customField;
    private final CustomFieldValueHandler customFieldValueHandler;
    private boolean sanitize;

    public CustomFieldPropertyAccess(CustomField<?, ?, ?> customField, CustomFieldValueHandler customFieldValueHandler, boolean bl) {
        this(customField, UserDTO.CUSTOM_VALUES.getName(), customFieldValueHandler, bl);
    }

    public CustomFieldPropertyAccess(CustomField<?, ?, ?> customField, Object object, CustomFieldValueHandler customFieldValueHandler, boolean bl) {
        this.customField = customField;
        this.valuesProperty = object;
        this.customFieldValueHandler = customFieldValueHandler;
        this.sanitize = bl;
    }

    public ICustomFieldValue<?, ?, ?, ?> findCustomValue(Object object) {
        Object object2 = new BeanWrapperImpl(object).getPropertyValue(PropertyHelper.getPropertyName((Object)this.valuesProperty));
        if (this.valuesProperty instanceof Property) {
            CustomFieldValueDTO customFieldValueDTO = new CustomFieldValueDTO();
            customFieldValueDTO.setField(new CustomFieldVO(this.customField.getId()));
            customFieldValueDTO.setReferenceValue(object2.toString());
            return customFieldValueDTO;
        }
        if (object2 instanceof ICustomFieldValue) {
            return (ICustomFieldValue)object2;
        }
        Collection collection = (Collection)object2;
        return CustomFieldHelper.findValue(this.customField, (Collection)collection);
    }

    @Override
    public Object get(Object object) {
        ICustomFieldValue<?, ?, ?, ?> iCustomFieldValue = this.findCustomValue(object);
        if (iCustomFieldValue == null) {
            return null;
        }
        return this.customFieldValueHandler.getValue(this.customField, iCustomFieldValue, this.sanitize);
    }

    @Override
    public Object getIdentifier() {
        return this.valuesProperty instanceof Property ? ((Property)this.valuesProperty).getName() : this.customField;
    }

    @Override
    public String getPropertyName() {
        return this.valuesProperty instanceof Property ? ((Property)this.valuesProperty).getName() : this.customField.getInternalName();
    }

    @Override
    public Object getValidationIdentifier() {
        return this.customField;
    }
}

