/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import java.util.HashMap;
import java.util.Map;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.MapAccessorCacheValue;
import org.cyclos.model.Bean;
import org.cyclos.model.Property;
import org.springframework.context.ApplicationContext;

public class BeanAccessorCacheValue
extends AccessorCacheValue {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Bean> beanType;
    private final MapAccessorCacheValue properties;

    public BeanAccessorCacheValue(Bean bean) {
        this.beanType = bean.getClass();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Property property : bean.properties()) {
            hashMap.put(property.getName(), bean.get(property));
        }
        this.properties = AccessorCacheValue.create(hashMap);
    }

    @Override
    public Object unwrap(ApplicationContext applicationContext) {
        Bean bean = ((BeanHandler)applicationContext.getBean(BeanHandler.class)).instantiate(this.beanType);
        Map map = (Map)this.properties.unwrap(applicationContext);
        for (Property property : bean.properties()) {
            Object v = map.get(property.getName());
            bean.set(property, v);
        }
        return bean;
    }
}

