/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users.productresolvers;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanPath;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.ComparatorUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.users.productresolvers.BooleanPropertiesResolver;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.BooleanPropertiesHolderImpl;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class BaseBooleanPropertiesResolver<K, R extends SimpleEntity>
implements BooleanPropertiesResolver<K> {
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    protected ConversionHandler conversionHandler;
    private volatile Set<BooleanPath> paths;

    @Override
    public String getKeyPropertyName() {
        return PropertyHelper.getPropertyName(this.getKeyPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BooleanPath> getPaths() {
        if (this.paths == null) {
            BaseBooleanPropertiesResolver baseBooleanPropertiesResolver = this;
            synchronized (baseBooleanPropertiesResolver) {
                if (this.paths == null) {
                    HashSet<BooleanPath> hashSet = new HashSet<BooleanPath>();
                    this.initPaths(hashSet);
                    this.paths = Collections.unmodifiableSet(hashSet);
                }
            }
        }
        return this.paths;
    }

    @Override
    public final BooleanPropertiesHolder<K> resolve(Collection<Product> collection, String string, Void void_) {
        TreeMap<K, BooleanProperties> treeMap = new TreeMap<K, BooleanProperties>(this.getComparator());
        for (Product product : collection) {
            Collection<R> collection2 = this.getRelationships(product);
            if (CollectionHelper.isEmpty(collection2)) continue;
            for (SimpleEntity simpleEntity : collection2) {
                K k = this.getKey(simpleEntity);
                if (k == null) continue;
                BeanWrapper beanWrapper = InvocationContext.wrap(simpleEntity);
                BooleanProperties booleanProperties = (BooleanProperties)treeMap.get(k);
                if (booleanProperties == null) {
                    booleanProperties = new BooleanProperties();
                    treeMap.put(k, booleanProperties);
                }
                for (BooleanPath booleanPath : this.getPaths()) {
                    Object object;
                    try {
                        object = beanWrapper.getPropertyValue(PropertyHelper.getPropertyName((Path)booleanPath));
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    boolean bl = Boolean.TRUE.equals(object);
                    if (!bl) continue;
                    booleanProperties.set((Path<Boolean>)booleanPath);
                }
            }
        }
        return new BooleanPropertiesHolderImpl<K>(treeMap, this.getKeyPropertyName());
    }

    protected <T extends SimpleEntity> T find(Class<T> clazz, Long l) {
        return (T)((SimpleEntity)this.rawEntityManagerHandler.find(clazz, l));
    }

    protected Comparator<K> getComparator() {
        return ComparatorUtils.naturalComparator();
    }

    protected abstract K getKey(R var1);

    protected abstract Path<K> getKeyPath();

    protected abstract Collection<R> getRelationships(Product var1);

    protected abstract void initPaths(Set<BooleanPath> var1);
}

