/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.contentmanagement.DocumentCategory;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomWebService;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QProductMyProfileField;
import org.cyclos.entities.users.QuickAccess;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.users.EmptyProductsAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.BooleanPropertiesHolderImpl;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.Role;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;

public class EmptyProductAccessor
implements ProductAccessor {
    private static final ProductAccessor INSTANCE = new EmptyProductAccessor();
    private Set<EmptyProductsAccessor.Access> accesses;
    private ProductAccessor delegate;

    public static ProductAccessor getInstance() {
        return INSTANCE;
    }

    public static ProductAccessor getInstance(Set<EmptyProductsAccessor.Access> set, ProductAccessor productAccessor) {
        return new EmptyProductAccessor(set, productAccessor);
    }

    protected EmptyProductAccessor() {
        this(null, null);
    }

    private EmptyProductAccessor(Set<EmptyProductsAccessor.Access> set, ProductAccessor productAccessor) {
        this.accesses = set == null ? EnumSet.noneOf(EmptyProductsAccessor.Access.class) : set;
        this.delegate = productAccessor;
    }

    @Override
    public List<BasicGroup> getAccessibleUserGroups() {
        return Collections.emptyList();
    }

    @Override
    public List<Agreement> getAgreements() {
        return this.accesses.contains((Object)EmptyProductsAccessor.Access.AGREEMENTS) ? this.delegate.getAgreements() : Collections.emptyList();
    }

    @Override
    public List<QuickAccess> getDefaultQuickAccess() {
        return Collections.emptyList();
    }

    @Override
    public List<DocumentCategory> getDocumentCategoryView() {
        return Collections.emptyList();
    }

    @Override
    public List<BasicGroup> getGroupsForUserDirectory() {
        return Collections.emptyList();
    }

    @Override
    public int getMaxAddresses() {
        return 0;
    }

    @Override
    public int getMaxCustomImages() {
        return 0;
    }

    @Override
    public int getMaxInvitationRecipients() {
        return 0;
    }

    @Override
    public int getMaxLandlinePhones() {
        return 0;
    }

    @Override
    public int getMaxMessageRecipients() {
        return 0;
    }

    @Override
    public int getMaxMobilePhones() {
        return 0;
    }

    @Override
    public int getMaxProfileImages() {
        return this.accesses.isEmpty() ? 0 : 1;
    }

    @Override
    public int getMaxSmsPerMonth() {
        return 0;
    }

    @Override
    public BooleanPropertiesHolder<AccessClientPrincipalType> getMyAccessClients() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public BooleanPropertiesHolder<ContactCustomField> getMyContactFields() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public BooleanPropertiesHolder<ProfileField> getMyProfileFields() {
        if (!this.accesses.isEmpty()) {
            return this.delegate.getMyProfileFields().filter((ProfileField)BasicProfileField.IMAGE, Arrays.asList(QProductMyProfileField.productMyProfileField.enabled, QProductMyProfileField.productMyProfileField.visible));
        }
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public BooleanPropertiesHolder<RecordCustomField> getMyRecordFields(UserRecordType userRecordType) {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public BooleanPropertiesHolder<UserRecordType> getMyRecordTypes() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public BooleanPropertiesHolder<PasswordType> getPasswordActions() {
        if (this.accesses.contains((Object)EmptyProductsAccessor.Access.MANAGE_PASSWORDS)) {
            return this.delegate.getPasswordActions();
        }
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public List<Permission> getPermissions() {
        if (this.accesses.contains((Object)EmptyProductsAccessor.Access.MANAGE_PASSWORDS) && this.delegate.hasPermission(Permission.MY_PASSWORDS_MANAGE)) {
            return Collections.singletonList(Permission.MY_PASSWORDS_MANAGE);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Product> getProducts() {
        return Collections.emptyList();
    }

    @Override
    public List<Role> getRoles() {
        return Collections.emptyList();
    }

    @Override
    public List<CustomWebService> getRunCustomWebServices() {
        return Collections.emptyList();
    }

    @Override
    public List<CustomOperation> getRunTransferCustomOperations() {
        return Collections.emptyList();
    }

    @Override
    public List<ProfileField> getSimpleUserSearchProfileFields() {
        return Collections.emptyList();
    }

    @Override
    public BooleanPropertiesHolder<TransferStatusFlow> getTransferStatusFlows() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public List<UserGroupAccessibility> getUserDirectoryOnGroups() {
        return Collections.emptyList();
    }

    @Override
    public List<UserGroupAccessibility> getUserGroupAccessibility() {
        return Collections.emptyList();
    }

    @Override
    public BooleanPropertiesHolder<ProfileField> getUserProfileFields() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public List<TransactionCustomField> getVisibleTransactionFields() {
        return Collections.emptyList();
    }

    @Override
    public List<VoucherCustomField> getVisibleVoucherFields() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.accesses.contains((Object)EmptyProductsAccessor.Access.MANAGE_PASSWORDS) && Permission.MY_PASSWORDS_MANAGE == permission ? this.delegate.hasPermission(permission) : false;
    }

    @Override
    public boolean hasRole(Role role) {
        return false;
    }

    @Override
    public boolean isEditMyProfile() {
        return false;
    }
}

