/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.entities.access.QChannel;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.QTransferFilter;
import org.cyclos.entities.banking.QTransferType;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QCustomOperation;
import org.cyclos.entities.system.QSystemWizard;
import org.cyclos.entities.system.QUserWizard;
import org.cyclos.entities.system.SystemWizard;
import org.cyclos.entities.system.UserWizard;
import org.cyclos.entities.users.QProductMyProfileField;
import org.cyclos.entities.users.QProductRecordField;
import org.cyclos.entities.users.QProductUserProfileField;
import org.cyclos.entities.users.QUserCustomField;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.impl.users.ProductsHandler;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.users.productresolvers.BooleanPropertiesResolver;
import org.cyclos.impl.utils.BooleanProperties;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.BooleanPropertiesHolderImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.context.ApplicationContext;

public abstract class AbstractSystemProductAccessor {
    protected ApplicationContext applicationContext;
    protected Network network;
    protected RawEntityManagerHandler rawEntityManagerHandler;
    protected NetworkPathRegistry networkPathRegistry;
    protected ProductsHandler productsHandler;
    protected RecordFieldHandler recordFieldHandler;

    public AbstractSystemProductAccessor(ApplicationContext applicationContext, Network network) {
        this.applicationContext = applicationContext;
        this.network = network;
        this.rawEntityManagerHandler = (RawEntityManagerHandler)applicationContext.getBean(RawEntityManagerHandler.class);
        this.networkPathRegistry = (NetworkPathRegistry)applicationContext.getBean(NetworkPathRegistry.class);
        this.productsHandler = (ProductsHandler)applicationContext.getBean(ProductsHandler.class);
        this.recordFieldHandler = (RecordFieldHandler)applicationContext.getBean(RecordFieldHandler.class);
    }

    protected BooleanPropertiesHolder<ProfileField> forProfileFields(Class<? extends BooleanPropertiesResolver<ProfileField>> clazz, boolean bl) {
        return this.forProfileFields(clazz, bl, false);
    }

    protected BooleanPropertiesHolder<ProfileField> forProfileFields(Class<? extends BooleanPropertiesResolver<ProfileField>> clazz, boolean bl, boolean bl2) {
        EnumSet<BasicProfileField> enumSet = EnumSet.allOf(BasicProfileField.class);
        if (bl2) {
            enumSet.removeIf(basicProfileField -> !basicProfileField.isAllowedForOperator());
        }
        enumSet.remove(BasicProfileField.IMAGE);
        ArrayList<BasicProfileField> arrayList = new ArrayList<BasicProfileField>(enumSet);
        List list = this.selectFrom((EntityPath)QUserCustomField.userCustomField).fetch();
        List list2 = list.stream().filter(userCustomField -> !userCustomField.getType().isSearchable()).collect(Collectors.toList());
        arrayList.addAll(list);
        BooleanPropertiesHolder<ProfileField> booleanPropertiesHolder = this.toBooleanPropertiesHolder(arrayList.stream(), clazz);
        Map map = booleanPropertiesHolder.getBooleansMap();
        QProductUserProfileField qProductUserProfileField = QProductUserProfileField.productUserProfileField;
        QProductMyProfileField qProductMyProfileField = QProductMyProfileField.productMyProfileField;
        if (!bl2 || BasicProfileField.IMAGE.isAllowedForOperator()) {
            BooleanProperties booleanProperties = new BooleanProperties();
            if (bl) {
                booleanProperties.set((Path<Boolean>)qProductMyProfileField.enabled);
            }
            booleanProperties.set((Path<Boolean>)qProductUserProfileField.visible);
            booleanProperties.set((Path<Boolean>)qProductUserProfileField.editable);
            map.put(BasicProfileField.IMAGE, booleanProperties);
        }
        for (UserCustomField userCustomField2 : list2) {
            BooleanProperties booleanProperties = new BooleanProperties();
            if (bl) {
                booleanProperties.set((Path<Boolean>)qProductMyProfileField.enabled);
                booleanProperties.set((Path<Boolean>)qProductMyProfileField.managePrivacy);
            }
            booleanProperties.set((Path<Boolean>)qProductUserProfileField.visible);
            booleanProperties.set((Path<Boolean>)qProductUserProfileField.editable);
            if (!userCustomField2.getType().isBinary()) {
                booleanProperties.set((Path<Boolean>)qProductUserProfileField.userFilter);
                booleanProperties.set((Path<Boolean>)qProductUserProfileField.mapFilter);
                booleanProperties.set((Path<Boolean>)qProductUserProfileField.adFilter);
                booleanProperties.set((Path<Boolean>)qProductUserProfileField.recordFilter);
                if (!userCustomField2.getType().hasMultipleValues()) {
                    booleanProperties.set((Path<Boolean>)qProductUserProfileField.userList);
                    booleanProperties.set((Path<Boolean>)qProductUserProfileField.mapResult);
                }
            }
            map.put(userCustomField2, booleanProperties);
        }
        return booleanPropertiesHolder;
    }

    protected BooleanPropertiesHolder<RecordCustomField> forRecordFields(RecordType recordType) {
        QProductRecordField qProductRecordField = QProductRecordField.productRecordField;
        return this.toBooleanPropertiesHolder((Stream)this.recordFieldHandler.getAllFields(recordType).stream(), (Iterable<BooleanPath>)Arrays.asList(qProductRecordField.view, qProductRecordField.create, qProductRecordField.edit), (EntityPath)QProductRecordField.productRecordField.customField());
    }

    protected DBQuery<?> from(EntityPath<?> entityPath) {
        DBQuery<?> dBQuery = this.rawEntityManagerHandler.from(entityPath);
        this.networkPathRegistry.applyNetworkFilter(dBQuery, entityPath, this.network);
        return dBQuery;
    }

    protected List<CustomOperation> listCustomOperations(CustomOperationScope ... customOperationScopeArray) {
        QCustomOperation qCustomOperation = QCustomOperation.customOperation;
        DBQuery dBQuery = this.selectFrom((EntityPath)qCustomOperation);
        if (CollectionHelper.isNotEmpty((Object[])customOperationScopeArray)) {
            dBQuery.where((Predicate)qCustomOperation.scope.in((Object[])customOperationScopeArray));
        }
        return dBQuery.fetch();
    }

    protected List<PaymentTransferType> listPaymentTypes(AccountType accountType, AccountType accountType2, AccountType accountType3, BuiltInChannel builtInChannel, TransferTypeDirection ... transferTypeDirectionArray) {
        QPaymentTransferType qPaymentTransferType = QPaymentTransferType.paymentTransferType;
        DBQuery dBQuery = this.selectFrom((EntityPath)qPaymentTransferType);
        if (CollectionHelper.isNotEmpty((Object[])transferTypeDirectionArray)) {
            dBQuery.where((Predicate)qPaymentTransferType.direction.in((Object[])transferTypeDirectionArray));
        }
        if (accountType != null) {
            dBQuery.where((Predicate)qPaymentTransferType.from().eq((Object)accountType));
        }
        if (accountType2 != null) {
            dBQuery.where((Predicate)qPaymentTransferType.to().eq((Object)accountType2));
        }
        if (accountType3 != null) {
            dBQuery.where((Predicate)qPaymentTransferType.from().eq((Object)accountType3).or((Predicate)qPaymentTransferType.to().eq((Object)accountType3)));
        }
        if (builtInChannel != null) {
            QChannel qChannel = QChannel.channel;
            dBQuery.innerJoin((EntityPath)qChannel);
            dBQuery.where(new Predicate[]{qChannel.internalName.eq((Object)builtInChannel.getInternalName()), qPaymentTransferType.channels.contains((Expression)qChannel)});
        }
        return dBQuery.fetch();
    }

    protected List<PaymentTransferType> listPaymentTypes(AccountType accountType, AccountType accountType2, TransferTypeDirection ... transferTypeDirectionArray) {
        return this.listPaymentTypes(accountType, accountType2, (AccountType)null, (BuiltInChannel)null, transferTypeDirectionArray);
    }

    protected List<PaymentTransferType> listPaymentTypes(AccountType accountType, TransferTypeDirection ... transferTypeDirectionArray) {
        return this.listPaymentTypes(null, null, accountType, null, transferTypeDirectionArray);
    }

    protected List<PaymentTransferType> listPaymentTypes(TransferTypeDirection ... transferTypeDirectionArray) {
        return this.listPaymentTypes((AccountType)null, (AccountType)null, (AccountType)null, (BuiltInChannel)null, transferTypeDirectionArray);
    }

    protected List<SystemWizard> listSystemWizards() {
        return this.selectFrom((EntityPath)QSystemWizard.systemWizard).fetch();
    }

    protected List<TransferFilter> listTransferFilter(AccountTypeNature accountTypeNature) {
        QTransferFilter qTransferFilter = QTransferFilter.transferFilter;
        return ((DBQuery)this.selectFrom((EntityPath)qTransferFilter).where((Predicate)qTransferFilter.accountType().nature.eq((Object)accountTypeNature))).fetch();
    }

    protected List<TransferType> listTransferTypes(TransferTypeDirection ... transferTypeDirectionArray) {
        QTransferType qTransferType = QTransferType.transferType;
        DBQuery dBQuery = this.selectFrom((EntityPath)qTransferType);
        if (CollectionHelper.isNotEmpty((Object[])transferTypeDirectionArray)) {
            dBQuery.where((Predicate)qTransferType.direction.in((Object[])transferTypeDirectionArray));
        }
        return dBQuery.fetch();
    }

    protected List<UserWizard> listUserWizards() {
        return this.selectFrom((EntityPath)QUserWizard.userWizard).fetch();
    }

    protected <E> DBQuery<E> selectFrom(EntityPath<E> entityPath) {
        return this.from(entityPath).select(entityPath);
    }

    protected <K extends R, R> BooleanPropertiesHolder<K> toBooleanPropertiesHolder(EntityPath<K> entityPath, Class<? extends BooleanPropertiesResolver<R>> clazz) {
        return this.toBooleanPropertiesHolder(this.selectFrom(entityPath).stream(), clazz);
    }

    protected <K extends R, R> BooleanPropertiesHolder<K> toBooleanPropertiesHolder(Stream<K> stream, Class<? extends BooleanPropertiesResolver<R>> clazz) {
        BooleanPropertiesResolver<R> booleanPropertiesResolver = this.productsHandler.getPropertyResolver(clazz);
        Set<BooleanPath> set = booleanPropertiesResolver.getPaths();
        String string = booleanPropertiesResolver.getKeyPropertyName();
        return this.toBooleanPropertiesHolder(stream, set, string);
    }

    protected <K> BooleanPropertiesHolder<K> toBooleanPropertiesHolder(Stream<K> stream, Iterable<BooleanPath> iterable, EntityPath<K> entityPath) {
        return this.toBooleanPropertiesHolder(stream, iterable, PropertyHelper.getPropertyName(entityPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K> BooleanPropertiesHolder<K> toBooleanPropertiesHolder(Stream<K> stream, Iterable<BooleanPath> iterable, String string) {
        try {
            BooleanProperties booleanProperties = new BooleanProperties();
            iterable.forEach(booleanProperties::set);
            HashMap hashMap = new HashMap();
            stream.forEach(object -> hashMap.put(object, booleanProperties));
            BooleanPropertiesHolderImpl booleanPropertiesHolderImpl = new BooleanPropertiesHolderImpl(hashMap, string);
            return booleanPropertiesHolderImpl;
        }
        finally {
            stream.close();
        }
    }
}

