/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system.scriptbindings;

import java.util.Objects;
import org.cyclos.model.system.extensionpoints.ExtensionPointNature;
import org.cyclos.model.system.scripts.DefaultScriptFunction;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.system.scripts.ScriptType;

public class ScriptBindingKey {
    private final ScriptType type;
    private final ScriptFunction function;
    private final ExtensionPointNature extensionPoint;

    public ScriptBindingKey(ScriptType scriptType) {
        this(scriptType, (ScriptFunction)DefaultScriptFunction.DEFAULT, null);
    }

    public ScriptBindingKey(ScriptType scriptType, ScriptFunction scriptFunction) {
        this(scriptType, scriptFunction, null);
    }

    public ScriptBindingKey(ScriptType scriptType, ScriptFunction scriptFunction, ExtensionPointNature extensionPointNature) {
        this.type = scriptType;
        this.function = scriptFunction;
        this.extensionPoint = extensionPointNature;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScriptBindingKey scriptBindingKey = (ScriptBindingKey)object;
        return Objects.equals(this.extensionPoint, scriptBindingKey.extensionPoint) && Objects.equals(this.function, scriptBindingKey.function) && this.type == scriptBindingKey.type;
    }

    public ExtensionPointNature getExtensionPoint() {
        return this.extensionPoint;
    }

    public ScriptFunction getFunction() {
        return this.function;
    }

    public ScriptType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.extensionPoint, this.function, this.type);
    }

    public String toString() {
        return "ScriptBindingKey [type=" + String.valueOf(this.type) + ", function=" + String.valueOf(this.function) + ", extensionPoint=" + String.valueOf(this.extensionPoint) + "]";
    }
}

