/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.Map;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.impl.InvocationContext;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.system.exportformats.BuiltInExportFormat;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.SerializableInputStream;

public interface ExportHandler {
    public SerializableInputStream export(ExportParameters var1);

    public BuiltInExportFormat getBuiltInFormat();

    public static class ExportParameters {
        private ExportFormat format;
        private ExportFormatContext context;
        private QueryParameters queryParameters;
        private DataIterator<?> entities;
        private Object entity;
        private Map<String, Object> additionalData;

        public ExportParameters(ExportFormat exportFormat, ExportFormatContext exportFormatContext, Object object, Map<String, Object> map) {
            this.format = exportFormat;
            this.context = exportFormatContext;
            this.entity = object;
            this.additionalData = map;
        }

        public ExportParameters(ExportFormat exportFormat, ExportFormatContext exportFormatContext, QueryParameters queryParameters, DataIterator<?> dataIterator, Map<String, Object> map) {
            this.format = exportFormat;
            this.context = exportFormatContext;
            this.queryParameters = queryParameters;
            this.entities = InvocationContext.newCacheFlusher().wrap(dataIterator);
            this.additionalData = map;
        }

        public Map<String, Object> getAdditionalData() {
            return this.additionalData;
        }

        public <T> T getAdditionalData(String string) {
            return (T)(this.additionalData == null ? null : this.additionalData.get(string));
        }

        public ExportFormatContext getContext() {
            return this.context;
        }

        public DataIterator<?> getEntities() {
            return this.entities;
        }

        public Object getEntity() {
            return this.entity;
        }

        public ExportFormat getFormat() {
            return this.format;
        }

        public QueryParameters getQueryParameters() {
            return this.queryParameters;
        }

        public void setEntities(DataIterator<?> dataIterator) {
            this.entities = dataIterator;
        }
    }
}

