/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.sql.ProfilingStatement;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingQueryEvent;
import org.cyclos.model.system.profiling.StartProfilingParams;
import org.cyclos.server.utils.JsonConverter;

public class ProfilingPreparedStatement
extends ProfilingStatement
implements PreparedStatement {
    private final PreparedStatement delegate;
    private final JsonConverter jsonConverter;
    private ProfilingQueryEvent profilingQuery;

    public ProfilingPreparedStatement(StartProfilingParams startProfilingParams, ProfilingEntry profilingEntry, String string, PreparedStatement preparedStatement, boolean bl, JsonConverter jsonConverter) {
        super(startProfilingParams, profilingEntry, preparedStatement);
        this.delegate = preparedStatement;
        this.profilingQuery = new ProfilingQueryEvent(string);
        this.profilingQuery.setParameters(new ArrayList<Object>());
        if (bl) {
            this.profilingQuery.setCached(false);
        }
        this.jsonConverter = jsonConverter;
    }

    @Override
    public void addBatch() throws SQLException {
        this.batch.add(this.profilingQuery);
        this.profilingQuery = new ProfilingQueryEvent(this.profilingQuery.getSql());
        this.profilingQuery.setParameters(new ArrayList<Object>());
        this.delegate.addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.profilingQuery.getParameters().clear();
        this.delegate.clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            boolean bl = this.delegate.execute();
            return bl;
        }
        finally {
            this.finishExecution(null);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            ResultSet resultSet = this.delegate.executeQuery();
            return resultSet;
        }
        finally {
            this.finishExecution(null);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        int n = -1;
        try {
            int n2 = n = this.delegate.executeUpdate();
            return n2;
        }
        finally {
            this.finishExecution(n);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.delegate.getParameterMetaData();
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.addParameter(n, array);
        this.delegate.setArray(n, array);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.addParameter(n, inputStream);
        this.delegate.setAsciiStream(n, inputStream);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.addParameter(n, inputStream);
        this.delegate.setAsciiStream(n, inputStream, n2);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.addParameter(n, inputStream);
        this.delegate.setAsciiStream(n, inputStream, l);
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.addParameter(n, bigDecimal);
        this.delegate.setBigDecimal(n, bigDecimal);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.addParameter(n, inputStream);
        this.delegate.setBinaryStream(n, inputStream);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.addParameter(n, inputStream);
        this.delegate.setBinaryStream(n, inputStream, n2);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.addParameter(n, inputStream);
        this.delegate.setBinaryStream(n, inputStream, l);
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.addParameter(n, blob);
        this.delegate.setBlob(n, blob);
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.addParameter(n, "<input-stream>");
        this.delegate.setBlob(n, inputStream);
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.addParameter(n, "<input-stream>");
        this.delegate.setBlob(n, inputStream, l);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.addParameter(n, bl);
        this.delegate.setBoolean(n, bl);
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.addParameter(n, by);
        this.delegate.setByte(n, by);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.addParameter(n, byArray);
        this.delegate.setBytes(n, byArray);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.addParameter(n, "<reader>");
        this.delegate.setCharacterStream(n, reader);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.addParameter(n, "<reader>");
        this.delegate.setCharacterStream(n, reader, n2);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.addParameter(n, "<reader>");
        this.delegate.setCharacterStream(n, reader, l);
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.addParameter(n, clob);
        this.delegate.setClob(n, clob);
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.addParameter(n, "<reader>");
        this.delegate.setClob(n, reader);
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.addParameter(n, "<reader>");
        this.delegate.setClob(n, reader, l);
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.addParameter(n, date);
        this.delegate.setDate(n, date);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.addParameter(n, date);
        this.delegate.setDate(n, date, calendar);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.addParameter(n, d);
        this.delegate.setDouble(n, d);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.addParameter(n, Float.valueOf(f));
        this.delegate.setFloat(n, f);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.addParameter(n, n2);
        this.delegate.setInt(n, n2);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.addParameter(n, l);
        this.delegate.setLong(n, l);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.addParameter(n, "<reader>");
        this.delegate.setNCharacterStream(n, reader);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.addParameter(n, "<reader>");
        this.delegate.setNCharacterStream(n, reader, l);
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.addParameter(n, "<nclob>");
        this.delegate.setNClob(n, nClob);
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.addParameter(n, "<reader>");
        this.delegate.setNClob(n, reader);
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.addParameter(n, "<reader>");
        this.delegate.setNClob(n, reader, l);
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.addParameter(n, string);
        this.delegate.setNString(n, string);
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.addParameter(n, null);
        this.delegate.setNull(n, n2);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.addParameter(n, null);
        this.delegate.setNull(n, n2, string);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.addParameter(n, object);
        this.delegate.setObject(n, object);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.addParameter(n, object);
        this.delegate.setObject(n, object, n2);
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.addParameter(n, object);
        this.delegate.setObject(n, object, n2, n3);
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType) throws SQLException {
        this.addParameter(n, object);
        this.delegate.setObject(n, object, sQLType);
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        this.addParameter(n, object);
        this.delegate.setObject(n, object, sQLType, n2);
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.addParameter(n, ref);
        this.delegate.setRef(n, ref);
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.addParameter(n, rowId);
        this.delegate.setRowId(n, rowId);
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.addParameter(n, s);
        this.delegate.setShort(n, s);
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.addParameter(n, "<xml>");
        this.delegate.setSQLXML(n, sQLXML);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.addParameter(n, string);
        this.delegate.setString(n, string);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.addParameter(n, time);
        this.delegate.setTime(n, time);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.addParameter(n, time);
        this.delegate.setTime(n, time, calendar);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.addParameter(n, timestamp);
        this.delegate.setTimestamp(n, timestamp);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.addParameter(n, timestamp);
        this.delegate.setTimestamp(n, timestamp, calendar);
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.addParameter(n, inputStream);
        this.delegate.setUnicodeStream(n, inputStream, n2);
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.addParameter(n, uRL);
        this.delegate.setURL(n, uRL);
    }

    private void addParameter(int n, Object object) {
        List<Object> list = this.profilingQuery.getParameters();
        while (list.size() < n) {
            list.add(null);
        }
        list.set(n - 1, RequestContext.get().isSensitiveQueryParamValue(object) ? "****" : this.jsonConverter.toLogNode(object, false));
    }

    private void finishExecution(Integer n) {
        this.profilingQuery.end();
        if (n != null && n >= 0) {
            this.profilingQuery.setRowsUpdated(n);
        }
        this.profilingEntry.addEvent(this.profilingQuery);
    }
}

