/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.utils.CollectionHelper;

public class DatabaseCachingMetadata {
    private Set<String> cacheableTables = new HashSet<String>();
    private Map<String, List<String>> manyToManyTables = new HashMap<String, List<String>>();
    private Map<String, List<String>> inverseManyToManyTables = new HashMap<String, List<String>>();

    public void addCacheableTable(String string) {
        if (string != null) {
            this.cacheableTables.add(string.toLowerCase());
        }
    }

    public void addManyToManyCacheableTable(String string, List<String> list) {
        if (CollectionHelper.isEmpty(list)) {
            throw new IllegalStateException("Many to many needs some related tables");
        }
        List list2 = CollectionHelper.orEmpty(list).stream().map(String::toLowerCase).collect(Collectors.toList());
        this.manyToManyTables.put(string.toLowerCase(), list2);
        for (String string2 : list2) {
            List<String> list3 = this.inverseManyToManyTables.get(string2);
            if (list3 == null) {
                list3 = new ArrayList<String>();
                this.inverseManyToManyTables.put(string2, list3);
            }
            list3.add(string);
        }
    }

    public Set<String> getCacheableTables() {
        return this.cacheableTables;
    }

    public List<String> getInverseDependencies(String string) {
        return this.inverseManyToManyTables.get(string);
    }

    public Map<String, List<String>> getManyToManyTables() {
        return this.manyToManyTables;
    }

    public boolean isCacheable(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        return this.cacheableTables.contains(string2) || this.manyToManyTables.containsKey(string2);
    }

    public boolean isManyToManyCacheable(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toLowerCase();
        return this.manyToManyTables.containsKey(string2);
    }
}

