/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.impl.NetworkAccessProxy;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.AccountHistoryEntry;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.search.TransferSearchHandler;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountStatusVO;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.TransferDirection;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

public class AccountWrapper
implements ProcessableForProxying {
    private Account account;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private AccountHandler accountHandler;
    @Autowired
    private TransferSearchHandler transferSearchHandler;
    private AccountStatusVO status;

    public AccountWrapper(Account account) {
        this.account = account;
    }

    protected AccountWrapper() {
    }

    public Account getAccount() {
        return this.account;
    }

    public BigDecimal getARate() {
        return this.getStatus().getARate();
    }

    public BigDecimal getAvailableBalance() {
        return this.getStatus().getAvailableBalance();
    }

    public BigDecimal getBalance() {
        return this.getStatus().getBalance();
    }

    public BigDecimal getCreditLimit() {
        return this.getStatus().getCreditLimit();
    }

    public Currency getCurrency() {
        return this.account.getCurrency();
    }

    public BigDecimal getDRate() {
        return this.getStatus().getDRate();
    }

    public DateTime getNegativeSince() {
        return this.getStatus().getNegativeSince();
    }

    public String getNumber() {
        return this.accountHandler.getAccountNumber((IAccount)this.account);
    }

    public BigDecimal getRateBalanceCorrection() {
        return this.getStatus().getRateBalanceCorrection();
    }

    public BigDecimal getReservedAmount() {
        return this.getStatus().getReservedAmount();
    }

    public AccountStatusVO getStatus() {
        if (this.status == null) {
            this.status = this.accountService.getAccountStatus(this.account, null, null);
            if (this.status == null) {
                this.status = new AccountStatusVO();
            }
        }
        return this.status;
    }

    public AccountType getType() {
        return this.account.getType();
    }

    public BigDecimal getVirtualRatedBalance() {
        return this.getStatus().getVirtualRatedBalance();
    }

    @NetworkAccessProxy.AllowedInProxy
    public List<AccountHistoryEntry> lastCredits(int n) {
        return this.lastTransfers(n, TransferDirection.CREDIT);
    }

    @NetworkAccessProxy.AllowedInProxy
    public List<AccountHistoryEntry> lastDebits(int n) {
        return this.lastTransfers(n, TransferDirection.DEBIT);
    }

    @NetworkAccessProxy.AllowedInProxy
    public List<AccountHistoryEntry> lastTransfers(int n) {
        return this.lastTransfers(n, null);
    }

    private List<AccountHistoryEntry> lastTransfers(int n, TransferDirection transferDirection) {
        if (this.account.isTransient()) {
            return Collections.emptyList();
        }
        AccountHistoryQuery accountHistoryQuery = new AccountHistoryQuery();
        accountHistoryQuery.setDirection(transferDirection);
        accountHistoryQuery.setAccount(new AccountVO(this.account.getId()));
        try (DataIterator<AccountHistoryEntry> dataIterator = this.transferSearchHandler.exportAccountHistory(accountHistoryQuery);){
            ArrayList<AccountHistoryEntry> arrayList = new ArrayList<AccountHistoryEntry>(n);
            while (dataIterator.hasNext() && arrayList.size() < n) {
                arrayList.add((AccountHistoryEntry)dataIterator.next());
            }
            ArrayList<AccountHistoryEntry> arrayList2 = arrayList;
            return arrayList2;
        }
    }
}

