/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountBalanceLimitLog;
import org.cyclos.entities.banking.AccountLocator;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.CustomAmountReservation;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.ExternalPaymentAmountReservation;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.InstallmentAmountReservation;
import org.cyclos.entities.banking.OrderAmountReservation;
import org.cyclos.entities.banking.PendingAuthorizationAmountReservation;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.ScheduledPaymentAmountReservation;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.entities.banking.SystemAccount;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.TicketAmountReservation;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherAmountReservation;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.banking.VoucherPackAmountReservation;
import org.cyclos.entities.banking.VoucherTransaction;
import org.cyclos.entities.banking.VoucherTransactionAmountReservation;
import org.cyclos.entities.banking.VoucherUnblockAmountReservation;
import org.cyclos.entities.marketplace.Order;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.banking.ChargebackDescriptionFiller;
import org.cyclos.impl.banking.NativeAccountStatus;
import org.cyclos.impl.banking.RestrictedOperatorAccessibleAccounts;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.utils.conversion.VOFiller;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.LockAcquisitionException;
import org.cyclos.model.banking.InsufficientBalanceException;
import org.cyclos.model.banking.TransSearchContext;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountHistoryStatusVO;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountPermissionsData;
import org.cyclos.model.banking.accounts.AccountStatusVO;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.AccountWithStatusVO;
import org.cyclos.model.banking.accounts.ITransSearchData;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.rates.RateVisibility;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.users.users.UserAccountData;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.utils.PeriodPreselectorOptionData;
import org.cyclos.server.model.app.FrontendDashboardAccountVO;
import org.cyclos.services.banking.AccountService;

public interface AccountServiceLocal
extends AccountService {
    public static final String ACCOUNT_PREFIX = "account";
    public static final Set<UserStatus> POSSIBLE_STATUSES_TO_OWN_ACCOUNTS = Collections.unmodifiableSet(EnumSet.of(UserStatus.ACTIVE, UserStatus.BLOCKED, UserStatus.DISABLED));
    public static final String ATTR_ACCOUNT = "account";
    public static final String ATTR_ACCOUNT_TYPE = "type";
    public static final String ATTR_OWNER = "owner";
    public static final String EXPORT = "export";

    public boolean accountNumberExistsOrIsReserved(AccountNumberConfiguration var1, String var2);

    default public AdjustAccountsResult adjustAccounts(User user) {
        return this.adjustAccounts(user, false);
    }

    public AdjustAccountsResult adjustAccounts(User var1, boolean var2);

    public void applyQueryConstraints(AbstractTransQuery var1);

    public void checkActive(Account var1) throws IllegalActionException;

    public void checkActive(AccountOwner var1) throws IllegalActionException;

    public void checkAvailableBalance(Account var1, BigDecimal var2) throws InsufficientBalanceException, LockAcquisitionException;

    public SystemAccount createSystemAccount(SystemAccountType var1);

    public ExternalPaymentAmountReservation dereserveAmount(ExternalPayment var1);

    public OrderAmountReservation dereserveAmount(Order var1);

    public InstallmentAmountReservation dereserveAmount(ScheduledPaymentInstallment var1);

    public TicketAmountReservation dereserveAmount(Ticket var1);

    public PendingAuthorizationAmountReservation dereserveAmountForAuthorization(BasePayment var1);

    public VoucherAmountReservation dereserveAmountIfNeeded(Voucher var1);

    public void fillTransSearchData(ITransSearchData var1, Account var2, InternalAccountOwner var3, ExportFormatContext var4, TransSearchContext var5);

    public Account findByNumber(String var1);

    public String generateNumber(AccountType var1, InternalAccountOwner var2);

    public AccountHistoryStatusVO getAccountHistoryStatus(Account var1, AccountHistoryQuery var2);

    public Set<Long> getAccountIdsWithTransactions(Set<UserAccountType> var1, User var2);

    public AccountStatusVO getAccountStatus(Account var1, Date var2, RateVisibility var3);

    public List<AccountWithStatusVO> getAccountsWithStatus(InternalAccountOwner var1, Date var2, Date var3, boolean var4);

    public OrderAmountReservation getAmountDereservation(Order var1);

    public PendingAuthorizationAmountReservation getAmountDereservationForAuthorization(BasePayment var1);

    public OrderAmountReservation getAmountReservation(Order var1);

    public PendingAuthorizationAmountReservation getAmountReservationForAuthorization(BasePayment var1);

    public BigDecimal getAvailableBalance(Account var1, Date var2);

    public BigDecimal getAverageBalance(Account var1, BigDecimal var2, DatePeriod var3, boolean var4, BigDecimal var5);

    public BigDecimal getBalance(Account var1, Date var2);

    public AccountBalanceLimitLog getBalanceLimitLog(Account var1, Date var2);

    public BigDecimal getCreditLimit(Account var1, Date var2);

    public BigDecimal getCurrentAvailableBalance(Account var1, NativeAccountStatus var2);

    public FrontendDashboardAccountVO getFrontendDashbordAcccount(Account var1, int var2);

    public List<TransferStatusFlow> getManagedFlows(Account var1);

    public NativeAccountStatus getNativeAccountStatus(Account var1, Date var2);

    public String getOwnerName(Account var1);

    public AccountPermissionsData getPermissions(@NotNull Account var1);

    public RestrictedOperatorAccessibleAccounts getRetrictedOperatorAccessibleAccounts();

    public BigDecimal getUpperCreditLimit(Account var1, Date var2);

    public List<UserAccountData> getUserAccountsData(User var1);

    public Map<UserAccountType, Boolean> getVisibilitySettings(BasicUser var1);

    public List<TransferStatusFlow> getVisibleFlows(Account var1);

    public boolean hasTransfers(Account var1);

    public boolean isActive(IAccount var1);

    public boolean isUserAccountVisibleBySettings(UserAccountType var1, MemberProductAccessor var2, Map<UserAccountType, Boolean> var3);

    public <A extends Account> List<A> listVisible(InternalAccountOwner var1);

    public List<Currency> listVisibleCurrencies(InternalAccountOwner var1);

    public List<Currency> listVisibleOrGrantedCurrencies(User var1);

    public <A extends AccountType> List<A> listVisibleTypes(InternalAccountOwner var1);

    public <A extends Account> A load(AccountLocator var1);

    public <A extends Account> A load(InternalAccountOwner var1, AccountType var2);

    public <A extends Account> A load(InternalAccountOwner var1, AccountType var2, boolean var3);

    public <A extends Account> A load(InternalAccountOwner var1, String var2);

    public void makeBalanceDirty(Account var1, Transfer var2);

    public ChargebackDescriptionFiller newChargebackDescriptionFiller();

    public <Q extends AbstractTransQuery> Q newQuery(Class<Q> var1, List<CustomFieldDetailedVO> var2);

    public VOFiller<AccountVO> newVOFiller();

    public VoucherTransactionAmountReservation processReservationIfNeeded(VoucherTransaction var1);

    public void reactivateAccounts(long var1, long var3);

    public void removeLastClosedAccountBalances(Transfer var1);

    public <A extends Account> A require(InternalAccountOwner var1, AccountType var2);

    public VoucherAmountReservation reReserveAmountIfNeeded(Voucher var1);

    public CustomAmountReservation reserveAmount(Account var1, BigDecimal var2);

    public CustomAmountReservation reserveAmount(Account var1, BigDecimal var2, boolean var3);

    public ExternalPaymentAmountReservation reserveAmount(ExternalPayment var1);

    public OrderAmountReservation reserveAmount(Order var1);

    public ScheduledPaymentAmountReservation reserveAmount(ScheduledPayment var1);

    public TicketAmountReservation reserveAmount(Ticket var1);

    public PendingAuthorizationAmountReservation reserveAmountForAuthorization(PerformTransactionDTO var1, BasePayment var2);

    public VoucherUnblockAmountReservation reserveAmountForUnblocking(Voucher var1);

    public VoucherPackAmountReservation reserveAmountIfNeeded(VoucherPack var1);

    public List<PeriodPreselectorOptionData> resolvePreselectedPeriods(boolean var1);

    public void sendStatusPushNotification(Account var1);

    public boolean shouldAdjustAccountsWhenAssigning(MemberProduct var1);

    public AccountWithStatusVO toAccountWithStatus(Account var1, Date var2, Date var3, boolean var4);

    public void updateBalance(Account var1, BigDecimal var2, Long[] var3);

    public static class AdjustAccountsResult {
        private int canceledOrders = 0;
        private int disabledAds = 0;
        private int disabledDeliveryMethods = 0;
        private List<Currency> disposedCurrencies = Collections.emptyList();
        private List<UserAccountType> disposedAccounts = Collections.emptyList();
        private List<UserAccountType> createdAccounts = Collections.emptyList();
        private List<UserAccountType> activatedAccounts = Collections.emptyList();
        private List<String> newAccountNumbers = Collections.emptyList();

        public List<UserAccountType> getActivatedAccounts() {
            return this.activatedAccounts;
        }

        public int getCanceledOrders() {
            return this.canceledOrders;
        }

        public List<UserAccountType> getCreatedAccounts() {
            return this.createdAccounts;
        }

        public int getDisabledAds() {
            return this.disabledAds;
        }

        public int getDisabledDeliveryMethods() {
            return this.disabledDeliveryMethods;
        }

        public List<UserAccountType> getDisposedAccounts() {
            return this.disposedAccounts;
        }

        public List<Currency> getDisposedCurrencies() {
            return this.disposedCurrencies;
        }

        public List<String> getNewAccountNumbers() {
            return this.newAccountNumbers;
        }

        public boolean isEmptyResult() {
            return this.disposedCurrencies.isEmpty() && this.disposedAccounts.isEmpty() && this.createdAccounts.isEmpty() && this.activatedAccounts.isEmpty() && this.newAccountNumbers.isEmpty() && this.canceledOrders == 0 && this.disabledAds == 0 && this.disabledDeliveryMethods == 0;
        }

        public void setActivatedAccounts(List<UserAccountType> list) {
            this.activatedAccounts = list;
        }

        public void setCanceledOrders(int n) {
            this.canceledOrders = n;
        }

        public void setCreatedAccounts(List<UserAccountType> list) {
            this.createdAccounts = list;
        }

        public void setDisabledAds(int n) {
            this.disabledAds = n;
        }

        public void setDisabledDeliveryMethods(int n) {
            this.disabledDeliveryMethods = n;
        }

        public void setDisposedAccounts(List<UserAccountType> list) {
            this.disposedAccounts = list;
        }

        public void setDisposedCurrencies(List<Currency> list) {
            this.disposedCurrencies = list;
        }

        public void setNewAccountNumbers(List<String> list) {
            this.newAccountNumbers = list;
        }
    }
}

