/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import org.cyclos.entities.access.BaseOidcClient;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.OidcClientServiceLocal;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.UserSessionData;
import org.cyclos.impl.users.OidcProductsAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProductsHandler;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.clients.AccessClientVO;
import org.cyclos.model.access.login.UserAuthVO;

public class OidcSessionData
extends UserSessionData {
    private final String accessToken;
    private OidcAccessToken token;

    OidcSessionData(String string, RequestData requestData) {
        super(requestData);
        this.accessToken = string;
    }

    @Override
    public String getAccessChannelName() {
        return this.getChannelName();
    }

    @Override
    public OidcAccessToken getAccessToken() {
        if (this.token == null) {
            this.token = this.runAsSystem(() -> {
                SessionHandler sessionHandler = InvocationContext.bean(SessionHandler.class);
                return sessionHandler.checkOidcAccessToken(this.getNetwork(), this.getRemoteAddress(), this.accessToken);
            });
        }
        return this.token;
    }

    @Override
    public UserAuthVO getAuthenticatedUser() {
        UserAuthVO userAuthVO = super.getAuthenticatedUser();
        if (userAuthVO != null) {
            ConversionHandler conversionHandler = InvocationContext.bean(ConversionHandler.class);
            userAuthVO.setAccessClient(conversionHandler.convert(AccessClientVO.class, this.getAccessClient()));
        }
        return userAuthVO;
    }

    @Override
    public String getChannelName() {
        return BuiltInChannel.OIDC.getInternalName();
    }

    @Override
    public Pin getPin() {
        return null;
    }

    @Override
    protected Long doGetLoggedBasicUserId() {
        return this.doGetUserPrincipal().getBasicUser().getId();
    }

    @Override
    protected UserPrincipal doGetUserPrincipal() {
        return this.getAccessToken().getAuthorization();
    }

    @Override
    protected boolean doHasExpiredPassword() {
        return false;
    }

    @Override
    protected boolean requiresLoginConfirmation(CredentialsConfiguration credentialsConfiguration) {
        return false;
    }

    @Override
    protected ProductsAccessor resolveProductsAccessor(ProductsHandler productsHandler) {
        ProductsAccessor productsAccessor = super.resolveProductsAccessor(productsHandler);
        OidcAccessToken oidcAccessToken = this.getAccessToken();
        BaseOidcClient baseOidcClient = oidcAccessToken.getAuthorization().getClient();
        OidcClientServiceLocal oidcClientServiceLocal = InvocationContext.bean(OidcClientServiceLocal.class);
        return new OidcProductsAccessor(oidcAccessToken, oidcClientServiceLocal.getAccessor(baseOidcClient), productsAccessor);
    }
}

