/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.HashSet;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.access.AbstractSessionData;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionDataSubjectId;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.EmptyProductsAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.model.access.InvalidChannelUsageException;
import org.cyclos.model.access.InvalidSessionDataException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.login.UserAuthVO;
import org.cyclos.utils.StringHelper;

public class GuestSessionData
extends AbstractSessionData {
    private final String channelName;
    private final String accessChannelName;
    private Long publicRegisteredUserId;

    GuestSessionData(RequestData requestData, String string, String string2) {
        super(requestData);
        this.channelName = string;
        this.accessChannelName = string2;
    }

    @Override
    public void checkConsistency() throws InvalidSessionDataException {
        super.checkConsistency();
        Configuration configuration = this.getConfigurationEntity();
        if (!configuration.isForGuests()) {
            throw new InvalidChannelUsageException();
        }
    }

    @Override
    public String getAccessChannelName() {
        return this.accessChannelName;
    }

    @Override
    public AccessClient getAccessClient() {
        return null;
    }

    @Override
    public Set<BasicGroup> getAccessibleBasicGroups() {
        ConfigurationAccessor configurationAccessor = this.getConfiguration();
        HashSet<BasicGroup> hashSet = new HashSet<BasicGroup>(configurationAccessor.getGroupsForUserSearch());
        hashSet.addAll(configurationAccessor.getGroupsForViewProfile());
        hashSet.addAll(configurationAccessor.getGroupsForUserDirectory());
        hashSet.addAll(configurationAccessor.getVisibleAdGroups());
        return hashSet;
    }

    @Override
    public UserAuthVO getAuthenticatedUser() {
        return null;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public Group getGroup() {
        return null;
    }

    @Override
    public BasicUser getLoggedBasicUser() {
        return null;
    }

    @Override
    public PrincipalType getPrincipalType() {
        return null;
    }

    public Long getPublicRegisteredUserId() {
        return this.publicRegisteredUserId;
    }

    @Override
    public boolean hasRequiredValue(Permission permission, Object object) {
        return false;
    }

    @Override
    public boolean isGuest() {
        return true;
    }

    @Override
    public boolean isVisible(EntityCheck<SimpleEntity> entityCheck, SimpleEntity simpleEntity) {
        return entityCheck.isVisible(this, simpleEntity);
    }

    @Override
    public boolean manages(BasicUser basicUser) {
        return this.publicRegisteredUserId != null && this.publicRegisteredUserId.equals(SimpleEntity.id((SimpleEntity)basicUser));
    }

    @Override
    public boolean relatesTo(BasicUser basicUser) {
        if (!(basicUser instanceof User)) {
            return false;
        }
        User user = (User)basicUser;
        Long l = user.getId();
        if (l != null && l.equals(this.publicRegisteredUserId)) {
            return true;
        }
        Group group = user.getGroup();
        GroupSet groupSet = group instanceof UserGroup ? ((UserGroup)group).getGroupSet() : null;
        Set<BasicGroup> set = this.getAccessibleBasicGroups();
        return set.contains(group) || set.contains(groupSet);
    }

    public void setPublicRegisteredUserId(Long l) {
        this.publicRegisteredUserId = l;
    }

    public String toString() {
        Long l = this.requestData.getConfigurationId();
        return "GUEST" + (String)(StringHelper.isBlank((Object)l) ? "" : "[Configuration#" + l + "]");
    }

    @Override
    protected Long doGetConfigurationId() {
        return this.requestData.getConfigurationId();
    }

    @Override
    protected ProductsAccessor doGetProducts() {
        return EmptyProductsAccessor.getInstance();
    }

    @Override
    protected SessionDataSubjectId doGetSubjectId() {
        return SessionDataSubjectId.guest(this.getConfigurationEntity());
    }

    @Override
    protected boolean doHasPermission(Permission permission) {
        return false;
    }
}

