/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.cyclos.entities.HasNetwork;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IllegalActionException;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;

public class NetworkAccessProxy {
    private static final Map<Class<?>, Class<?>> CLASS_CACHE = new WeakHashMap();

    public static final <T> T proxy(T t) {
        return NetworkAccessProxy.proxy(t, new IdentityHashMap<Object, Proxy>());
    }

    public static <T> T proxy(T t, IdentityHashMap<Object, Proxy> identityHashMap) {
        if (t == null || t instanceof Proxy) {
            return t;
        }
        Proxy proxy = identityHashMap.get(t);
        if (proxy != null) {
            return (T)proxy;
        }
        if (t instanceof HasNetwork) {
            SessionData sessionData = InvocationContext.getSessionData();
            Network network = ((HasNetwork)t).getNetwork();
            Network network2 = sessionData.getNetwork();
            if (!(Objects.equals(network2, network) || sessionData.isGlobalAdmin() || network == null || network2 == null && ((AdminGroup)sessionData.getLoggedUser().getGroup()).getManagedNetworks().contains(network))) {
                throw new IllegalActionException("Attempt to access an entity without permission: " + String.valueOf(t));
            }
        }
        if (t instanceof ProcessableForProxying) {
            proxy = (Proxy)ClassHelper.instantiate(NetworkAccessProxy.getProxyClass(((ProcessableForProxying)t).getProxyClass()));
            if (t instanceof SimpleEntity) {
                FieldHelper.set((Object)proxy, (String)EntityVO.ID.getName(), (Object)((SimpleEntity)t).getId());
            }
            proxy.setHandler((MethodHandler)new NetworkAccessMethodHandler(t, identityHashMap));
            identityHashMap.put(t, proxy);
            return (T)proxy;
        }
        return t;
    }

    public static final <T> T unproxy(Object object) {
        MethodHandler methodHandler;
        if (object instanceof Proxy && (methodHandler = ProxyFactory.getHandler((Proxy)((Proxy)object))) instanceof NetworkAccessMethodHandler) {
            return (T)((NetworkAccessMethodHandler)methodHandler).delegate;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Class<?> getProxyClass(Class<?> clazz) {
        Class clazz2 = CLASS_CACHE.get(clazz);
        if (clazz2 == null) {
            Map<Class<?>, Class<?>> map = CLASS_CACHE;
            synchronized (map) {
                clazz2 = CLASS_CACHE.get(clazz);
                if (clazz2 == null) {
                    ProxyFactory proxyFactory = new ProxyFactory();
                    if (clazz.isInterface()) {
                        proxyFactory.setSuperclass(Object.class);
                        proxyFactory.setInterfaces(new Class[]{clazz});
                    } else {
                        proxyFactory.setSuperclass(clazz);
                    }
                    clazz2 = proxyFactory.createClass();
                    CLASS_CACHE.put(clazz, clazz2);
                }
            }
        }
        return clazz2;
    }

    private static class NetworkAccessMethodHandler
    implements MethodHandler {
        private final Object delegate;
        private final IdentityHashMap<Object, Proxy> resolved;

        public NetworkAccessMethodHandler(Object object, IdentityHashMap<Object, Proxy> identityHashMap) {
            this.delegate = object;
            this.resolved = identityHashMap;
        }

        public Object invoke(Object object, Method method, Method method2, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals("toString") && objectArray.length == 0) {
                return "Proxy for " + String.valueOf(this.delegate);
            }
            if (string.equals("equals") && objectArray.length == 1) {
                return this.delegate.equals(objectArray[0]);
            }
            if (string.equals("hashCode") && objectArray.length == 0) {
                return this.delegate.hashCode();
            }
            if (string.equals("finalize") && objectArray.length == 0) {
                return ((Method)ObjectHelper.defaultValue((Object)method2, (Object)method)).invoke(this.delegate, new Object[0]);
            }
            if (!(method.isAnnotationPresent(AllowedInProxy.class) || objectArray.length == 0 && (string.startsWith("is") && Boolean.TYPE.equals(method.getReturnType()) || string.startsWith("get") && !Void.TYPE.equals(method.getReturnType())))) {
                throw new IllegalActionException("Cannot access a non-getter method of " + String.valueOf(this.delegate) + ": " + method.toString());
            }
            Object object2 = method.invoke(this.delegate, objectArray);
            if (object2 instanceof Collection && CollectionHelper.isEmpty((Iterable)((Collection)object2))) {
                return object2;
            }
            if (object2 instanceof Map && CollectionHelper.isEmpty((Map)((Map)object2))) {
                return object2;
            }
            if (object2 instanceof List) {
                return ((List)object2).stream().map(this::doProxy).collect(Collectors.toList());
            }
            if (object2 instanceof Set) {
                Set set = (Set)ClassHelper.instantiate(object2.getClass(), HashSet::new);
                return ((Set)object2).stream().map(this::doProxy).collect(Collectors.toCollection(() -> set));
            }
            if (object2 instanceof Map) {
                Map map2 = (Map)ClassHelper.instantiate(object2.getClass(), HashMap::new);
                return ((Map)object2).entrySet().stream().collect(() -> map2, (map, entry) -> map.put(this.doProxy(entry.getKey()), this.doProxy(entry.getValue())), Map::putAll);
            }
            return this.doProxy(object2);
        }

        private <T> T doProxy(T t) {
            return NetworkAccessProxy.proxy(t, this.resolved);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface AllowedInProxy {
    }
}

