/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.thymeleaf;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldValue;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.thymeleaf.DecimalsExpressionObject;
import org.cyclos.impl.utils.thymeleaf.ThymeleafExpressionObject;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.currencies.ICurrency;
import org.cyclos.model.banking.rates.FormattableTimeBasedRate;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.IDate;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FormatExpressionObject
implements ThymeleafExpressionObject {
    @Autowired
    private LocalizationServiceLocal localizationService;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private InitializationServiceLocal initializationService;
    @Autowired
    private EntityManagerHandler entityManagerHandler;
    @Autowired
    private DecimalsExpressionObject decimalsExpressionObject;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private ConversionHandler conversionHandler;

    public String adCategories(BasicAd basicAd) {
        FormatterImpl formatterImpl = this.getFormatter();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (AdCategory adCategory : basicAd.getCategories()) {
            treeSet.add(adCategory.getPathFromRoot().stream().map(arg_0 -> ((FormatterImpl)formatterImpl).format(arg_0)).collect(Collectors.joining(" > ")));
        }
        return CollectionHelper.join(treeSet, (String)"\n");
    }

    public String amount(Object object, Object object2) {
        Currency currency = null;
        if (object instanceof Currency) {
            currency = (Currency)object;
        } else if (object instanceof HasCurrency) {
            currency = ((HasCurrency)object).getCurrency();
        } else if (object instanceof ICurrency) {
            currency = (ICurrency)object;
        } else if (object instanceof CharSequence) {
            currency = (ICurrency)this.entityManagerHandler.find(Currency.class, object.toString());
        }
        return this.getFormatter().format((ICurrency)currency, this.decimalsExpressionObject.decimal(object2));
    }

    public String country(String string) {
        return string == null ? "" : this.localizationService.getCountryName(string);
    }

    public String customValue(CustomField<?, ?, ?> customField, Object object) {
        CustomFieldValue customFieldValue = null;
        if (object instanceof CustomFieldValue) {
            customFieldValue = (CustomFieldValue)object;
        } else {
            Collection collection = null;
            if (object instanceof Collection) {
                collection = (Collection)object;
            } else if (object instanceof EntityWithCustomValues) {
                EntityWithCustomValues entityWithCustomValues = (EntityWithCustomValues)object;
                collection = entityWithCustomValues.getCustomValues();
            }
            customFieldValue = (CustomFieldValue)CustomFieldHelper.findValue(customField, (Collection)collection);
        }
        return this.getFormatter().format(customFieldValue);
    }

    public String date(Object object) {
        if (object instanceof Date) {
            return this.getFormatter().formatAsDate((Date)object);
        }
        if (object instanceof IDate) {
            return this.getFormatter().formatAsDate((IDate)object);
        }
        return null;
    }

    public String dateTime(Object object) {
        if (object instanceof Date) {
            return this.getFormatter().format((Date)object);
        }
        if (object instanceof IDate) {
            return this.getFormatter().format((IDate)object);
        }
        return null;
    }

    @Override
    public String getName() {
        return "format";
    }

    public String maskId(Object object) {
        Long l = this.applicationHandler.getIdMask().apply(object);
        return l == null ? "" : l.toString();
    }

    public String nlToBr(String string) {
        return StringHelper.convertNewLineToBr((String)string);
    }

    public String number(Object object, int n) {
        return this.getFormatter().format(this.decimalsExpressionObject.decimal(object), n);
    }

    public String object(Object object) {
        return this.getFormatter().format(object);
    }

    public String objectOrDate(Object object) {
        if (object instanceof Date || object instanceof IDate) {
            return this.date(object);
        }
        return this.getFormatter().format(object);
    }

    public String percentage(Object object, int n) {
        BigDecimal bigDecimal = this.decimalsExpressionObject.decimal(object);
        return bigDecimal == null ? "" : this.getFormatter().formatPercentage(Double.valueOf(bigDecimal.doubleValue()), n);
    }

    public String profileField(ProfileField profileField, BasicUser basicUser) {
        Object object = this.profileFieldHandler.getSingleFieldValue(basicUser, profileField);
        return this.getFormatter().format(object);
    }

    public String rate(BigDecimal bigDecimal) {
        return bigDecimal == null ? "" : this.getFormatter().format(new FormattableTimeBasedRate(bigDecimal));
    }

    public String relatedAccount(AccountVO accountVO) {
        return this.getFormatter().formatRelated(accountVO);
    }

    public String truncate(Object object, int n) {
        return object == null ? "" : StringHelper.truncate((String)object.toString(), (int)n);
    }

    public String url(Image image) {
        if (image == null) {
            return null;
        }
        ImageVO imageVO = (ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)image);
        URI uRI = ServerImageHelper.imageURI((ImageVO)imageVO, (RequestData)this.getSesssionData().getRequestData(), (String)this.initializationService.getResourceCacheKey());
        return uRI == null ? "" : uRI.toASCIIString();
    }

    public String var(String string) {
        SessionData sessionData = InvocationContext.getSessionData();
        if (!sessionData.isLoggedIn()) {
            return null;
        }
        Function function = this.profileFieldHandler.getUserVariablesFunction(sessionData.getLoggedBasicUser());
        return (String)function.apply(string);
    }

    private FormatterImpl getFormatter() {
        InvocationContext invocationContext = InvocationContext.ensure();
        return invocationContext.formatter(invocationContext.sessionData().getConfiguration());
    }

    private SessionData getSesssionData() {
        return InvocationContext.getSessionData();
    }
}

